/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.SortedListModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.PermissionNewuserDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PrincipalUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class PermissionDialog
extends JDialog
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private int dialogwidth = 780;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private static final String DEFAULT_SOURCE_CHOICE_LABEL = "Available Permissions";
    private static final String DEFAULT_DEST_CHOICE_LABEL = "Assigned Permissions";
    private static final String ADD_BUTTON_LABEL = "Add >>";
    private static final String REMOVE_BUTTON_LABEL = "<< Remove";
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private JComboBox<String> principalcomboBox;
    private int returnvalue;
    private JPanel detialpanel = new JPanel();
    private JList<String> sourceList;
    private JList<String> destList;
    private SortedListModel sourceListModel;
    private SortedListModel destListModel;
    private JButton removeButton;
    private JLabel destLabel;
    private ClientPrimaryDataEntity dataentry = null;
    private List<GrantableMethods.Methods> allavailablemethods = new ArrayList<GrantableMethods.Methods>();
    private List<String> methods = new ArrayList<String>();
    private List<String> userprincipals = new ArrayList<String>();
    private List<String> users = new ArrayList<String>();
    private List<String> principals = new ArrayList<String>();
    private ClientDataManager client;
    private LinkedHashSet<String> todoprincipals = new LinkedHashSet();
    private Action okAction = new AbstractAction("Ok"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PermissionDialog.this.todoprincipals.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String str : PermissionDialog.this.todoprincipals) {
                    sb.append(str);
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                int dialogButton = 0;
                int dialogResult = JOptionPane.showConfirmDialog(null, "you have Principals:" + sb.toString() + " to grant permissions, do you want to grant permissions?", "e!DAL-FileChooser", dialogButton);
                if (dialogResult == 0) {
                    return;
                }
            }
            PermissionDialog.this.returnvalue = 0;
            PermissionDialog.this.dispose();
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionDialog.this.returnvalue = 1;
            PermissionDialog.this.dispose();
        }
    };
    private Action addnewAction = new AbstractAction("Add NewUser"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionNewuserDialog permission = new PermissionNewuserDialog(PermissionDialog.this.dataentry, PermissionDialog.this.client);
            int returnval = permission.showOpenDialog();
            if (returnval == 0 && permission.getPrincipal() != null) {
                PermissionDialog.this.inituserprincipallist(permission.getPrincipal());
                PermissionDialog.this.inituserprincipalcombox();
            }
        }
    };
    private Action applyAction = new AbstractAction("Apply"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String currentuser = PermissionDialog.this.users.get(PermissionDialog.this.principalcomboBox.getSelectedIndex());
            String currentprincipalname = PermissionDialog.this.principals.get(PermissionDialog.this.principalcomboBox.getSelectedIndex());
            Principal currentprincipal = PrincipalUtil.getInstance(currentprincipalname, currentuser);
            if (currentprincipal != null) {
                ArrayList<String> destinationlist = new ArrayList<String>();
                ArrayList<String> sourcelist = new ArrayList<String>();
                int souresize = PermissionDialog.this.sourceListModel.getSize();
                for (int i = 0; i < souresize; ++i) {
                    try {
                        boolean isin = PrincipalUtil.checkPermission(PermissionDialog.this.dataentry, currentprincipalname, currentuser, PermissionDialog.this.sourceListModel.getElementAt(i).toString());
                        if (!isin) continue;
                        PermissionDialog.this.dataentry.revokePermission(currentprincipal, GrantableMethods.Methods.valueOf((String)PermissionDialog.this.sourceListModel.getElementAt(i).toString()));
                        continue;
                    }
                    catch (RemoteException ex) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
                        ErrorDialog.showError(ex);
                        destinationlist.add(PermissionDialog.this.sourceListModel.getElementAt(i));
                        continue;
                    }
                    catch (PrimaryDataEntityException ex) {
                        destinationlist.add(PermissionDialog.this.sourceListModel.getElementAt(i));
                        continue;
                    }
                    catch (Exception ex) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
                        ErrorDialog.showError(ex);
                        destinationlist.add(PermissionDialog.this.sourceListModel.getElementAt(i));
                    }
                }
                int destsize = PermissionDialog.this.destListModel.getSize();
                for (int i = 0; i < destsize; ++i) {
                    try {
                        boolean isin = PrincipalUtil.checkPermission(PermissionDialog.this.dataentry, currentprincipalname, currentuser, PermissionDialog.this.destListModel.getElementAt(i).toString());
                        if (isin) continue;
                        PermissionDialog.this.dataentry.grantPermission(currentprincipal, GrantableMethods.Methods.valueOf((String)PermissionDialog.this.destListModel.getElementAt(i).toString()));
                        continue;
                    }
                    catch (RemoteException ex) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
                        ErrorDialog.showError(ex);
                        sourcelist.add(PermissionDialog.this.destListModel.getElementAt(i));
                        continue;
                    }
                    catch (PrimaryDataEntityException ex) {
                        sourcelist.add(PermissionDialog.this.destListModel.getElementAt(i));
                        continue;
                    }
                    catch (Exception ex) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
                        ErrorDialog.showError(ex);
                        sourcelist.add(PermissionDialog.this.destListModel.getElementAt(i));
                    }
                }
                Object msg = "Grant permissions finish!";
                if (destinationlist.size() > 0) {
                    msg = (String)msg + "some methods:";
                    for (Object e2 : destinationlist) {
                        msg = (String)msg + e2.toString();
                        msg = (String)msg + ",";
                        PermissionDialog.this.addDestinationElement(e2.toString());
                        PermissionDialog.this.sourceListModel.removeElement(e2);
                    }
                    msg = ((String)msg).substring(0, ((String)msg).length() - 1);
                    msg = (String)msg + " can't be revokePermission!";
                }
                if (sourcelist.size() > 0) {
                    msg = (String)msg + "some methods:";
                    for (Object e3 : sourcelist) {
                        msg = (String)msg + e3.toString();
                        msg = (String)msg + ",";
                        PermissionDialog.this.addSourceElement(e3.toString());
                        PermissionDialog.this.destListModel.removeElement(e3);
                    }
                    msg = ((String)msg).substring(0, ((String)msg).length() - 1);
                    msg = (String)msg + " can't be grantPermission!";
                }
                JOptionPane.showMessageDialog(null, msg, "EdalFileChooser", 1);
                PermissionDialog.this.todoprincipals.remove(currentprincipal.getName() + ":" + currentprincipal.getClass().getSimpleName());
            }
        }
    };

    public PermissionDialog(ClientPrimaryDataEntity dataentry, ClientDataManager client) {
        this.addWindowListener(this.createAppCloser());
        this.allavailablemethods.clear();
        this.methods.clear();
        this.client = client;
        this.dataentry = dataentry;
        this.loadconstants();
        try {
            this.setTitle("Permissions Information:" + dataentry.getPath());
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        this.detialpanel.setLayout(new BorderLayout());
        JPanel userselectpanel = new JPanel();
        this.inituserprincipallist(null);
        JLabel principallabel = new JLabel("Principals at:", 0);
        userselectpanel.add(principallabel);
        this.principalcomboBox = new JComboBox<String>(this.userprincipals.toArray(new String[0]));
        this.principalcomboBox.setName("principal");
        userselectpanel.add(this.principalcomboBox);
        this.principalcomboBox.addItemListener(this);
        JButton applyButton = new JButton(this.applyAction);
        userselectpanel.add(applyButton);
        JButton addButton = new JButton(this.addnewAction);
        userselectpanel.add(addButton);
        JPanel permissioneditpanel = new JPanel();
        this.initpermissionpanel(permissioneditpanel);
        this.detialpanel.add((Component)userselectpanel, "North");
        this.detialpanel.add((Component)permissioneditpanel, "Center");
        contents.add((Component)this.detialpanel, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(this.dialogwidth, (int)((double)this.dialogwidth * 0.618)));
        this.setMinimumSize(new Dimension(this.dialogwidth, (int)((double)this.dialogwidth * 0.618)));
        this.setResizable(false);
        if (this.principalcomboBox.getItemCount() > 0) {
            this.refreshPermissiontable(dataentry, this.users.get(0), this.principals.get(0));
        }
    }

    private JPanel createbuttonpanel() {
        JButton savebtn = new JButton(this.okAction);
        JButton cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(savebtn);
        buttonPane.add(cancelbtn);
        return buttonPane;
    }

    private void inituserprincipalcombox() {
        this.principalcomboBox.removeAllItems();
        for (String str : this.userprincipals) {
            this.principalcomboBox.addItem(str);
        }
        if (this.principalcomboBox.getItemCount() > 0) {
            this.refreshPermissiontable(this.dataentry, this.users.get(0), this.principals.get(0));
        }
    }

    private void inituserprincipallist(Principal principal) {
        this.users.clear();
        this.principals.clear();
        this.userprincipals.clear();
        if (principal != null) {
            this.users.add(principal.getName());
            this.principals.add(principal.getClass().getName());
            this.userprincipals.add(principal.getName() + ":" + principal.getClass().getSimpleName());
            this.todoprincipals.add(principal.getName() + ":" + principal.getClass().getSimpleName());
        }
        try {
            Map<Principal, List<GrantableMethods.Methods>> permissionmap = this.dataentry.getPermissions();
            if (permissionmap != null) {
                for (Map.Entry<Principal, List<GrantableMethods.Methods>> entry : permissionmap.entrySet()) {
                    Principal key = entry.getKey();
                    this.users.add(key.getName());
                    this.principals.add(key.getClass().getName());
                    this.userprincipals.add(key.getName() + ":" + key.getClass().getSimpleName());
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        catch (PrimaryDataEntityException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError((Exception)((Object)e));
        }
    }

    private void initpermissionpanel(JPanel permissioneditpanel) {
        permissioneditpanel.setBorder(BorderFactory.createEtchedBorder());
        permissioneditpanel.setLayout(new GridBagLayout());
        JLabel sourceLabel = new JLabel(DEFAULT_SOURCE_CHOICE_LABEL);
        this.sourceListModel = new SortedListModel();
        this.sourceList = new JList<String>(this.sourceListModel);
        permissioneditpanel.add((Component)sourceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        JScrollPane sourcepane = new JScrollPane(this.sourceList);
        sourcepane.setPreferredSize(new Dimension(220, 100));
        permissioneditpanel.add((Component)sourcepane, new GridBagConstraints(0, 1, 1, 5, 0.5, 1.0, 10, 3, EMPTY_INSETS, 0, 0));
        JButton addButton = new JButton(ADD_BUTTON_LABEL);
        addButton.setPreferredSize(new Dimension(110, 30));
        permissioneditpanel.add((Component)addButton, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.25, 10, 0, EMPTY_INSETS, 0, 0));
        addButton.addActionListener(new AddListener());
        this.removeButton = new JButton(REMOVE_BUTTON_LABEL);
        this.removeButton.setPreferredSize(new Dimension(110, 30));
        permissioneditpanel.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 2, 0.0, 0.25, 10, 0, EMPTY_INSETS, 0, 0));
        this.removeButton.addActionListener(new RemoveListener());
        this.destLabel = new JLabel(DEFAULT_DEST_CHOICE_LABEL);
        this.destListModel = new SortedListModel();
        this.destList = new JList<String>(this.destListModel);
        permissioneditpanel.add((Component)this.destLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        JScrollPane destpane = new JScrollPane(this.destList);
        destpane.setPreferredSize(new Dimension(220, 100));
        permissioneditpanel.add((Component)destpane, new GridBagConstraints(2, 1, 1, 5, 0.5, 1.0, 10, 3, EMPTY_INSETS, 0, 0));
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }

    private void fillListModel(SortedListModel model, ListModel<String> newValues) {
        int size = newValues.getSize();
        for (int i = 0; i < size; ++i) {
            model.add(newValues.getElementAt(i));
        }
    }

    private void fillListModel(SortedListModel model, String[] newValues) {
        model.addAll(newValues);
    }

    public void addDestinationElements(String[] newValues) {
        this.fillListModel(this.destListModel, newValues);
    }

    public void addSourceElements(ListModel<String> newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void addSourceElements(String[] newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    private void addSourceElement(String newValue) {
        this.sourceListModel.add(newValue);
    }

    private void addDestinationElement(String newValue) {
        this.destListModel.add(newValue);
    }

    private void clearSourceListModel() {
        this.sourceListModel.clear();
    }

    private void clearDestinationListModel() {
        this.destListModel.clear();
    }

    private void clearSourceSelected() {
        if (this.sourceList.getSelectedValuesList().size() > 0) {
            Object[] selected = this.sourceList.getSelectedValuesList().toArray();
            for (int i = selected.length - 1; i >= 0; --i) {
                this.sourceListModel.removeElement(selected[i]);
            }
        }
        this.sourceList.getSelectionModel().clearSelection();
    }

    private void clearDestinationSelected() {
        if (this.destList.getSelectedValuesList().size() > 0) {
            Object[] selected = this.destList.getSelectedValuesList().toArray();
            for (int i = selected.length - 1; i >= 0; --i) {
                this.destListModel.removeElement(selected[i]);
            }
        }
        this.destList.getSelectionModel().clearSelection();
    }

    private void loadconstants() {
        try {
            if (this.dataentry != null) {
                List keysets;
                List commonskeysets = GrantableMethods.ENTITY_METHODS;
                for (GrantableMethods.Methods m : commonskeysets) {
                    this.allavailablemethods.add(m);
                }
                if (this.dataentry.isDirectory()) {
                    keysets = GrantableMethods.DIRECTORY_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                } else {
                    keysets = GrantableMethods.FILE_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.refreshPermissiontable(this.dataentry, this.users.get(this.principalcomboBox.getSelectedIndex()), this.principals.get(this.principalcomboBox.getSelectedIndex()));
        }
    }

    private void refreshPermissiontable(ClientPrimaryDataEntity dataentry, String username, String principalname) {
        this.methods.clear();
        try {
            Map<Principal, List<GrantableMethods.Methods>> permissionmap = dataentry.getPermissions();
            if (permissionmap != null) {
                for (Map.Entry<Principal, List<GrantableMethods.Methods>> entry : permissionmap.entrySet()) {
                    Principal key = entry.getKey();
                    List<GrantableMethods.Methods> value = entry.getValue();
                    if (!key.getName().equals(username) || !key.getClass().getName().equals(principalname)) continue;
                    for (GrantableMethods.Methods method : value) {
                        this.methods.add(method.toString());
                    }
                }
            }
            this.clearSourceListModel();
            this.clearDestinationListModel();
            ArrayList<String> allavailablenoselectedmethods = new ArrayList<String>();
            for (GrantableMethods.Methods method : this.allavailablemethods) {
                if (this.methods.contains(method.toString())) continue;
                allavailablenoselectedmethods.add(method.toString());
            }
            this.addSourceElements(allavailablenoselectedmethods.toArray(new String[0]));
            this.addDestinationElements(this.methods.toArray(new String[0]));
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        catch (PrimaryDataEntityException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError((Exception)((Object)e));
        }
    }

    private WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PermissionDialog.this.returnvalue = 1;
                PermissionDialog.this.dispose();
            }
        };
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] selected = PermissionDialog.this.destList.getSelectedValuesList().toArray(new String[0]);
            PermissionDialog.this.addSourceElements(selected);
            PermissionDialog.this.clearDestinationSelected();
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] selected = PermissionDialog.this.sourceList.getSelectedValuesList().toArray(new String[0]);
            PermissionDialog.this.addDestinationElements(selected);
            PermissionDialog.this.clearSourceSelected();
        }
    }
}

