/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTitleBorder;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTitlePanel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class EdalTitleDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private EdalTitlePanel titleComponent;
    private JPanel contentPanel = new JPanel();
    private Container content = null;
    private Point pressPoint;

    public EdalTitleDialog() {
        this.initDialog();
    }

    public EdalTitleDialog(Window owner) {
        super(owner);
        this.initDialog();
    }

    public EdalTitleDialog(Window owner, String title) {
        super(owner, title);
        this.setTitle(title);
        this.initDialog();
    }

    public EdalTitleDialog(Window owner, String title, boolean modal) {
        super(owner, title);
        this.setModal(modal);
        this.initDialog();
    }

    @Override
    public void setContentPane(Container contentPane) {
        if (contentPane == this.contentPanel) {
            super.setContentPane(contentPane);
        } else {
            if (this.content != null) {
                this.contentPanel.remove(this.content);
            }
            this.content = contentPane;
            this.contentPanel.add((Component)this.content, "Center");
        }
    }

    @Override
    public Container getContentPane() {
        return this.content;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleComponent != null) {
            this.titleComponent.setTitle(title);
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        if (this.titleComponent != null) {
            this.titleComponent.setIcon(image);
        }
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        super.setUndecorated(true);
    }

    private void initDialog() {
        this.titleComponent = new EdalTitlePanel(this);
        this.setTitle(this.getTitle());
        ImageIcon imageIcon = ImageUtil.createImageIcon("edal_scaled_mini.png", "edal.png");
        this.getTitleComponent().setTextInCenter(true);
        this.setIconImage(imageIcon.getImage());
        this.contentPanel.setBorder(new EdalTitleBorder());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.titleComponent, "North");
        this.setContentPane(this.contentPanel);
        this.setUndecorated(true);
        this.setResizable(true);
        this.initResizeListener();
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(false);
        this.contentPanel.setCursor(Cursor.getDefaultCursor());
        this.titleComponent.setResizable(resizable);
    }

    private boolean isInLeft(Point p) {
        Rectangle rect = this.contentPanel.getBounds();
        return p.getX() > rect.getX() && p.getX() < rect.getX() + 5.0;
    }

    private boolean isInRight(Point p) {
        Rectangle rect = this.contentPanel.getBounds();
        return p.getX() < rect.getX() + rect.getWidth() && p.getX() > rect.getX() + rect.getWidth() - 5.0;
    }

    private boolean isInTop(Point p) {
        Rectangle rect = this.contentPanel.getBounds();
        return p.getY() > rect.getY() && p.getY() < rect.getY() + 5.0;
    }

    private boolean isInBottom(Point p) {
        Rectangle rect = this.contentPanel.getBounds();
        return p.getY() < rect.getY() + rect.getHeight() && p.getY() > rect.getY() + rect.getHeight() - 5.0;
    }

    private Cursor getResizeCursor(Point p) {
        boolean l = this.isInLeft(p);
        boolean r = this.isInRight(p);
        boolean t = this.isInTop(p);
        boolean b = this.isInBottom(p);
        if (l) {
            if (t) {
                return Cursor.getPredefinedCursor(6);
            }
            if (b) {
                return Cursor.getPredefinedCursor(4);
            }
            return Cursor.getPredefinedCursor(10);
        }
        if (r) {
            if (t) {
                return Cursor.getPredefinedCursor(7);
            }
            if (b) {
                return Cursor.getPredefinedCursor(5);
            }
            return Cursor.getPredefinedCursor(11);
        }
        if (b) {
            return Cursor.getPredefinedCursor(9);
        }
        if (t) {
            return Cursor.getPredefinedCursor(8);
        }
        return Cursor.getDefaultCursor();
    }

    private void resizeFrame(Point dragPoint) {
        double minWidth = 100.0;
        int minHeight = this.titleComponent.getHeight() + 10;
        if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(8)) {
            int offset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth();
            int nH = this.getHeight() - offset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.setLocation(this.getX(), this.getY() + offset);
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(11)) {
            int offset = dragPoint.x - this.pressPoint.x;
            int nW = this.getWidth() + offset;
            int nH = this.getHeight();
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.pressPoint.x += offset;
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(9)) {
            int offset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth();
            int nH = this.getHeight() + offset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.pressPoint.y += offset;
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(10)) {
            int offset = dragPoint.x - this.pressPoint.x;
            int nW = this.getWidth() - offset;
            int nH = this.getHeight();
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.setBounds(this.getX() + offset, this.getY(), nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(7)) {
            int xoffset = dragPoint.x - this.pressPoint.x;
            int yoffset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth() + xoffset;
            int nH = this.getHeight() - yoffset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.pressPoint.x += xoffset;
            this.setLocation(this.getX(), this.getY() + yoffset);
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(5)) {
            int xoffset = dragPoint.x - this.pressPoint.x;
            int yoffset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth() + xoffset;
            int nH = this.getHeight() + yoffset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.pressPoint.x += xoffset;
            this.pressPoint.y += yoffset;
            this.setLocation(this.getX(), this.getY());
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(4)) {
            int xoffset = dragPoint.x - this.pressPoint.x;
            int yoffset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth() - xoffset;
            int nH = this.getHeight() + yoffset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.pressPoint.y += yoffset;
            this.setLocation(this.getX() + xoffset, this.getY());
            this.setSize(nW, nH);
        } else if (this.contentPanel.getCursor() == Cursor.getPredefinedCursor(6)) {
            int xoffset = dragPoint.x - this.pressPoint.x;
            int yoffset = dragPoint.y - this.pressPoint.y;
            int nW = this.getWidth() - xoffset;
            int nH = this.getHeight() - yoffset;
            if (nH <= minHeight || (double)nW < minWidth) {
                return;
            }
            this.setLocation(this.getX() + xoffset, this.getY() + yoffset);
            this.setSize(nW, nH);
        }
        this.validate();
    }

    private void initResizeListener() {
        this.contentPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Cursor resizeCursor;
                if (EdalTitleDialog.this.titleComponent.isMaxed() || EdalTitleDialog.this.isResizable()) {
                    return;
                }
                Point point = e.getPoint();
                Cursor cursor = EdalTitleDialog.this.getCursor();
                if (cursor != (resizeCursor = EdalTitleDialog.this.getResizeCursor(point))) {
                    EdalTitleDialog.this.contentPanel.setCursor(resizeCursor);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (EdalTitleDialog.this.titleComponent.isMaxed() || EdalTitleDialog.this.isResizable()) {
                    return;
                }
                EdalTitleDialog.this.resizeFrame(e.getPoint());
            }
        });
        this.contentPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EdalTitleDialog.this.pressPoint = e.getPoint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EdalTitleDialog.this.content.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public EdalTitlePanel getTitleComponent() {
        return this.titleComponent;
    }
}

