/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusMessageLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusSeparator;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusTimeLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.TexturePaint;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class XStatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image backgroundLeftImage = ImageUtil.getImage("statusbar_background_left.png");
    private Image backgroundRightImage = ImageUtil.getImage("statusbar_background_right.png");
    private ImageIcon backgroundImageIcon = ImageUtil.createImageIcon("statusbar_background.png", "");
    private TexturePaint paint = ImageUtil.createTexturePaint("outlook_bar_background.png");
    private JPanel leftPane = new JPanel(new BorderLayout());
    private JPanel rightPane = new JPanel(new FlowLayout(3, 0, 0));
    private Border border = BorderFactory.createEmptyBorder(0, 10, 0, 0);
    private XStatusLabel serverinfo;
    private XStatusLabel userinfo;

    public XStatusBar(String host, int port, String username) {
        this.init(host, port, username);
    }

    private void init(String host, int port, String username) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPane, "Center");
        this.add((Component)this.rightPane, "East");
        this.setBorder(this.border);
        this.leftPane.setOpaque(false);
        this.rightPane.setOpaque(false);
        this.addDefaultSubLabel(host, port, username);
    }

    private void addDefaultSubLabel(String host, int port, String username) {
        this.leftPane.add((Component)new XStatusMessageLabel(), "Center");
        this.addSeparator();
        this.serverinfo = new XStatusLabel(host + ":" + port, ImageUtil.createImageIcon("server_12x12.png", ""));
        this.rightPane.add(this.serverinfo);
        this.addSeparator();
        this.userinfo = new XStatusLabel(username, ImageUtil.createImageIcon("user_12x12.png", ""));
        this.rightPane.add(this.userinfo);
        this.addSeparator();
        this.rightPane.add(new XStatusTimeLabel());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.drawImage(this.backgroundLeftImage, 0, 0, null);
        g2d.drawImage(this.backgroundRightImage, this.getWidth() - this.backgroundRightImage.getWidth(null), 0, null);
    }

    public JPanel getLeftPane() {
        return this.leftPane;
    }

    public JPanel getRightPane() {
        return this.rightPane;
    }

    public void addSeparator() {
        this.rightPane.add(new XStatusSeparator());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.backgroundImageIcon.getIconHeight() - 5);
    }

    public void updateStatus(final String host, final int port, final String username) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                XStatusBar.this.serverinfo.setText(host + ":" + port);
                XStatusBar.this.userinfo.setText(username);
            }
        };
        thread.start();
    }
}

