/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

/**
 * {@link Enum} to collect all function that are provided by the
 * {@link EdalJettyServer}.
 * 
 * @author arendd
 */
public enum EdalHttpFunctions {
	/**
	 * Accept the request for a
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
	 */
	ACCEPT {
	},
	/**
	 * Reject the request for a
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
	 */
	REJECT {
	},
	/**
	 * Review a
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
	 * again.
	 */
	REVIEW {
	},
	/**
	 * Download a
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile}.
	 */
	DOWNLOAD {
	},
	/**
	 * Access a landing page for a
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity}
	 * .
	 */
	EDAL {
	},
	LOGIN {
	},
	DOI {
	},
	URL {
	},
	LOGO {

	},
	ZIP {

	};
}
