/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

import java.io.IOException;
import java.io.PipedInputStream;
import java.util.concurrent.CountDownLatch;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;

class GuessMimeTypeThread extends Thread {

	private PipedInputStream pipedInputStream;

	private DataFormat dataFormat;

	private CountDownLatch stopLatch;

	GuessMimeTypeThread(PipedInputStream pipedInputStream,
			CountDownLatch stopLatch) {
		this.pipedInputStream = pipedInputStream;
		this.stopLatch = stopLatch;

	}

	@Override
	public void run() {
		this.setDataFormat(DataFormat.guessDataFormat(pipedInputStream));
		try {
			this.pipedInputStream.close();
		} catch (IOException e) {
			DataManager
					.getImplProv()
					.getLogger()
					.error("unable to close pipedInputStream after guessing data format: "
							+ e.getMessage());
			throw new RuntimeException(e);
		}
		this.stopLatch.countDown();
	}

	/**
	 * @return the dataFormat
	 */
	DataFormat getDataFormat() {
		return dataFormat;
	}

	/**
	 * @param dataFormat
	 *            the dataFormat to set
	 */
	private void setDataFormat(DataFormat dataFormat) {
		this.dataFormat = dataFormat;
	}
}
