/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file;

/**
 * Class indicates an error with a {@link PrimaryDataDirectory}.
 * 
 * @author lange
 */
public class PrimaryDataDirectoryException extends Exception {

	/**
     * 
     */
	private static final long serialVersionUID = 3734400339965151958L;

	/**
	 * Constructor for {@link PrimaryDataDirectoryException} without a specific
	 * message.
	 */
	public PrimaryDataDirectoryException() {
	}

	/**
	 * Constructor for {@link PrimaryDataDirectoryException} with a specific
	 * message.
	 * 
	 * @param message
	 *            the error message.
	 */
	public PrimaryDataDirectoryException(final String message) {
		super(message);
	}

	/**
	 * Constructor for {@link PrimaryDataDirectoryException} with a specific
	 * message and cause.
	 * 
	 * @param message
	 *            the error message.
	 * @param cause
	 *            the cause.
	 */
	public PrimaryDataDirectoryException(final String message,
			final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructor for {@link PrimaryDataDirectoryException} with a specific
	 * cause.
	 * 
	 * @param cause
	 *            the cause.
	 */
	public PrimaryDataDirectoryException(final Throwable cause) {
		super(cause);
	}

}
