/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;

/**
 * Class to persist tickets for the ApprovalService with <em>HIBERNATE</em>.
 * 
 * @author arendd
 */
@Entity(name = "TICKETS")
public class TicketImplementation {

	private String ticket;
	private PublicReferenceImplementation reference;
	private String emailNotificationAddress;

	/**
	 * Default constructor for {@link TicketImplementation} is necessary for
	 * PojoInstantiator of <em>HIBERNATE</em>.
	 */
	protected TicketImplementation() {
	}

	/**
	 * Constructor for {@link TicketImplementation}.
	 * 
	 * @param ticket
	 *            the ticket number.
	 * @param publicReference
	 *            the corresponding {@link PublicReferenceImplementation}.
	 * @param emailNotificationAddress
	 *            the eMail address of the requesting user.
	 */
	protected TicketImplementation(String ticket,
			PublicReferenceImplementation publicReference,
			String emailNotificationAddress) {
		super();
		this.setTicket(ticket);
		this.setReference(publicReference);
		this.setEmailNotificationAddress(emailNotificationAddress);
	}

	/**
	 * Getter for the field <code>ticket</code>.
	 * 
	 * @return the ticket
	 */
	@Id
	protected String getTicket() {
		return ticket;
	}

	/**
	 * Setter for the field <code>ticket</code>.
	 * 
	 * @param ticket
	 *            the ticket to set
	 */
	protected void setTicket(String ticket) {
		this.ticket = ticket;
	}

	/**
	 * Getter for the field <code>reference</code>.
	 * 
	 * @return the reference
	 */
	@OneToOne
	protected PublicReferenceImplementation getReference() {
		return reference;
	}

	/**
	 * Setter for the field <code>reference</code>.
	 * 
	 * @param reference
	 *            the reference to set
	 */
	protected void setReference(PublicReferenceImplementation reference) {
		this.reference = reference;
	}

	/**
	 * Getter for the field <code>emailNotificationAddress</code>.
	 * 
	 * @return the emailNotificationAddress
	 */
	protected String getEmailNotificationAddress() {
		return emailNotificationAddress;
	}

	/**
	 * Setter for the field <code>emailNotificationAddress</code>.
	 * 
	 * @param emailNotificationAddress
	 *            the emailNotificationAddress to set
	 */
	protected void setEmailNotificationAddress(String emailNotificationAddress) {
		this.emailNotificationAddress = emailNotificationAddress;
	}

}
