/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Collection of {@link EdalDate} objects to define the dates and ranges of
 * different events,e.g. date of creation...
 * 
 * @author arendd
 */
public class DateEvents extends UntypedData implements Set<EdalDate> {

	private static final long serialVersionUID = 8853287738100670768L;
	private Set<EdalDate> set;

	/**
	 * Default constructor to create a {@link DateEvents} object with a defined
	 * description.
	 * 
	 * @param description
	 *            the event for this {@link DateEvents}.
	 */
	public DateEvents(String description) {
		super(description);
		this.set = new HashSet<EdalDate>();
	}

	/**
	 * @param e
	 * @return true or false
	 * @see java.util.Set#add(java.lang.Object)
	 */
	public boolean add(EdalDate e) {
		return set.add(e);
	}

	/**
	 * @param c
	 * @return true or false
	 * @see java.util.Set#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection<? extends EdalDate> c) {
		return set.addAll(c);
	}

	/**
	 * @see java.util.Set#clear()
	 */
	public void clear() {
		set.clear();
	}

	/** {@inheritDoc} */
	@Override
	public int compareTo(final UntypedData datatype) {

		if (datatype instanceof DateEvents) {

			DateEvents dateEvents = (DateEvents) datatype;

			if (this.getSet().equals(dateEvents.getSet())) {
				if (this.getString().equals(dateEvents.getString())) {
					return 0;
				} else {
					return this.getString().compareTo(dateEvents.getString());
				}
			} else if (this.getSet().containsAll(dateEvents.getSet())) {
				return 1;
			} else {
				return -1;
			}
		} else {
			return super.compareTo(datatype);
		}
	}

	/**
	 * @param o
	 * @return true or false
	 * @see java.util.Set#contains(java.lang.Object)
	 */
	public boolean contains(Object o) {
		return set.contains(o);
	}

	/**
	 * @param c
	 * @return true or false
	 * @see java.util.Set#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection<?> c) {
		return set.containsAll(c);
	}

	/**
	 * @param o
	 * @return true or false
	 * @see java.util.Set#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if (this.compareTo((UntypedData) o) == 0) {
			return true;
		}
		return false;

	}

	/**
	 * @return the set
	 */
	public Set<EdalDate> getSet() {
		return set;
	}

	/**
	 * @return hashCode
	 * @see java.util.Set#hashCode()
	 */
	public int hashCode() {
		return set.hashCode();
	}

	/**
	 * @return true or false
	 * @see java.util.Set#isEmpty()
	 */
	public boolean isEmpty() {
		return set.isEmpty();
	}

	/**
	 * @return {@link Iterator} of {@link EdalDate}
	 * @see java.util.Set#iterator()
	 */
	public Iterator<EdalDate> iterator() {
		return set.iterator();
	}

	/**
	 * @param o
	 * @return true or false
	 * @see java.util.Set#remove(java.lang.Object)
	 */
	public boolean remove(Object o) {
		return set.remove(o);
	}

	/**
	 * @param c
	 * @return true or false
	 * @see java.util.Set#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection<?> c) {
		return set.removeAll(c);
	}

	/**
	 * @param c
	 * @return true or false
	 * @see java.util.Set#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection<?> c) {
		return set.retainAll(c);
	}

	/**
	 * @param set
	 *            the set to set
	 */
	public void setSet(Set<EdalDate> set) {
		this.set = set;
	}

	/**
	 * @return size
	 * @see java.util.Set#size()
	 */
	public int size() {
		return set.size();
	}

	/**
	 * @return {@link Object} array
	 * @see java.util.Set#toArray()
	 */
	public Object[] toArray() {
		return set.toArray();
	}

	/**
	 * @param a
	 * @return array
	 * @see java.util.Set#toArray(Object[])
	 */
	public <T> T[] toArray(T[] a) {
		return set.toArray(a);
	}

	/** {@inheritDoc} */

	@Override
	public String toString() {
		if (this.getSet().isEmpty()) {
			return "none";
		} else {
			StringBuffer stringBuffer = new StringBuffer();
			stringBuffer.append("Event: " + this.getString() + ",");
			for (EdalDate date : this.getSet()) {
				stringBuffer.append(date.toString() + ",");
			}
			return stringBuffer.toString();
		}
	}

	/** {@inheritDoc} */
	@Override
	public String toHTML() {
		if (this.getSet().isEmpty()) {
			return "none";
		} else {
			StringBuffer stringBuffer = new StringBuffer();
			stringBuffer.append("Event: " + this.getString() + "<br/>");
			for (EdalDate date : this.getSet()) {
				stringBuffer.append(date.toString() + "<br/>");
			}
			return stringBuffer.toString();
		}
	}

}
