/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import java.util.List;
import java.util.Map;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;

/**
 * Class to define the {@link Job} to check the review status of all existing
 * requests for a {@link PublicReference}.
 * 
 * @author arendd
 */
public class CheckReviewStatusJob implements Job {

	/**
	 * {@inheritDoc}
	 * <p>
	 * Call the {@link ApprovalServiceProvider} of the current
	 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider}
	 * and load all open requests for a {@link PublicReference} and check the
	 * current {@link ReviewStatus}.
	 */
	@Override
	public void execute(JobExecutionContext context)
			throws JobExecutionException {

		ApprovalServiceProvider app = null;

		try {
			app = DataManager.getImplProv().getApprovalServiceProvider()
					.newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			DataManager.getImplProv().getLogger().error(e);
			throw new JobExecutionException(
					"Unable to load ApprovalServiceProvider: " + e.getMessage(),
					e.getCause());
		}
		Map<PublicReference, List<ReviewStatus>> map = app
				.getAllOpenReviewProcesses();

		if (map.isEmpty()) {
			DataManager
					.getImplProv()
					.getLogger()
					.debug("Running CheckReviewStatusJob : found no open requests !");
		} else {
			DataManager
					.getImplProv()
					.getLogger()
					.debug("Running CheckReviewStatusJob : found " + map.size()
							+ " open requests !");
		}
		try {
			app.checkOpenReviewProcesses(map);
		} catch (EdalApprovalException e) {
			DataManager.getImplProv().getLogger().error(e);
			throw new JobExecutionException(
					"unable to check open review processes: " + e.getMessage(),
					e.getCause());
		}
	}
}