/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import java.util.ArrayList;
import java.util.List;

import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ReviewStatus.ReviewStatusType;

/**
 * Represent the result of the {@link ReviewProcess#review(List)}
 * function.
 * 
 * @author arendd
 * 
 */
public class ReviewResult {

	private ReviewStatusType reviewStatusType;
	private List<ReviewStatus> reviewerStatusList;

	/**
	 * Default constructor.
	 */
	public ReviewResult() {
		this.reviewerStatusList = new ArrayList<>();
	}

	/**
	 * Constructor with defined {@link ReviewStatusType} and a {@link List} of
	 * {@link ReviewStatus}
	 * 
	 * @param reviewStatusType
	 *            the {@link ReviewStatusType}.
	 * @param reviewerStatusList
	 *            a {@link List} of {@link ReviewStatus}.
	 */
	public ReviewResult(ReviewStatusType reviewStatusType,
			List<ReviewStatus> reviewerStatusList) {

		this.reviewStatusType = reviewStatusType;
		this.reviewerStatusList = reviewerStatusList;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ReviewResult [reviewStatusType=" + reviewStatusType
				+ ", reviewerStatusList=" + reviewerStatusList + "]";
	}

	/**
	 * @return the reviewStatusType
	 */
	public ReviewStatusType getReviewStatusType() {
		return reviewStatusType;
	}

	/**
	 * @param reviewStatusType
	 *            the reviewStatusType to set
	 */
	public void setReviewStatusType(ReviewStatusType reviewStatusType) {
		this.reviewStatusType = reviewStatusType;
	}

	/**
	 * @return the reviewerStatusList
	 */
	public List<ReviewStatus> getReviewerStatusList() {
		return reviewerStatusList;
	}

	/**
	 * @param reviewerStatusList
	 *            the reviewerList to set
	 */
	public void setReviewerStatusList(List<ReviewStatus> reviewerStatusList) {
		this.reviewerStatusList = reviewerStatusList;
	}

}
