/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import java.io.Serializable;
import java.util.Calendar;

import javax.mail.internet.InternetAddress;

/**
 * Represent the status of a {@link ApprovalServiceProvider} process.
 * 
 * @author arendd
 */
public class ReviewStatus implements Serializable {

	/**
	 * {@link Enum} to describe the review status.
	 */
	public enum ReviewStatusType {

		/**
		 * The
		 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
		 * was accepted.
		 */
		ACCEPTED {

		},
		/**
		 * The
		 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
		 * was rejected.
		 */
		REJECTED {

		},
		/**
		 * The status of
		 * {@link de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference}
		 * was not yet decided.
		 */
		UNDECIDED {

		};
	}

	private static final long serialVersionUID = 1L;

	private InternetAddress emailAddress;

	private ReviewStatusType statusType;

	private Calendar requestedDate;

	private ReviewerType reviewerType;

	public enum ReviewerType {
		SCIENTIFIC {

		},

		SUBSTITUTE {

		},

		MANAGING {

		};
	}

	/**
	 * @return the emailAddress
	 */
	public InternetAddress getEmailAddress() {
		return emailAddress;
	}

	/**
	 * @return the requestedDate
	 */
	public Calendar getRequestedDate() {
		return requestedDate;
	}

	/**
	 * @return the statusType
	 */
	public ReviewStatusType getStatusType() {
		return statusType;
	}

	/**
	 * @param emailAddress
	 *            the emailAddress to set
	 */
	public void setEmailAddress(InternetAddress emailAddress) {
		this.emailAddress = emailAddress;
	}

	/**
	 * @param requestedDate
	 *            the requestedDate to set
	 */
	public void setRequestedDate(Calendar requestedDate) {
		this.requestedDate = requestedDate;
	}

	/**
	 * @param statusType
	 *            the statusType to set
	 */
	public void setStatusType(ReviewStatusType statusType) {
		this.statusType = statusType;
	}

	/**
	 * @return the reviewerType
	 */
	public ReviewerType getReviewerType() {
		return reviewerType;
	}

	/**
	 * @param reviewerType
	 *            the reviewerType to set
	 */
	public void setReviewerType(ReviewerType reviewerType) {
		this.reviewerType = reviewerType;
	}

	@Override
	public String toString() {
		return "ReviewStatus [emailAddress=" + emailAddress + ", statusType="
				+ statusType + ", requestedDate=" + requestedDate.getTime()
				+ "]";
	}

}
