/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;

/**
 * The main researchers involved working on the data, or the authors of the
 * publication in priority order. May be a corporate/institutional or personal
 * name. Format: Family, Given.
 * 
 * @author arendd
 */
@XmlType(name = "creator")
public class XmlCreator implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Field creatorName.
	 */
	private String creatorName;

	/**
	 * Field nameIdentifier.
	 */
	private XmlNameIdentifier nameIdentifier;

	/**
	 * Default constructor
	 */
	public XmlCreator() {
		super();
	}

	/**
	 * Constructor to create a {@link XmlCreator} with the specified
	 * creatorName.
	 * 
	 * @param creatorName
	 *            the creatorName to set.
	 */
	public XmlCreator(String creatorName) {
		this();
		setCreatorName(creatorName);
	}

	/**
	 * Constructor to create a {@link XmlCreator} with the specified creatorName
	 * and nameIdentifier.
	 * 
	 * @param creatorName
	 *            the creatorName to set.
	 * @param nameIdentifier
	 *            the nameIdentifier to set.
	 */
	public XmlCreator(String creatorName, XmlNameIdentifier nameIdentifier) {
		this(creatorName);
		setNameIdentifier(nameIdentifier);
	}

	/**
	 * Copy-Constructor to create a {@link XmlCreator} from a {@link Person}
	 * object.
	 * 
	 * @param person
	 *            to convert into a {@link XmlCreator}.
	 */
	public XmlCreator(Person person) {
		this();

		StringBuffer buffer = new StringBuffer();

		if (person instanceof NaturalPerson) {

			NaturalPerson naturalPerson = (NaturalPerson) person;

			if (!naturalPerson.getSureName().isEmpty()) {
				buffer.append(naturalPerson.getSureName() + " ");
			}
			if (!naturalPerson.getGivenName().isEmpty()) {
				buffer.append(naturalPerson.getGivenName() + " ");
			}
			if (!naturalPerson.getZip().isEmpty()) {
				buffer.append(naturalPerson.getZip() + " ");
			}
			if (!naturalPerson.getAddressLine().isEmpty()) {
				buffer.append(naturalPerson.getAddressLine() + " ");
			}
			if (!naturalPerson.getCountry().isEmpty()) {
				buffer.append(naturalPerson.getCountry() + " ");
			}

			if (!buffer.toString().isEmpty()) {

				setCreatorName(buffer.toString());
			}
		} else if (person instanceof LegalPerson) {

			LegalPerson legalPerson = (LegalPerson) person;

			if (!legalPerson.getLegalName().isEmpty()) {
				buffer.append(legalPerson.getLegalName() + " ");
			}
			if (!legalPerson.getLegalName().isEmpty()) {
				buffer.append(legalPerson.getLegalName() + " ");
			}
			if (!legalPerson.getZip().isEmpty()) {
				buffer.append(legalPerson.getZip() + " ");
			}
			if (!legalPerson.getAddressLine().isEmpty()) {
				buffer.append(legalPerson.getAddressLine() + " ");
			}
			if (!legalPerson.getCountry().isEmpty()) {
				buffer.append(legalPerson.getCountry() + " ");
			}

			if (!buffer.toString().isEmpty()) {

				setCreatorName(buffer.toString());
			}
		}
	}

	/**
	 * Returns the value of field 'creatorName'.
	 * 
	 * @return the value of field 'creatorName'.
	 */
	@XmlElement(required = true)
	public String getCreatorName() {
		return this.creatorName;
	}

	/**
	 * Returns the value of field 'nameIdentifier'.
	 * 
	 * @return the value of field 'nameIdentifier'.
	 */
	@XmlElement
	public XmlNameIdentifier getNameIdentifier() {
		return this.nameIdentifier;
	}

	/**
	 * Sets the value of field 'creatorName'.
	 * 
	 * @param creatorName
	 *            the value of field 'creatorName'.
	 */
	public void setCreatorName(final String creatorName) {
		this.creatorName = creatorName;
	}

	/**
	 * Sets the value of field 'nameIdentifier'.
	 * 
	 * @param nameIdentifier
	 *            the value of field 'nameIdentifier'.
	 */
	public void setNameIdentifier(final XmlNameIdentifier nameIdentifier) {
		this.nameIdentifier = nameIdentifier;
	}

}