/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * Password callback handler for resolving user name and password for a JAAS
 * login.
 * 
 * @author arendd
 */
public class GoogleCallBackHandler implements CallbackHandler {

	private String password;

	private String username;

	private boolean alreadySetted = false;

	public GoogleCallBackHandler() {
		super();
	}

	public GoogleCallBackHandler(final String name) {
		super();
		this.username = name;

	}

	/**
	 * Handles the callbacks, and sets the user/password detail.
	 * 
	 * @param callbacks
	 *            the callbacks to handle
	 * @throws IOException
	 *             if an input or output error occurs.
	 */
	public void handle(final Callback[] callbacks) throws IOException,
			UnsupportedCallbackException {

		if (this.username != null) {
			if (this.password != null) {
				this.alreadySetted = true;
			}
		}

		if (!alreadySetted) {

			LoginDialog loginDlg = new LoginDialog(null, "Login to Google+",
					this.username);
			loginDlg.setVisible(true);

			if (loginDlg.getStatus() == LoginDialog.TRY_LOGIN) {
				this.username = loginDlg.getUsername();
				this.password = loginDlg.getPassword();

				alreadySetted = true;
			}
			if (loginDlg.getStatus() == LoginDialog.ABORT) {
				alreadySetted = true;

			}

		}
		for (final Callback callback : callbacks) {
			if (callback instanceof NameCallback) {

				NameCallback nc = (NameCallback) callback;
				nc.setName(this.username);

			} else if (callback instanceof PasswordCallback) {

				PasswordCallback pc = (PasswordCallback) callback;
				pc.setPassword(this.password.toCharArray());
			}
		}
	}
}