/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.swing.JOptionPane;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;

public class GoogleOauth {
	private static String openidurl = "https://accounts.google.com/o/oauth2/";
	private static String clientid = "185350669209-g332o78obs1033ep4kk4ke2mf2833455.apps.googleusercontent.com";
	private static String clientsecret = "6s2W5F2XfZU97TL0DTWPG7T1";
	private static String callbackurl = "urn:ietf:wg:oauth:2.0:oob";
	private static String code = null;
	private static String access_token = null;
	private static String refresh_token = null;
	private static String openidusername = "Email";
	private static String openidpassword = "Passwd";
	private static String openidloginbutton = "signIn";
	private static String openidcode = "code";
	private static String newline = "\n";

	static {
		String osname = System.getProperty("os.name");
		if (osname.toLowerCase().indexOf("windows") >= 0) {
			newline = "\r\n";
		}
	}

	public static GooglePrincipal authenticateGoogleUser(String emailaddress,
			String userpassword) throws Exception {

		WebClient webClient;
		webClient = new WebClient(BrowserVersion.FIREFOX_17,
				"proxy1.ipk-gatersleben.de", 3128);
		webClient.getOptions().setJavaScriptEnabled(true);
		webClient.getOptions().setCssEnabled(true);
		webClient.setAjaxController(new NicelyResynchronizingAjaxController());
		webClient.getOptions().setTimeout(15000);
		webClient.getOptions().setThrowExceptionOnScriptError(false);
		webClient.waitForBackgroundJavaScript(15000);

		Set<Cookie> cookieset = getcookies();
		for (Cookie cookie : cookieset) {
			webClient.getCookieManager().addCookie(cookie);
		}

		if (cookieset.size() == 0) {
			HtmlPage rootPage = webClient.getPage(openidurl
					+ "auth?scope=email%20profile&redirect_uri=" + callbackurl
					+ "&response_type=code&client_id=" + clientid);
			HtmlInput intputBox = rootPage.getHtmlElementById(openidusername);
			intputBox.setValueAttribute(emailaddress);

			HtmlInput intputBox2 = rootPage.getHtmlElementById(openidpassword);
			intputBox2.setValueAttribute(userpassword);

			HtmlElement button = rootPage.getHtmlElementById(openidloginbutton);

			HtmlPage approvepage = button.click();

			try {
				HtmlButton appbutton = approvepage
						.getHtmlElementById("submit_approve_access");
				Thread.sleep(2000);
				HtmlPage fpage = appbutton.click();
				HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
				code = codeinput.getValueAttribute();
			} catch (ElementNotFoundException e) {
				// ignore
			}

			try {
				HtmlSubmitInput appbutton = approvepage
						.getHtmlElementById("smsVerifyPin");
				HtmlInput pinbox = approvepage.getHtmlElementById("smsUserPin");

				String pincode = JOptionPane
						.showInputDialog("Please Enter your pincode: ");
				if (pincode == null) {
					System.exit(0);
				}
				pinbox.setValueAttribute(pincode);
				Thread.sleep(2000);
				HtmlPage page3 = appbutton.click();
				writecookies(webClient.getCookieManager().getCookies());

				HtmlButton okbutton = page3
						.getHtmlElementById("submit_approve_access");
				Thread.sleep(2000);
				HtmlPage fpage = okbutton.click();
				HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
				code = codeinput.getValueAttribute();
			} catch (ElementNotFoundException e) {
				// e.printStackTrace();
			}

			if (code == null) {
				System.out
						.println("Please check your username and password ! ");
				System.exit(0);
			}

			WebRequest requestSettings = new WebRequest(new URL(openidurl
					+ "token"), HttpMethod.POST);
			requestSettings.setRequestParameters(getAssocQuery());

			Page page = webClient.getPage(requestSettings);

			String pageContent = page.getWebResponse().getContentAsString();

			JSONParser parser = new JSONParser();
			Object obj = parser.parse(pageContent);
			JSONObject jsonobj = (JSONObject) obj;
			access_token = jsonobj.get("access_token").toString();
			refresh_token = jsonobj.get("refresh_token").toString();
			// writetoken(emailaddress,userpassword,refresh_token);
		} else {
			HtmlPage rootPage = webClient.getPage(openidurl
					+ "auth?scope=email%20profile&redirect_uri=" + callbackurl
					+ "&response_type=code&client_id=" + clientid);
			try {
				HtmlButton appbutton = rootPage
						.getHtmlElementById("submit_approve_access");
				Thread.sleep(2000);
				HtmlPage fpage = appbutton.click();
				HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
				code = codeinput.getValueAttribute();
			} catch (ElementNotFoundException e) {
				// ignore
			}

			WebRequest requestSettings = new WebRequest(new URL(openidurl
					+ "token"), HttpMethod.POST);
			requestSettings.setRequestParameters(getAssocQuery());

			Page page = webClient.getPage(requestSettings);

			String pageContent = page.getWebResponse().getContentAsString();
			JSONParser parser = new JSONParser();
			Object obj = parser.parse(pageContent);
			JSONObject jsonobj = (JSONObject) obj;
			access_token = jsonobj.get("access_token").toString();
		}

		JSONParser parser = new JSONParser();
		UnexpectedPage peoplePage = webClient
				.getPage("https://www.googleapis.com/plus/v1/people/me?access_token="
						+ access_token);
		Object obj = parser.parse(peoplePage.getWebResponse()
				.getContentAsString());
		JSONObject jsonobj = (JSONObject) obj;

		String familyname = null;
		String givenName = null;
		String imageurl = null;
		if (jsonobj.get("name") != null) {
			familyname = ((JSONObject) (jsonobj.get("name"))).get("familyName")
					.toString();
			givenName = ((JSONObject) (jsonobj.get("name"))).get("givenName")
					.toString();
		}
		if (jsonobj.get("image") != null) {
			imageurl = ((JSONObject) (jsonobj.get("image"))).get("url")
					.toString();
		}
		System.out.println(familyname);
		System.out.println(givenName);
		System.out.println(imageurl);

		GooglePrincipal googlePrincipal = new GooglePrincipal(emailaddress);

		return googlePrincipal;

	}

	private static List<NameValuePair> getAssocQuery() {
		List<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new NameValuePair("code", code));
		list.add(new NameValuePair("client_id", clientid));
		list.add(new NameValuePair("client_secret", clientsecret));
		list.add(new NameValuePair("redirect_uri", callbackurl));
		list.add(new NameValuePair("grant_type", "authorization_code"));
		return list;
	}

	private static List<NameValuePair> getRefreshtokenQuery() {
		List<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new NameValuePair("client_id", clientid));
		list.add(new NameValuePair("client_secret", clientsecret));
		list.add(new NameValuePair("refresh_token", refresh_token));
		list.add(new NameValuePair("grant_type", "refresh_token"));
		return list;
	}

	private static void writecookies(Set<Cookie> cookieset) throws Exception {
		FileWriter writer = new FileWriter(System.getProperty("user.home")
				+ File.separator + "google_cookie.txt");
		for (Cookie cookie : cookieset) {
			writer.write(cookie.getDomain() + " " + cookie.getName() + " "
					+ cookie.getValue() + newline);
			// System.out.println(cookie.getExpires());
		}

		writer.flush();
		writer.close();
	}

	private static Set<Cookie> getcookies() throws Exception {
		Set<Cookie> cookies = new HashSet<Cookie>();
		File tempfile = new File(System.getProperty("user.home")
				+ File.separator + "google_cookie.txt");
		if (tempfile.exists()) {
			BufferedReader br = null;
			Reader fr = null;
			fr = new FileReader(System.getProperty("user.home")
					+ File.separator + "google_cookie.txt");
			br = new BufferedReader(fr);
			while (br.ready()) {
				String line = br.readLine();
				String[] arr = line.split("\\s+");
				if (arr.length == 3) {
					cookies.add(new Cookie(arr[0], arr[1], arr[2]));
				}
			}
			br.close();
			fr.close();
		}
		return cookies;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {

		LoginDialog loginDialog = new LoginDialog(null, "Login to Google", null);

		loginDialog.setVisible(true);

		if (loginDialog.getStatus() == LoginDialog.TRY_LOGIN) {
			
			System.out.println("Try to login...");

			String emailaddress = loginDialog.getUsername();
			String userpassword = loginDialog.getPassword();

			GoogleOauth.authenticateGoogleUser(emailaddress, userpassword);

		} else {
			System.out.println("Please set username and password ! ");
			System.exit(0);
		}

	}
}
