/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.util.UriFilter;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public class IpRangeFilter
implements UriFilter {
    private byte[] matchTo;
    int numOfBits;

    public IpRangeFilter(String matchTo) {
        String[] parts = matchTo.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("IP range is not valid:" + matchTo);
        }
        try {
            InetAddress address = InetAddress.getByName(parts[0].trim());
            this.matchTo = address.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("IP range is not valid:" + matchTo);
        }
        this.numOfBits = Integer.parseInt(parts[1].trim());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(URI uri) {
        if (uri == null) return false;
        if (uri.getHost() == null) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(uri.getHost());
            byte[] addr = address.getAddress();
            if (addr.length != this.matchTo.length) {
                return false;
            }
            int bit = 0;
            int nibble = 0;
            block2: while (true) {
                if (nibble >= addr.length) {
                    return false;
                }
                int nibblePos = 7;
                while (true) {
                    if (nibblePos < 0) {
                        ++nibble;
                        continue block2;
                    }
                    int mask = 1 << nibblePos;
                    if ((this.matchTo[nibble] & mask) != (addr[nibble] & mask)) {
                        return false;
                    }
                    if (++bit >= this.numOfBits) {
                        return true;
                    }
                    --nibblePos;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return false;
    }
}

