/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.VeloCityHtmlGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ALLPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.CheckReviewStatusThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalCompositePolicy;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPolicy;
import de.ipk_gatersleben.bit.bi.edal.sample.TimeMeasure;
import java.io.UnsupportedEncodingException;
import java.security.Policy;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.security.auth.Subject;

public class DataManager {
    private static CheckReviewStatusThread checkReviewStatusThread;
    private static EdalConfiguration configuration;
    public static final Map<Principal, List<GrantableMethods.Methods>> DEFAULT_PERMISSIONS;
    private static ImplementationProvider implementationprovider;
    private static boolean isConfigurationValid;
    private static final int OPT_IN_INTERVAL = 5000;
    private static final int OPT_IN_TIMEOUT = 1800000;
    private static final String ROOT_CHEAT = "eDAL0815@ipk-gatersleben.de";
    private static InternetAddress rootCheat;
    private static EdalJettyServer server;
    private static InheritableThreadLocal<Map<Principal, List<GrantableMethods.Methods>>> threadlocaldefaultpermissions;
    private static CountDownLatch stopLatch;
    private static InheritableThreadLocal<Subject> threadlocalsubject;

    static {
        DEFAULT_PERMISSIONS = new HashMap<Principal, List<GrantableMethods.Methods>>();
        isConfigurationValid = false;
        threadlocalsubject = new InheritableThreadLocal();
        implementationprovider = null;
        threadlocaldefaultpermissions = new InheritableThreadLocal();
        configuration = null;
        checkReviewStatusThread = new CheckReviewStatusThread();
        server = null;
        ArrayList<GrantableMethods.Methods> methods = new ArrayList<GrantableMethods.Methods>();
        methods.add(GrantableMethods.Methods.listPrimaryDataEntities);
        methods.add(GrantableMethods.Methods.listPrimaryDataEntitiesByDate);
        methods.add(GrantableMethods.Methods.getPrimaryDataEntity);
        methods.add(GrantableMethods.Methods.read);
        methods.add(GrantableMethods.Methods.exist);
        methods.add(GrantableMethods.Methods.getParentDirectory);
        methods.add(GrantableMethods.Methods.searchByDublinCoreElement);
        methods.add(GrantableMethods.Methods.searchByMetaData);
        DEFAULT_PERMISSIONS.put(new ALLPrincipal(), methods);
        DataManager.resetDefaultPermissions();
        try {
            rootCheat = new InternetAddress(ROOT_CHEAT);
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        stopLatch = new CountDownLatch(1);
    }

    public static Long getAvailableStorageSpace() throws EdalException {
        if (DataManager.getImplProv() == null) {
            throw new EdalException("No ImplementationProvider set --> run getRootDirectory()");
        }
        return DataManager.getImplProv().getAvailableStorageSpace();
    }

    public static EdalConfiguration getConfiguration() {
        return configuration;
    }

    public static Map<Principal, List<GrantableMethods.Methods>> getDefaultPermissions() {
        return (Map)threadlocaldefaultpermissions.get();
    }

    public static ImplementationProvider getImplProv() {
        return implementationprovider;
    }

    static PrimaryDataEntity getPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        if (DataManager.getImplProv() == null || DataManager.getSubject() == null) {
            throw new EdalException("unable to load entity : start eDAL system first");
        }
        return DataManager.getImplProv().getPrimaryDataEntityByID(uuid, versionNumber);
    }

    static PrimaryDataEntity getPrimaryDataEntityForPersistenIdentifier(String uuid, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        if (DataManager.getImplProv() == null || DataManager.getSubject() == null) {
            throw new EdalException("unable to load entity : start eDAL system first");
        }
        return DataManager.getImplProv().getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, persistentIdentifier);
    }

    static PrimaryDataEntity getPrimaryDataEntityForReviewer(String uuid, long versionNumber, String internalId, int reviewerCode) throws EdalException {
        if (DataManager.getImplProv() == null || DataManager.getSubject() == null) {
            throw new EdalException("unable to load Entity : start eDAL system first");
        }
        return DataManager.getImplProv().getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, reviewerCode);
    }

    public static PrimaryDataDirectory getRootDirectory(ImplementationProvider implementationProvider, Subject subject) throws PrimaryDataDirectoryException {
        if (subject == null) {
            throw new PrimaryDataDirectoryException("Not allowed to use a null subject !");
        }
        Principal principal = null;
        Iterator<Principal> iterator = subject.getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p;
            principal = p = iterator.next();
        }
        if (stopLatch.getCount() == 0L) {
            stopLatch = new CountDownLatch(1);
        }
        threadlocalsubject.set(subject);
        implementationprovider = implementationProvider;
        configuration = implementationProvider.getConfiguration();
        try {
            implementationProvider.getConfiguration().getSupportedPrincipals().add(ALLPrincipal.class);
            if (!implementationProvider.getConfiguration().getSupportedPrincipals().contains(principal.getClass())) {
                DataManager.shutdown();
                throw new PrimaryDataDirectoryException("Your used principal class '" + principal.getClass() + "' is not in the supported principal list of your configuration");
            }
        }
        catch (EdalConfigurationException e) {
            DataManager.shutdown();
            throw new PrimaryDataDirectoryException(e);
        }
        try {
            implementationProvider.createMetaDataInstance().getClass().getConstructor(null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new PrimaryDataDirectoryException("Can not create a MetaData instance; change modifier of default constructor", e);
        }
        try {
            DataManager.initSecuritySystem(implementationProvider);
        }
        catch (SecurityException e) {
            throw new PrimaryDataDirectoryException("Can not initialize security system : " + e.getMessage(), e);
        }
        try {
            DataManager.initHTTPService();
        }
        catch (EdalException e) {
            throw new PrimaryDataDirectoryException("Can not initialize the HTTP Service : " + e.getMessage(), e);
        }
        if (!isConfigurationValid) {
            DataManager.initOptInProcess();
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownInterceptor());
        try {
            PrimaryDataDirectory root = PrimaryDataDirectory.getRootDirectory(implementationProvider.getConfiguration().getSupportedPrincipals());
            if (!isConfigurationValid) {
                checkReviewStatusThread.run();
            }
            isConfigurationValid = true;
            return root;
        }
        catch (EdalConfigurationException e) {
            throw new PrimaryDataDirectoryException(e.getCause());
        }
    }

    public static Subject getSubject() {
        return (Subject)threadlocalsubject.get();
    }

    public static List<Class<? extends Principal>> getSupportedPrincipals() throws EdalException {
        if (DataManager.getImplProv() == null) {
            throw new EdalException("No ImplementationProvider set -> run getRootDirectory()");
        }
        return DataManager.getImplProv().getSupportedPrincipals();
    }

    public static Long getUsedStorageSpace() throws EdalException {
        if (DataManager.getImplProv() == null) {
            throw new EdalException("No ImplementationProvider set -> run getRootDirectory()");
        }
        return DataManager.getImplProv().getUsedStorageSpace();
    }

    private static void initHTTPService() throws EdalException {
        if (server == null) {
            server = new EdalJettyServer(DataManager.getConfiguration());
            server.start();
        }
    }

    private static void initOptInProcess() throws PrimaryDataDirectoryException {
        block15: {
            try {
                InternetAddress newRootUser = DataManager.getImplProv().getRootUser();
                InternetAddress previousRootUser = DataManager.getImplProv().getPreviousRootUser();
                if (newRootUser.equals((Object)previousRootUser)) {
                    DataManager.getImplProv().getLogger().info((Object)"ALREADY ROOT CHEAT USED");
                    configuration.setErrorEmailAddress(DataManager.getImplProv().getPreviousRootUser());
                    break block15;
                }
                if (newRootUser.equals((Object)rootCheat)) {
                    UUID uuid = UUID.randomUUID();
                    DataManager.getImplProv().getLogger().info((Object)"ROOT CHEAT");
                    try {
                        DataManager.getImplProv().storeRootUser(DataManager.getSubject(), new InternetAddress(ROOT_CHEAT), uuid);
                        DataManager.getImplProv().validateRootUser(new InternetAddress(ROOT_CHEAT), uuid);
                        configuration.setErrorEmailAddress(DataManager.getImplProv().getPreviousRootUser());
                    }
                    catch (AddressException e) {
                        DataManager.getImplProv().getLogger().warn((Object)("unable to use ROOT CHEAT:" + e.getMessage()));
                        System.exit(0);
                    }
                    break block15;
                }
                if (previousRootUser == null) {
                    DataManager.getImplProv().getLogger().info((Object)"no root user defined ! ");
                    UUID uuid = UUID.randomUUID();
                    DataManager.getImplProv().storeRootUser(DataManager.getSubject(), newRootUser, uuid);
                    VeloCityHtmlGenerator veloCityHtmlGenerator = new VeloCityHtmlGenerator();
                    configuration.setErrorEmailAddress(newRootUser);
                    DataManager.sendEmail(veloCityHtmlGenerator.generateEmailForDoubleOptIn(EdalJettyServer.getServerURL(), newRootUser, uuid).toString(), "[eDAL-Service]: Double-Opt-In", newRootUser.getAddress());
                    Long startTime = System.currentTimeMillis();
                    DataManager.getImplProv().getLogger().info((Object)("Waiting for confirmation of root user '" + newRootUser.getAddress() + "'..."));
                    while (!implementationprovider.isRootValidated(newRootUser)) {
                        DataManager.getImplProv().getLogger().debug((Object)("Waiting for confirmation of root user '" + newRootUser.getAddress() + "'..."));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new PrimaryDataDirectoryException("error while waiting for user opt-in", e);
                        }
                        if (System.currentTimeMillis() - startTime <= 1800000L) continue;
                        DataManager.getImplProv().getLogger().error((Object)"Timeout for root user confirmation");
                        System.exit(0);
                    }
                    break block15;
                }
                if (!newRootUser.equals((Object)previousRootUser)) {
                    UUID uuid = UUID.randomUUID();
                    DataManager.getImplProv().storeRootUser(DataManager.getSubject(), newRootUser, uuid);
                    VeloCityHtmlGenerator veloCityHtmlGenerator = new VeloCityHtmlGenerator();
                    configuration.setErrorEmailAddress(newRootUser);
                    DataManager.sendEmail(veloCityHtmlGenerator.generateEmailForDoubleOptIn(EdalJettyServer.getServerURL(), newRootUser, uuid).toString(), "[eDAL-Service]: Double-Opt-In", newRootUser.getAddress());
                    Long startTime = System.currentTimeMillis();
                    DataManager.getImplProv().getLogger().info((Object)("Waiting for confirmation of root user '" + newRootUser.getAddress() + "'..."));
                    while (!implementationprovider.isRootValidated(newRootUser)) {
                        DataManager.getImplProv().getLogger().debug((Object)("Waiting for confirmation of root user '" + newRootUser.getAddress() + "'..."));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new PrimaryDataDirectoryException("error while waiting for user opt-in", e);
                        }
                        if (System.currentTimeMillis() - startTime <= 1800000L) continue;
                        DataManager.getImplProv().getLogger().error((Object)"Timeout for root user confirmation");
                        System.exit(0);
                    }
                    if (!previousRootUser.getAddress().equals(ROOT_CHEAT)) {
                        DataManager.sendEmail(veloCityHtmlGenerator.generateEmailForChangedRootUser(EdalJettyServer.getServerURL(), newRootUser, previousRootUser).toString(), "[eDAL-Server]: notice - root user transfered to " + newRootUser.getAddress(), previousRootUser.getAddress());
                    }
                    break block15;
                }
                DataManager.getImplProv().getLogger().info((Object)"Root user already registered !");
                configuration.setErrorEmailAddress(previousRootUser);
            }
            catch (EdalException e) {
                throw new PrimaryDataDirectoryException("unable to load root user, please check database", e);
            }
        }
    }

    private static void initSecuritySystem(ImplementationProvider implementationProvider) throws SecurityException {
        if (System.getProperty("java.security.policy") == null) {
            try {
                String policy = DataManager.class.getResource("policy.txt").toString();
                System.setProperty("java.security.policy", policy);
            }
            catch (Exception e) {
                throw new SecurityException("unable to find policy file", e);
            }
            System.setSecurityManager(new SecurityManager());
            EdalPolicy edalPolicy = null;
            try {
                edalPolicy = new EdalPolicy(implementationProvider.getPermissionProvider().newInstance());
            }
            catch (Exception e) {
                throw new SecurityException("unable to create new PermissionProvider", e);
            }
            ArrayList<Policy> policies = new ArrayList<Policy>(2);
            policies.add(edalPolicy);
            policies.add(Policy.getPolicy());
            Policy.setPolicy(new EdalCompositePolicy(policies));
        }
    }

    public static void resetDefaultPermissions() {
        DataManager.setDefaultPermissions(DEFAULT_PERMISSIONS);
    }

    private static void sendEmail(String message, String subject, String emailAddress) {
        Properties props = new Properties();
        props.put("mail.smtp.host", DataManager.getConfiguration().getMailSmtpHost());
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage mail = new MimeMessage(session);
        try {
            InternetAddress addressFrom = new InternetAddress(DataManager.getConfiguration().getEdalEmailAddress(), "eDAL-Service <" + DataManager.getConfiguration().getEdalEmailAddress() + ">");
            mail.setFrom((Address)addressFrom);
            InternetAddress addressTo = new InternetAddress(emailAddress);
            mail.setRecipient(Message.RecipientType.TO, (Address)addressTo);
            mail.setSubject(subject);
            mail.setContent((Object)message, "text/html");
            Transport.send((Message)mail);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
        }
    }

    public static void setDefaultPermissions(Map<Principal, List<GrantableMethods.Methods>> newUserPermissions) {
        threadlocaldefaultpermissions.set(newUserPermissions);
    }

    public static void setSubject(Subject subject) {
        threadlocalsubject.set(subject);
    }

    public static void shutdown() {
        try {
            implementationprovider.getLogger().info((Object)"Trying to shutdown EDALClient...");
            checkReviewStatusThread.done();
            DataManager.getImplProv().shutdown();
            if (server != null) {
                server.stop();
                server = null;
            }
            isConfigurationValid = false;
            stopLatch.countDown();
            implementationprovider.getLogger().info((Object)"EDALClient successfully closed !");
        }
        finally {
            TimeMeasure.aspectOf().ajc$after$de_ipk_gatersleben_bit_bi_edal_sample_TimeMeasure$2$1bffcdd7();
        }
    }

    public static void waitForShutDown() {
        try {
            stopLatch.await();
        }
        catch (InterruptedException e) {
            implementationprovider.getLogger().error((Object)("error while count down stopLatch:" + e.getMessage()), (Throwable)e);
        }
    }

    private static class ShutdownInterceptor
    extends Thread {
        private ShutdownInterceptor() {
        }

        @Override
        public void run() {
            DataManager.getImplProv().getLogger().warn((Object)"eDAL: JVM got external kill signal - graceful shut down");
            DataManager.shutdown();
        }
    }
}

