/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.VeloCityHtmlGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ZipThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class EdalJettyHandler
extends AbstractHandler {
    protected static final String NOT_FOUND = "Not Found";
    protected static final int OK_STATUS = 200;
    protected static final int NOT_FOUND_STATUS = 404;
    private static HashMap<Integer, List<String>> hashmap = new HashMap();
    private static ThreadPoolExecutor executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
    private static /* synthetic */ int[] $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions;

    /*
     * Unable to fully structure code
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block42: {
            block43: {
                if (!request.getMethod().equalsIgnoreCase("GET")) break block42;
                url = request.getRequestURI().toString();
                DataManager.getImplProv().getLogger().debug((Object)url);
                tokenizer = new StringTokenizer(url, "/");
                if (tokenizer.hasMoreTokens()) break block43;
                this.sendMessage(response, 404, "Not Found", "no ID and version specified");
                break block42;
            }
            methodToken = tokenizer.nextToken().toUpperCase();
            try {
                switch (EdalJettyHandler.$SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions()[EdalHttpFunctions.valueOf(methodToken).ordinal()]) {
                    case 7: 
                    case 8: {
                        if (tokenizer.hasMoreTokens()) {
                            internalId = tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                uuidToken = tokenizer.nextToken();
                                if (tokenizer.hasMoreTokens()) {
                                    versionToken = tokenizer.nextToken();
                                    try {
                                        versionNumber = Long.parseLong(versionToken);
                                        entity = null;
                                        if (tokenizer.hasMoreTokens()) {
                                            reviewerToken = tokenizer.nextToken();
                                            if (tokenizer.hasMoreElements()) {
                                                methodTokenForReviewer = tokenizer.nextToken();
                                                if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                    this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                    break;
                                                }
                                                if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                    this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                    break;
                                                }
                                                this.sendMessage(response, 404, "Not Found", "unable to process '" + methodTokenForReviewer + "'");
                                                break;
                                            }
                                            if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                break;
                                            }
                                            if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                break;
                                            }
                                            reviewer = 0;
                                            try {
                                                reviewer = Integer.parseInt(reviewerToken);
                                            }
                                            catch (NumberFormatException v0) {
                                                this.sendMessage(response, 404, "Not Found", "unable to process reviewer ID '" + reviewerToken + "', please check again");
                                                break;
                                            }
                                            entity = DataManager.getPrimaryDataEntityForReviewer(uuidToken, versionNumber, internalId, reviewer);
                                            this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(methodToken), reviewer);
                                            break;
                                        }
                                        entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuidToken, versionNumber, PersistentIdentifier.valueOf(methodToken));
                                        this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(methodToken), internalId);
                                    }
                                    catch (EdalException e) {
                                        this.sendMessage(response, 404, "Not Found", "unable to send data : " + e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, 404, "Not Found", "no version number set");
                                break;
                            }
                            this.sendMessage(response, 404, "Not Found", "no entity id set");
                            break;
                        }
                        this.sendMessage(response, 404, "Not Found", "no internal id set");
                        break;
                    }
                    case 5: {
                        uuidToken = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            versionToken = tokenizer.nextToken();
                            try {
                                versionNumber = Integer.parseInt(versionToken);
                                entity = null;
                                if (tokenizer.hasMoreElements()) {
                                    downloadToken = tokenizer.nextToken();
                                    if (EdalHttpFunctions.valueOf(downloadToken.toUpperCase()).equals((Object)EdalHttpFunctions.DOWNLOAD)) {
                                        entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                        if (!entity.isDirectory()) {
                                            this.sendFile((PrimaryDataFile)entity, versionNumber, response);
                                            break;
                                        }
                                        this.sendEntityMetaData(response, entity);
                                    }
                                    break;
                                }
                                entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                this.sendEntityMetaData(response, entity);
                            }
                            catch (EdalException | NumberFormatException e) {
                                if (e.getClass().equals(NumberFormatException.class)) {
                                    this.sendMessage(response, 404, "Not Found", "unable to cast '" + versionToken + "' to a version number");
                                    break;
                                }
                                this.sendMessage(response, 404, "Not Found", "unable to send data : " + e.getMessage());
                            }
                            break;
                        }
                        this.sendMessage(response, 404, "Not Found", "no version number set");
                        break;
                    }
                    case 1: {
                        ticketAccept = tokenizer.nextToken();
                        if (!tokenizer.hasMoreElements()) ** GOTO lbl104
                        try {
                            reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                            if (!this.checkIfAllowedToClick(reviewerHashCode, ticketAccept)) ** GOTO lbl98
                            DataManager.getImplProv().getApprovalServiceProvider().newInstance().accept(ticketAccept, reviewerHashCode);
                            ** GOTO lbl106
lbl98:
                            // 1 sources

                            this.sendMessage(response, 404, "Not Found", "Already clicked");
                        }
                        catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                            EdalJettyHandler.deleteTicketFromHashMap(ticketAccept);
                            this.sendMessage(response, 404, "Not Found", "Can not to accept ticket it seems to be already accepted/rejected: " + e.getMessage());
                        }
                        break;
lbl104:
                        // 1 sources

                        this.sendMessage(response, 404, "Not Found", "No ReviewerCode definded");
                        break;
lbl106:
                        // 1 sources

                        this.sendMessage(response, 200, "OK", "Thank you");
                        break;
                    }
                    case 2: {
                        ticketReject = tokenizer.nextToken();
                        if (!tokenizer.hasMoreElements()) ** GOTO lbl122
                        try {
                            reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                            if (!this.checkIfAllowedToClick(reviewerHashCode, ticketReject)) ** GOTO lbl116
                            DataManager.getImplProv().getApprovalServiceProvider().newInstance().reject(ticketReject, reviewerHashCode);
                            ** GOTO lbl124
lbl116:
                            // 1 sources

                            this.sendMessage(response, 404, "Not Found", "Already clicked");
                        }
                        catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                            EdalJettyHandler.deleteTicketFromHashMap(ticketReject);
                            this.sendMessage(response, 404, "Not Found", "Can not to reject ticket  it seems to be already accepted/rejected: " + e.getMessage());
                        }
                        break;
lbl122:
                        // 1 sources

                        this.sendMessage(response, 404, "Not Found", "No ReviewerCode definded");
                        break;
lbl124:
                        // 1 sources

                        this.sendMessage(response, 200, "OK", "Thank you");
                        break;
                    }
                    case 6: {
                        uuid = tokenizer.nextToken();
                        emailAddress = tokenizer.nextToken();
                        successful = false;
                        try {
                            successful = DataManager.getImplProv().validateRootUser(new InternetAddress(emailAddress), UUID.fromString(uuid));
                        }
                        catch (AddressException v1) {
                            this.sendMessage(response, 404, "eDAL-Server Admin confirmation failed", "");
                        }
                        if (successful.booleanValue()) {
                            try {
                                this.sendMessage(response, 200, "eDAL-Server Admin confirmation success", "Thank you <br/>You have successfully registered as administrator for eDAL-Server on " + EdalJettyServer.getServerURL() + "<br/>The server is now started in working mode.");
                            }
                            catch (EdalException v2) {
                                this.sendMessage(response, 404, "Error", "unable to load server URL");
                            }
                            break;
                        }
                        this.sendMessage(response, 404, "Error", "root user validation failed");
                        break;
                    }
                    case 9: {
                        if (tokenizer.hasMoreTokens()) {
                            logoUrl = tokenizer.nextToken();
                            if (logoUrl.equalsIgnoreCase("edal_scaled.png")) {
                                this.sendLogo(response, "edal_scaled.png");
                                break;
                            }
                            if (logoUrl.equalsIgnoreCase("zip_logo.png")) {
                                this.sendLogo(response, "zip_logo.png");
                            }
                        }
                        break;
                    }
                    default: {
                        this.sendMessage(response, 404, "Not Found", "path has to start with '" + (Object)EdalHttpFunctions.ACCEPT + "'" + " or '" + (Object)EdalHttpFunctions.REJECT + "'" + " or '" + (Object)EdalHttpFunctions.REVIEW + "'");
                        break;
                    }
                }
            }
            catch (IllegalArgumentException v3) {
                this.sendMessage(response, 404, "Not Found", "path has to start with '" + (Object)EdalHttpFunctions.ACCEPT + "'" + " or '" + (Object)EdalHttpFunctions.REJECT + "'" + " or '" + (Object)EdalHttpFunctions.REVIEW + "'");
            }
        }
        response.flushBuffer();
    }

    private boolean checkIfAllowedToClick(int reviewerHashCode, String ticketAccept) {
        List<String> list = hashmap.get(reviewerHashCode);
        if (list != null) {
            return !list.contains(ticketAccept);
        }
        ArrayList<String> newlist = new ArrayList<String>();
        newlist.add(ticketAccept);
        hashmap.put(reviewerHashCode, newlist);
        return true;
    }

    private void responseDownloadRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, Long versionNumber, String internalId, String identifierType, String reviewerId) throws EdalException {
        if (reviewerId == null) {
            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(identifierType), internalId);
            }
        } else {
            entity = DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerId));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(identifierType), Integer.parseInt(reviewerId));
            }
        }
    }

    private void responseZipRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, long versionNumber, String internalId, String identifierType, String reviewerId) throws EdalException {
        entity = reviewerId == null ? DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType)) : DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerId));
        if (entity.isDirectory()) {
            try {
                response.setHeader("Content-Disposition", "inline; filename=\"" + entity.getName() + ".zip" + "\"");
                response.setStatus(200);
                CountDownLatch countDownLatch = new CountDownLatch(1);
                ServletOutputStream responseBody = response.getOutputStream();
                ZipOutputStream zout = new ZipOutputStream((OutputStream)responseBody);
                ZipThread zipThread = new ZipThread(countDownLatch, zout, (PrimaryDataDirectory)entity);
                if (executor.isShutdown()) {
                    executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
                }
                executor.execute(zipThread);
                try {
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        throw new EdalException("unable to send zip file", e);
                    }
                }
                finally {
                    try {
                        zout.close();
                        responseBody.close();
                    }
                    catch (Exception e) {
                        DataManager.getImplProv().getLogger().error((Object)("unable to close zip streams : " + e.getMessage()));
                    }
                }
            }
            catch (IOException e) {
                throw new EdalException("unable to send zip file", e);
            }
        }
    }

    private void sendLogo(HttpServletResponse response, String logoName) {
        try {
            int len;
            InputStream logo = EdalJettyHandler.class.getResourceAsStream(logoName);
            int logoSize = logo.available();
            response.setContentType("image/png");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + logoName + "\"");
            response.setContentLength(logoSize);
            response.setStatus(200);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)logoSize);
            if (executor.isShutdown()) {
                executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
            }
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((len = logo.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, len);
            }
            pipedOut.flush();
            try {
                countDownLatch.await();
                logo.close();
                pipedOut.close();
                httpIn.close();
            }
            catch (InterruptedException e) {
                DataManager.getImplProv().getLogger().error((Object)("unable to wait for sending logo : " + e.getMessage()));
            }
            responseBody.close();
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send logo : " + e.getMessage()));
        }
    }

    private void sendEntityMetaData(HttpServletResponse response, PrimaryDataEntity entity) throws EdalException {
        try {
            int length;
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            StringWriter w = null;
            w = entity.isDirectory() ? velo.generateHtmlForDirectory((PrimaryDataDirectory)entity, EdalJettyServer.getServerURL()) : velo.generateHtmlForFile((PrimaryDataFile)entity, EdalJettyServer.getServerURL());
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(200);
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            if (executor.isShutdown()) {
                executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
            }
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = bis.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close html streams : " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendEntityMetaDataForPersistentIdentifier(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier identifierType, String internalId) throws EdalException {
        try {
            int length;
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            StringWriter w = null;
            w = entity.isDirectory() ? velo.generateHtmlForDirectoryOfSnapshot((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, EdalJettyServer.getServerURL()) : velo.generateHtmlForFileOfSnapshot((PrimaryDataFile)entity, versionNumber, identifierType, EdalJettyServer.getServerURL(), internalId);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(200);
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            if (executor.isShutdown()) {
                executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
            }
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = bis.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close html streams : " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendEntityMetaDataForReviewer(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode) throws EdalException {
        try {
            int length;
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            StringWriter w = null;
            w = entity.isDirectory() ? velo.generateHtmlForDirectoryForReviewer((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, EdalJettyServer.getServerURL(), reviewerCode) : velo.generateHtmlForFileForReviewer((PrimaryDataFile)entity, versionNumber, internalId, identifierType, EdalJettyServer.getServerURL(), reviewerCode);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(200);
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            if (executor.isShutdown()) {
                executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
            }
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = bis.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close html streams : " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendFile(PrimaryDataFile file, long versionNumber, HttpServletResponse response) throws EdalException {
        PrimaryDataFile currentFile = file;
        try {
            currentFile.switchCurrentVersion(currentFile.getVersionByRevisionNumber(versionNumber));
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            this.sendMessage(response, 404, NOT_FOUND, "no file found");
        }
        try {
            String type = "";
            Long size = null;
            try {
                type = ((DataFormat)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType();
                size = ((DataSize)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.SIZE)).getFileSize();
            }
            catch (MetaDataException e) {
                throw new EdalException("unable to load the MIME type/file size", e);
            }
            response.setContentType(type);
            response.setHeader("Content-Disposition", "inline; filename=\"" + currentFile.getName() + "\"");
            response.addHeader("Content-Length", size.toString());
            response.setStatus(200);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)size);
            if (executor.isShutdown()) {
                executor = new EdalThreadPoolExcecutor(1, Math.max(1, Runtime.getRuntime().availableProcessors()), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
            }
            executor.execute(pipedThread);
            currentFile.read(pipedOut);
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send file", e);
                }
            }
            finally {
                try {
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close download streams : " + e.getMessage()));
                }
            }
        }
        catch (PrimaryDataFileException | IOException e) {
            throw new EdalException("unable to send file", e);
        }
    }

    private void sendMessage(HttpServletResponse response, int responseCode, String title, String message) {
        try {
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            String htmlOutput = velo.generateHtmlForErrorMessage(responseCode, title, message, EdalJettyServer.getServerURL()).toString();
            response.setStatus(responseCode);
            response.setContentType("text/html");
            ServletOutputStream responseBody = response.getOutputStream();
            responseBody.write(htmlOutput.getBytes());
            responseBody.close();
        }
        catch (EdalException | IOException e) {
            e.printStackTrace();
            DataManager.getImplProv().getLogger().error((Object)("unable to send " + responseCode + "-message : " + e.getMessage()));
        }
    }

    public static void deleteTicketFromHashMap(String ticket) {
        for (Map.Entry<Integer, List<String>> entry : hashmap.entrySet()) {
            List<String> list = entry.getValue();
            if (!list.contains(ticket)) continue;
            list.remove(ticket);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions() {
        if ($SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions != null) {
            return $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions;
        }
        int[] nArray = new int[EdalHttpFunctions.values().length];
        try {
            nArray[EdalHttpFunctions.ACCEPT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.DOI.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.DOWNLOAD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.EDAL.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.LOGIN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.LOGO.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.REJECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.REVIEW.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.URL.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.ZIP.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions = nArray;
        return nArray;
    }
}

