/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import java.lang.reflect.Method;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="EDALPERMISSIONS")
@Table(indexes={@Index(name="index_internId", columnNames={"internId"})}, appliesTo="EDALPERMISSIONS")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="EdalPermission")
public class EdalPermissionImplementation
extends EdalPermission {
    private static final long serialVersionUID = -6598537001401120856L;
    private int id;
    private String internId;
    private Long internVersion;
    private GrantableMethods.EdalClasses internClass;
    private GrantableMethods.Methods internMethod;
    private PrincipalImplementation principal;

    protected EdalPermissionImplementation() {
    }

    protected EdalPermissionImplementation(PrincipalImplementation principal, String primaryDataEntityID, Long version, GrantableMethods.EdalClasses actionClass, GrantableMethods.Methods actionMethod) {
        this.setInternId(primaryDataEntityID);
        this.setInternVersion(version);
        this.setInternClass(actionClass);
        this.setInternMethod(actionMethod);
        this.setPrincipal(principal);
    }

    @Transient
    protected EdalPermission toEdalPermission() {
        Class<PrimaryDataEntity> clazz = null;
        if (this.getInternClass().equals((Object)GrantableMethods.EdalClasses.PrimaryDataEntity)) {
            clazz = PrimaryDataEntity.class;
        } else if (this.getInternClass().equals((Object)GrantableMethods.EdalClasses.PrimaryDataDirectory)) {
            clazz = PrimaryDataDirectory.class;
        } else if (this.getInternClass().equals((Object)GrantableMethods.EdalClasses.PrimaryDataFile)) {
            clazz = PrimaryDataFile.class;
        }
        Method method = null;
        try {
            method = this.getInternMethod().getImplClass(clazz);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        EdalPermission edalPermission = new EdalPermission(this.getInternId(), this.getInternVersion(), clazz, method);
        return edalPermission;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EdalPermissionImplementation)) {
            return false;
        }
        EdalPermissionImplementation other = (EdalPermissionImplementation)obj;
        if (this.internClass != other.internClass) {
            return false;
        }
        if (this.internId == null ? other.internId != null : !this.internId.equals(other.internId)) {
            return false;
        }
        if (this.internMethod != other.internMethod) {
            return false;
        }
        if (this.internVersion == null ? other.internVersion != null : !this.internVersion.equals(other.internVersion)) {
            return false;
        }
        return !(this.principal == null ? other.principal != null : !this.principal.equals(other.principal));
    }

    @Id
    @GeneratedValue
    protected int getId() {
        return this.id;
    }

    @Enumerated(value=EnumType.ORDINAL)
    private GrantableMethods.EdalClasses getInternClass() {
        return this.internClass;
    }

    @Column(columnDefinition="char(40)")
    private String getInternId() {
        return this.internId;
    }

    @Enumerated(value=EnumType.ORDINAL)
    private GrantableMethods.Methods getInternMethod() {
        return this.internMethod;
    }

    private Long getInternVersion() {
        return this.internVersion;
    }

    @ManyToOne
    protected PrincipalImplementation getPrincipal() {
        return this.principal;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.internClass == null ? 0 : this.internClass.hashCode());
        result = 31 * result + (this.internId == null ? 0 : this.internId.hashCode());
        result = 31 * result + (this.internMethod == null ? 0 : this.internMethod.hashCode());
        result = 31 * result + (this.internVersion == null ? 0 : this.internVersion.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }

    protected void setId(int id) {
        this.id = id;
    }

    private void setInternClass(GrantableMethods.EdalClasses internClass) {
        this.internClass = internClass;
    }

    private void setInternId(String internId) {
        this.internId = internId;
    }

    private void setInternMethod(GrantableMethods.Methods internMethod) {
        this.internMethod = internMethod;
    }

    private void setInternVersion(Long internVersion) {
        this.internVersion = internVersion;
    }

    private void setPrincipal(PrincipalImplementation principal) {
        this.principal = principal;
    }

    @Override
    public String toString() {
        return "EDALPermissionImplementation [internId=" + this.getInternId() + ", internVersion=" + this.getInternVersion() + ", internClass=" + (Object)((Object)this.getInternClass()) + ", internMethod=" + (Object)((Object)this.getInternMethod()) + ", principal=" + this.getPrincipal() + "]";
    }
}

