/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ApprovalServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.IndexWriterThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PermissionProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.RootImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.SupportedPrincipals;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaValidator;

public class FileSystemImplementationProvider
implements ImplementationProvider {
    private static final String EDALDB_DBNAME = "edaldb";
    private Logger logger;
    private static final int SQL_ERROR_DATABASE_IN_USE = 90020;
    private static final int SQL_ERROR_DATABASE_NOT_FOUND = 90013;
    private boolean autoIndexing;
    private EdalConfiguration configuration;
    private Connection connection;
    private String h2Pass;
    private String h2User;
    private IndexWriterThread indexThread;
    private InternetAddress rootUserAddress;
    private SessionFactory sessionFactory;

    public FileSystemImplementationProvider(EdalConfiguration configuration) {
        block31: {
            this.logger = null;
            this.connection = null;
            this.indexThread = null;
            this.rootUserAddress = null;
            this.sessionFactory = null;
            this.configuration = configuration;
            try {
                this.setRootUserAddress(configuration.getRootUser());
                this.setH2User(this.getConfiguration().getH2UserName());
                this.setH2Pass(this.getConfiguration().getH2Password());
            }
            catch (EdalConfigurationException e) {
                e.printStackTrace();
            }
            this.logger = configuration.getLogger();
            this.setAutoIndexing(this.autoIndexing);
            try {
                try {
                    Class.forName("org.h2.Driver");
                    this.setConnection(DriverManager.getConnection("jdbc:h2:" + this.getMountPath() + ";IFEXISTS=TRUE;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=0", this.getH2User(), this.getH2Pass()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.getLogger().error((Object)"Could not find driver for H2 connection !");
                    System.exit(0);
                }
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 90020) {
                    this.getLogger().warn((Object)"Database still in use -> close and restart please !");
                    System.exit(0);
                }
                if (se.getErrorCode() != 90013) break block31;
                this.getLogger().info((Object)"No database found -> creating new database...");
                try {
                    this.setConnection(DriverManager.getConnection("jdbc:h2:" + this.getMountPath() + ";DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=0", this.getH2User(), this.getH2Pass()));
                }
                catch (SQLException sQLException) {
                    this.getLogger().error((Object)"Could not start H2 connection !");
                    System.exit(0);
                }
            }
        }
        Configuration config = new Configuration();
        config.configure(FileSystemImplementationProvider.class.getResource("hibernate.cfg.xml"));
        config.setProperty("hibernate.connection.url", "jdbc:h2:" + this.getMountPath());
        config.setProperty("hibernate.connection.username", this.getH2User());
        config.setProperty("hibernate.connection.password", this.getH2Pass());
        config.setProperty("hibernate.search.default.indexBase", Paths.get(this.getMountPath().toString(), "lucene").toString());
        if (!this.isAutoIndexing()) {
            config.setProperty("hibernate.search.indexing_strategy", "manual");
        }
        Boolean exists = false;
        try {
            Throwable throwable = null;
            Object var5_11 = null;
            try (ResultSet result = this.getConnection().createStatement().executeQuery("SELECT count(*) FROM ENTITIES ");){
                result.last();
                int resultSize = result.getInt("COUNT(*)");
                if (resultSize > 0) {
                    exists = true;
                }
                result.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            exists = false;
        }
        if (!exists.booleanValue()) {
            new SchemaExport(config).create(false, true);
            try {
                this.setSessionFactory(config.buildSessionFactory());
            }
            catch (HibernateException e) {
                this.logger.error((Object)"Lucene Index damaged", (Throwable)e);
                this.logger.info((Object)"Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
        } else {
            try {
                this.setSessionFactory(config.buildSessionFactory());
            }
            catch (HibernateException e) {
                this.logger.debug((Object)"Lucene Index damaged", (Throwable)e);
                this.logger.info((Object)"Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
            try {
                new SchemaValidator(config).validate();
                this.getLogger().info((Object)"database schema is valid");
            }
            catch (HibernateException e) {
                this.getLogger().error((Object)("Found existing, but not compatible data schema in path '" + configuration.getMountPath() + "' (" + e.getMessage() + ") "));
                this.getLogger().error((Object)"Please delete path or specify another mount path !");
                System.exit(0);
            }
        }
        this.getSessionFactory().getStatistics().setStatisticsEnabled(true);
        if (!this.isAutoIndexing()) {
            this.setIndexThread(new IndexWriterThread(this.getSessionFactory()));
            this.getIndexThread().start();
        }
    }

    @Override
    public MetaDataImplementation createMetaDataInstance() {
        return new MetaDataImplementation();
    }

    @Override
    public Class<? extends ApprovalServiceProvider> getApprovalServiceProvider() {
        return ApprovalServiceProviderImplementation.class;
    }

    @Override
    public Long getAvailableStorageSpace() throws EdalException {
        if (this.getDataPath() == null || Files.notExists(this.getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            return Files.getFileStore(this.getDataPath()).getUsableSpace();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request available space", e);
        }
    }

    @Override
    public EdalConfiguration getConfiguration() {
        return this.configuration;
    }

    private Connection getConnection() {
        return this.connection;
    }

    public Path getDataPath() {
        return Paths.get(this.getConfiguration().getDataPath().toString(), EDALDB_DBNAME);
    }

    private String getH2Pass() {
        return this.h2Pass;
    }

    private String getH2User() {
        return this.h2User;
    }

    private IndexWriterThread getIndexThread() {
        return this.indexThread;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public Path getMountPath() {
        return Paths.get(this.getConfiguration().getMountPath().toString(), EDALDB_DBNAME);
    }

    @Override
    public Class<? extends PermissionProvider> getPermissionProvider() {
        return PermissionProviderImplementation.class;
    }

    @Override
    public InternetAddress getPreviousRootUser() throws EdalException {
        org.hibernate.Session session = this.getSession();
        RootImplementation rootUser = (RootImplementation)session.createCriteria(RootImplementation.class).uniqueResult();
        session.close();
        if (rootUser == null) {
            return null;
        }
        InternetAddress address = null;
        try {
            address = new InternetAddress(rootUser.getAddress());
        }
        catch (NullPointerException | AddressException throwable) {
            return null;
        }
        return address;
    }

    @Override
    public Class<? extends PrimaryDataDirectory> getPrimaryDataDirectoryProvider() {
        return PrimaryDataDirectoryImplementation.class;
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = this.getSessionFactory().openSession();
        Criteria getFile = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
        PrimaryDataFile file = (PrimaryDataFile)getFile.uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            Criteria getDirectory = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
            PrimaryDataDirectory directory = (PrimaryDataDirectory)getDirectory.uniqueResult();
            if (directory == null) {
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            List<PublicReference> list = directory.getCurrentVersion().getPublicReferences();
            for (PublicReference publicReference : list) {
                if (!publicReference.isPublic()) continue;
                if (publicReference.getReleaseDate() == null) {
                    return directory;
                }
                if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                    throw new EdalException("the PublicReference for this version of " + directory.getName() + " is locked until " + publicReference.getReleaseDate().getTime());
                }
                return directory;
            }
            throw new EdalException("found no PublicReference for this version of " + directory.getName());
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        List<PublicReference> list = file.getCurrentVersion().getPublicReferences();
        for (PublicReference publicReference : list) {
            if (!publicReference.isPublic()) continue;
            if (publicReference.getReleaseDate() == null) {
                return file;
            }
            if (publicReference.getReleaseDate().after(Calendar.getInstance())) {
                throw new EdalException("the PublicReference for this version of " + file.getName() + " is locked until " + publicReference.getReleaseDate().getTime());
            }
            return file;
        }
        throw new EdalException("found no PublicReference for this version of " + file.getName());
    }

    @Override
    public PrimaryDataEntity reloadPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = this.getSessionFactory().openSession();
        Criteria getFile = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
        PrimaryDataFile file = (PrimaryDataFile)getFile.uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            Criteria getDirectory = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
            PrimaryDataDirectory directory = (PrimaryDataDirectory)getDirectory.uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            session.close();
            return directory;
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        session.close();
        return file;
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForPersistenIdentifier(String uuid, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        Session session = this.getSessionFactory().openSession();
        PrimaryDataFile file = (PrimaryDataFile)session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
        if (file == null) {
            PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PublicReference reference = directory.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
                session.close();
                if (reference.isPublic()) {
                    if (reference.getReleaseDate() == null) {
                        return directory;
                    }
                    if (reference.getReleaseDate().after(Calendar.getInstance())) {
                        throw new EdalException("the PublicReference for this version of " + directory.getName() + " is locked until " + reference.getReleaseDate().getTime());
                    }
                    return directory;
                }
                return this.searchRekursiveForPersistentIdentifiers((org.hibernate.Session)session, directory, versionNumber, persistentIdentifier);
            }
            catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
                return this.searchRekursiveForPersistentIdentifiers((org.hibernate.Session)session, directory, versionNumber, persistentIdentifier);
            }
        }
        try {
            PublicReference reference = file.getVersionByRevisionNumber(versionNumber).getPublicReference(persistentIdentifier);
            session.close();
            if (reference.isPublic()) {
                if (reference.getReleaseDate() == null) {
                    return file;
                }
                if (reference.getReleaseDate().after(Calendar.getInstance())) {
                    throw new EdalException("the PublicReference for this version of " + file.getName() + " is locked until " + reference.getReleaseDate().getTime());
                }
                return file;
            }
            return this.searchRekursiveForPersistentIdentifiers((org.hibernate.Session)session, file, versionNumber, persistentIdentifier);
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            return this.searchRekursiveForPersistentIdentifiers((org.hibernate.Session)session, file, versionNumber, persistentIdentifier);
        }
    }

    /*
     * Unable to fully structure code
     */
    private PrimaryDataEntity searchRekursiveForPersistentIdentifiers(org.hibernate.Session session, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier persistentIdentifier) throws EdalException {
        version = null;
        try {
            version = entity.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException(e.getMessage());
        }
        ready = false;
        parent = null;
        try {
            parent = entity.getParentDirectory();
            if (parent == null) {
                session.close();
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            ** GOTO lbl47
        }
        catch (PrimaryDataDirectoryException v0) {
            session.close();
            throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
        }
lbl-1000:
        // 1 sources

        {
            set = parent.getVersions();
            found = false;
            for (PrimaryDataEntityVersion primaryDataEntityVersion : set) {
                try {
                    if (!primaryDataEntityVersion.getPublicReference(persistentIdentifier).isPublic() || !primaryDataEntityVersion.getRevisionDate().after(version.getRevisionDate())) continue;
                    found = true;
                }
                catch (PrimaryDataEntityVersionException v1) {
                    DataManager.getImplProv().getLogger().debug((Object)("no public reference found for '" + parent + "', trying next"));
                }
            }
            if (!found) {
                try {
                    parent = parent.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v2) {
                    session.close();
                    throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
                }
                if (parent != null) continue;
                session.close();
                throw new EdalException("no PublicReference for entity '" + entity.getName() + "' publicated");
            }
            session.close();
            ready = true;
lbl47:
            // 3 sources

            ** while (!ready)
        }
lbl48:
        // 1 sources

        return entity;
    }

    @Override
    public PrimaryDataEntity getPrimaryDataEntityForReviewer(String uuid, long versionNumber, String internalId, int reviewerCode) throws EdalException {
        Session session = this.getSessionFactory().openSession();
        ReviewersImplementation reviewer = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)reviewerCode)).uniqueResult();
        if (reviewer != null) {
            PrimaryDataFile file = (PrimaryDataFile)session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (file != null) {
                try {
                    PrimaryDataEntityVersion version = file.getVersionByRevisionNumber(versionNumber);
                    file.switchCurrentVersion(version);
                    session.close();
                    return file;
                }
                catch (PrimaryDataEntityVersionException e) {
                    session.close();
                    throw new EdalException(e.getMessage(), e);
                }
            }
            PrimaryDataDirectory directory = (PrimaryDataDirectory)session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid)).uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("no entity with ID '" + uuid + "' found !");
            }
            try {
                PrimaryDataEntityVersion version = directory.getVersionByRevisionNumber(versionNumber);
                directory.switchCurrentVersion(version);
                session.close();
                return directory;
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
        }
        session.close();
        throw new EdalException("no reviewer with ID '" + reviewerCode + "' found !");
    }

    @Override
    public Class<? extends PrimaryDataFile> getPrimaryDataFileProvider() {
        return PrimaryDataFileImplementation.class;
    }

    @Override
    public InternetAddress getRootUser() {
        return this.rootUserAddress;
    }

    public org.hibernate.Session getSession() {
        return this.getSessionFactory().openSession();
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Statistics getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    @Override
    public List<Class<? extends Principal>> getSupportedPrincipals() throws EdalException {
        Session session = this.getSessionFactory().openSession();
        Criteria principals = session.createCriteria(SupportedPrincipals.class);
        List privatePrincipals = principals.list();
        if (privatePrincipals.isEmpty()) {
            throw new EdalException("Unable to load all supported Principals : no type stored");
        }
        ArrayList<Class<? extends Principal>> list = new ArrayList<Class<? extends Principal>>(privatePrincipals.size());
        for (SupportedPrincipals principal : privatePrincipals) {
            try {
                list.add(Class.forName(principal.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new EdalException("Unable to load all supported Principals", e);
            }
        }
        return list;
    }

    @Override
    public Long getUsedStorageSpace() throws EdalException {
        if (this.getDataPath() == null || Files.notExists(this.getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(this.getDataPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request used space", e);
        }
    }

    private boolean isAutoIndexing() {
        return this.autoIndexing;
    }

    @Override
    public boolean isRootValidated(InternetAddress address) {
        org.hibernate.Session session = this.getSession();
        RootImplementation rootUser = (RootImplementation)session.createCriteria(RootImplementation.class).uniqueResult();
        session.close();
        if (rootUser.getAddress().equals(address.getAddress()) && rootUser.isValidated()) {
            this.getLogger().info((Object)"root user validated");
            return true;
        }
        return false;
    }

    @Override
    public PrimaryDataDirectory mount(List<Class<? extends Principal>> supportedPrincipals) throws PrimaryDataDirectoryException {
        Session session = this.getSessionFactory().openSession();
        Criteria checkRoot = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add(Restrictions.isNull((String)"parentDirectory"));
        if (checkRoot.uniqueResult() == null) {
            session.close();
            DataManager.getImplProv().getLogger().info((Object)"Creating new RootDirectory...");
            Session sess = this.getSessionFactory().openSession();
            Transaction transaction = sess.beginTransaction();
            for (Class<? extends Principal> clazz : supportedPrincipals) {
                sess.save((Object)new SupportedPrincipals(clazz));
            }
            transaction.commit();
            sess.close();
            PrimaryDataDirectory newRootDirectory = null;
            try {
                Constructor<? extends PrimaryDataDirectory> constructor = DataManager.getImplProv().getPrimaryDataDirectoryProvider().getConstructor(PrimaryDataDirectory.class, String.class);
                newRootDirectory = constructor.newInstance(null, "/");
            }
            catch (Exception e) {
                throw new PrimaryDataDirectoryException("Can not instantiate the constructor to mount implementation: " + e.getMessage(), e);
            }
            return newRootDirectory;
        }
        Criteria principals = session.createCriteria(SupportedPrincipals.class);
        List privatePrincipals = principals.list();
        ArrayList<SupportedPrincipals> publicPrincipals = new ArrayList<SupportedPrincipals>(supportedPrincipals.size());
        for (Class<? extends Principal> clazz : supportedPrincipals) {
            publicPrincipals.add(new SupportedPrincipals(clazz));
        }
        if (!privatePrincipals.containsAll(publicPrincipals)) {
            DataManager.getImplProv().getLogger().warn((Object)"Not all principals are supported , please define new list and connect again !");
            throw new PrimaryDataDirectoryException("Not all principals are supported , please define new list and connect again !");
        }
        DataManager.getImplProv().getLogger().info((Object)"All principals are supported !");
        DataManager.getImplProv().getLogger().info((Object)"Getting existing RootDirectory...");
        PrimaryDataDirectoryImplementation existingRootDirectory = (PrimaryDataDirectoryImplementation)checkRoot.uniqueResult();
        session.close();
        PrimaryDataDirectoryImplementation existingRootDirectoryOrg = existingRootDirectory;
        return existingRootDirectoryOrg;
    }

    private void setAutoIndexing(boolean autoIndexing) {
        this.autoIndexing = autoIndexing;
    }

    private void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void setH2Pass(String h2Pass) {
        this.h2Pass = h2Pass;
    }

    private void setH2User(String h2User) {
        this.h2User = h2User;
    }

    private void setIndexThread(IndexWriterThread indexThread) {
        this.indexThread = indexThread;
    }

    private void setRootUserAddress(InternetAddress rootUserAddress) {
        this.rootUserAddress = rootUserAddress;
    }

    private void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void shutdown() {
        if (!this.isAutoIndexing()) {
            this.getIndexThread().waitForFinish();
        }
        try {
            this.getConnection().close();
            this.getSessionFactory().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void storeRootUser(Subject subject, InternetAddress address, UUID uuid) throws EdalException {
        Principal principal = null;
        Iterator<Principal> iterator = subject.getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal p;
            principal = p = iterator.next();
        }
        if (principal == null) {
            throw new EdalException("could not get the current pricipal from the authenticated subject");
        }
        org.hibernate.Session session = this.getSession();
        Transaction transaction = session.beginTransaction();
        RootImplementation existingRoot = (RootImplementation)session.createCriteria(RootImplementation.class).uniqueResult();
        if (existingRoot != null) {
            session.delete((Object)existingRoot);
        }
        RootImplementation newRoot = new RootImplementation(principal.getName(), principal.getClass().getSimpleName(), address, uuid.toString());
        session.save((Object)newRoot);
        transaction.commit();
        session.close();
    }

    @Override
    public boolean validateRootUser(InternetAddress address, UUID uuid) {
        org.hibernate.Session session = this.getSession();
        Transaction transaction = session.beginTransaction();
        RootImplementation rootUser = (RootImplementation)session.createCriteria(RootImplementation.class).uniqueResult();
        if (rootUser.getAddress().equals(address.getAddress()) && rootUser.getUuid().equals(uuid.toString())) {
            rootUser.setValidated(true);
            session.update((Object)rootUser);
            transaction.commit();
            session.close();
            return true;
        }
        transaction.commit();
        session.close();
        return false;
    }
}

