/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ALLPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.RootImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PermissionProviderImplementation
implements Serializable,
PermissionProvider {
    private static final String CACHE_REGION_ROOT = "query.root";
    private static final String CACHE_REGION_FOR_PRINCIPALS = "query.principal";
    private static final String CACHE_REGION_FOR_PERMISSIONS = "query.permission";
    private static final String STRING_INTERN_VERSION = "internVersion";
    private static final String STRING_INTERN_METHOD = "internMethod";
    private static final String STRING_INTERN_CLASS = "internClass";
    private static final String STRING_INTERN_ID = "internId";
    private static final String STRING_PRINCIPAL = "principal";
    private static final String STRING_TYPE = "type";
    private static final String STRING_NAME = "name";
    private static final long serialVersionUID = -8397868034521482885L;
    private static final InheritableThreadLocal<String> THREAD_LOCAL_ENTITY_ID = new InheritableThreadLocal();

    public static InheritableThreadLocal<String> getThreadlocalentityid() {
        return THREAD_LOCAL_ENTITY_ID;
    }

    @Override
    public List<EdalPermission> findPermissions(Set<Principal> principalList) {
        DataManager.getImplProv().getLogger().debug((Object)"Start FindPermission ");
        ArrayList<EdalPermission> permissions = new ArrayList<EdalPermission>();
        List<EdalPermissionImplementation> internalPermissions = null;
        for (Principal principal : principalList) {
            try {
                internalPermissions = this.getEDALPermissionsFromDB(principal.getClass().getSimpleName(), principal.getName());
                for (EdalPermissionImplementation edalperm : internalPermissions) {
                    permissions.add(edalperm.toEdalPermission());
                }
            }
            finally {
                if (!internalPermissions.isEmpty()) break;
            }
        }
        if (permissions.isEmpty()) {
            internalPermissions = this.getEDALPermissionsFromDB(ALLPrincipal.class.getSimpleName(), new ALLPrincipal().getName());
            for (EdalPermissionImplementation edalperm : internalPermissions) {
                permissions.add(edalperm.toEdalPermission());
            }
        }
        return permissions;
    }

    private List<EdalPermissionImplementation> getEDALPermissionsFromDB(String principalType, String principalName) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria principalQuery = session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)STRING_NAME, (Object)principalName)).add((Criterion)Restrictions.eq((String)STRING_TYPE, (Object)principalType)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS);
        PrincipalImplementation principal = (PrincipalImplementation)principalQuery.uniqueResult();
        Criteria permissionQuery = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, PermissionProviderImplementation.getThreadlocalentityid().get())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS);
        List permissions = permissionQuery.list();
        session.close();
        return permissions;
    }

    @Override
    public void grantPermission(String principalType, String principalName, EdalPermission edalPermission) throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PrincipalImplementation principal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)STRING_NAME, (Object)principalName)).add((Criterion)Restrictions.eq((String)STRING_TYPE, (Object)principalType)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            principal = new PrincipalImplementation(principalName, principalType);
            EdalPermissionImplementation newPermission = new EdalPermissionImplementation(principal, edalPermission.getPrimaryDataEntityID(), edalPermission.getVersion(), GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()), GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()));
            Transaction transaction = null;
            try {
                transaction = session.beginTransaction();
                session.save((Object)principal);
                session.save((Object)newPermission);
                transaction.commit();
                session.close();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                    throw new PrimaryDataEntityException("Can not save principal for permission: " + e.getMessage() + "-> rollback");
                }
                throw new PrimaryDataEntityException("Can not save principal for permission: " + e.getMessage());
            }
        }
        EdalPermissionImplementation permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)edalPermission.getPrimaryDataEntityID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName())))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName())))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)edalPermission.getVersion())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
        if (permission == null) {
            EdalPermissionImplementation newPermission = new EdalPermissionImplementation(principal, edalPermission.getPrimaryDataEntityID(), edalPermission.getVersion(), GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName()), GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName()));
            Transaction transaction2 = null;
            try {
                transaction2 = session.beginTransaction();
                session.save((Object)newPermission);
                transaction2.commit();
            }
            catch (Exception e) {
                if (transaction2 != null) {
                    transaction2.rollback();
                    throw new PrimaryDataEntityException("Can not save permission: " + e.getMessage() + "-> rollback");
                }
                throw new PrimaryDataEntityException("Can not save permission: " + e.getMessage());
            }
        }
        session.close();
    }

    @Override
    public void grantPermission(String principalType, String principalName, PrimaryDataEntity entity) throws PrimaryDataEntityException {
        EdalPermissionImplementation newPermission;
        EdalPermissionImplementation permission;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PrincipalImplementation principal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)STRING_NAME, (Object)principalName)).add((Criterion)Restrictions.eq((String)STRING_TYPE, (Object)principalType)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            principal = new PrincipalImplementation(principalName, principalType);
            Transaction transaction = session.beginTransaction();
            session.save((Object)principal);
            transaction.commit();
        }
        Boolean isAllPrincipal = false;
        if (principal.getType().equals(ALLPrincipal.class.getSimpleName()) && principal.getName().equals(new ALLPrincipal().getName())) {
            isAllPrincipal = true;
        }
        Transaction trans = session.beginTransaction();
        for (GrantableMethods.Methods method : GrantableMethods.ENTITY_METHODS) {
            if (isAllPrincipal.booleanValue() && (method.equals((Object)GrantableMethods.Methods.grantPermission) || method.equals((Object)GrantableMethods.Methods.revokePermission)) || (permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataEntity))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult()) != null) continue;
            newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataEntity, method);
            session.save((Object)newPermission);
        }
        if (entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.DIRECTORY_METHODS) {
                permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataDirectory))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission != null) continue;
                newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataDirectory, method);
                session.save((Object)newPermission);
            }
        }
        if (!entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.FILE_METHODS) {
                permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataFile))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission != null) continue;
                newPermission = new EdalPermissionImplementation(principal, entity.getID(), entity.getCurrentVersion().getRevision(), GrantableMethods.EdalClasses.PrimaryDataFile, method);
                session.save((Object)newPermission);
            }
        }
        trans.commit();
        session.close();
    }

    @Override
    public boolean isRoot(Principal principal) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        RootImplementation root = (RootImplementation)session.createCriteria(RootImplementation.class).setCacheable(true).setCacheRegion(CACHE_REGION_ROOT).uniqueResult();
        if (root == null) {
            Transaction transaction = session.beginTransaction();
            session.save((Object)new RootImplementation(principal.getName(), principal.getClass().getSimpleName()));
            transaction.commit();
            session.close();
            return true;
        }
        if (root.getName().equals(principal.getName()) && root.getType().equals(principal.getClass().getSimpleName())) {
            session.close();
            return true;
        }
        session.close();
        return false;
    }

    @Override
    public void revokePermission(String principalType, String principalName, EdalPermission edalPermission) throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PrincipalImplementation principal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)STRING_NAME, (Object)principalName)).add((Criterion)Restrictions.eq((String)STRING_TYPE, (Object)principalType)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            throw new PrimaryDataEntityException("couldn't found the correct principal to delete permission" + edalPermission.getActionMethod().getName());
        }
        EdalPermissionImplementation permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.valueOf(edalPermission.getActionClass().getSimpleName())))).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)edalPermission.getPrimaryDataEntityID())).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)GrantableMethods.Methods.valueOf(edalPermission.getActionMethod().getName())))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)edalPermission.getVersion())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
        if (permission == null) {
            throw new PrimaryDataEntityException("couldn't found method permission to delete " + edalPermission.getActionMethod().getName());
        }
        Transaction transaction = session.beginTransaction();
        session.delete((Object)permission);
        transaction.commit();
        session.close();
    }

    @Override
    public void revokePermission(String principalType, String principalName, PrimaryDataEntity entity) throws PrimaryDataEntityException {
        Transaction transaction;
        EdalPermissionImplementation permission;
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PrincipalImplementation principal = (PrincipalImplementation)session.createCriteria(PrincipalImplementation.class).add((Criterion)Restrictions.eq((String)STRING_NAME, (Object)principalName)).add((Criterion)Restrictions.eq((String)STRING_TYPE, (Object)principalType)).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PRINCIPALS).uniqueResult();
        if (principal == null) {
            throw new PrimaryDataEntityException("couldn't found the correct principal to delete permission");
        }
        for (GrantableMethods.Methods method : GrantableMethods.ENTITY_METHODS) {
            permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataEntity))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
            if (permission == null) continue;
            transaction = session.beginTransaction();
            session.delete((Object)permission);
            transaction.commit();
        }
        if (entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.DIRECTORY_METHODS) {
                permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataDirectory))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission == null) continue;
                transaction = session.beginTransaction();
                session.delete((Object)permission);
                transaction.commit();
            }
        }
        if (!entity.isDirectory()) {
            for (GrantableMethods.Methods method : GrantableMethods.FILE_METHODS) {
                permission = (EdalPermissionImplementation)session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)STRING_INTERN_ID, (Object)entity.getID())).add((Criterion)Restrictions.eq((String)STRING_PRINCIPAL, (Object)principal)).add((Criterion)Restrictions.eq((String)STRING_INTERN_CLASS, (Object)((Object)GrantableMethods.EdalClasses.PrimaryDataFile))).add((Criterion)Restrictions.eq((String)STRING_INTERN_METHOD, (Object)((Object)method))).add((Criterion)Restrictions.eq((String)STRING_INTERN_VERSION, (Object)entity.getCurrentVersion().getRevision())).setCacheable(true).setCacheRegion(CACHE_REGION_FOR_PERMISSIONS).uniqueResult();
                if (permission == null) continue;
                transaction = session.beginTransaction();
                session.delete((Object)permission);
                transaction.commit();
            }
        }
        session.close();
    }

    @Override
    public void setPermissionObjectID(String id) {
        PermissionProviderImplementation.getThreadlocalentityid().set(id);
    }
}

