/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReferenceException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.mail.internet.InternetAddress;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.BooleanType;

@Entity
@Table(name="ENTITY_VERSIONS")
@TypeDefs(value={@TypeDef(name="BooleanType", typeClass=BooleanType.class)})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="EdalVersion")
public class PrimaryDataEntityVersionImplementation
extends PrimaryDataEntityVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String primaryEntityId;
    private MetaDataImplementation metaData;
    private List<PublicReferenceImplementation> internReferences = new ArrayList<PublicReferenceImplementation>();
    private PrincipalImplementation owner;

    public void addPublicReference(PublicReferenceImplementation publicReference) {
        this.internReferences.add(publicReference);
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreationDate() {
        return super.getCreationDate();
    }

    @Type(type="BooleanType")
    public boolean getDeleted() {
        return super.isDeleted();
    }

    @Override
    @Transient
    public PrimaryDataEntity getEntity() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria fileQuery = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"id", (Object)this.getPrimaryEntityId())).setCacheable(true);
        PrimaryDataFile pdf = (PrimaryDataFile)fileQuery.uniqueResult();
        if (pdf == null) {
            Criteria directoryQuery = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"id", (Object)this.getPrimaryEntityId())).setCacheable(true);
            PrimaryDataDirectory pdd = (PrimaryDataDirectory)directoryQuery.uniqueResult();
            return pdd;
        }
        return pdf;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="version")
    public List<PublicReferenceImplementation> getInternReferences() {
        return this.internReferences;
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public MetaDataImplementation getMetaData() {
        return this.metaData;
    }

    @Column(columnDefinition="char(40)")
    public String getPrimaryEntityId() {
        return this.primaryEntityId;
    }

    @Override
    @Transient
    public List<PublicReference> getPublicReferences() {
        ArrayList<PublicReference> publicList = new ArrayList<PublicReference>(this.getInternReferences());
        return publicList;
    }

    @Override
    public long getRevision() {
        return super.getRevision();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getRevisionDate() {
        return super.getRevisionDate();
    }

    @Override
    public void setAllReferencesPublic(InternetAddress emailNotificationAddress, Calendar releaseDate) throws PublicReferenceException {
        for (PublicReferenceImplementation publicReferenceImplementation : this.getInternReferences()) {
            publicReferenceImplementation.setPublic(emailNotificationAddress, releaseDate);
        }
    }

    @Override
    protected void setCreationDate(Calendar creationDate) {
        super.setCreationDate(creationDate);
    }

    @Override
    protected void setDeleted(boolean isDeleted) {
        super.setDeleted(isDeleted);
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setInternReferences(List<PublicReferenceImplementation> internReferences) {
        this.internReferences = internReferences;
    }

    protected void setMetaData(MetaDataImplementation metaData) {
        this.metaData = metaData;
        super.setMetaData(metaData);
    }

    protected void setPrimaryEntityId(String primaryEntityId) {
        this.primaryEntityId = primaryEntityId;
    }

    @Override
    protected void setRevision(long revision) {
        super.setRevision(revision);
    }

    @Override
    protected void setRevisionDate(Calendar revisionDate) {
        super.setRevisionDate(revisionDate);
    }

    @Override
    @ManyToOne
    public PrincipalImplementation getOwner() {
        return this.owner;
    }

    protected void setOwner(PrincipalImplementation owner) {
        this.owner = owner;
    }
}

