/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="PRINCIPALS")
public class PrincipalImplementation
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private String type;
    private Set<EdalPermissionImplementation> permissions = new HashSet<EdalPermissionImplementation>();

    protected PrincipalImplementation() {
    }

    protected PrincipalImplementation(String name, String type) {
        this.name = name;
        this.type = type;
    }

    @Id
    @GeneratedValue
    protected int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void setPermissions(Set<EdalPermissionImplementation> permissions) {
        this.permissions = permissions;
    }

    @OneToMany(targetEntity=EdalPermissionImplementation.class, mappedBy="principal")
    protected Set<EdalPermissionImplementation> getPermissions() {
        return this.permissions;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalImplementation)) {
            return false;
        }
        PrincipalImplementation other = (PrincipalImplementation)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType()));
    }

    @Transient
    public Principal toPrincipal() throws EdalException {
        List<Class<? extends Principal>> list = DataManager.getSupportedPrincipals();
        for (Class<? extends Principal> clazz : list) {
            if (!this.type.equals(clazz.getSimpleName())) continue;
            Principal principal = null;
            try {
                Constructor<? extends Principal> constructor = clazz.getConstructor(String.class);
                principal = constructor.newInstance(this.name);
            }
            catch (Exception e) {
                throw new EdalException("Can not to convert to public principal type " + this.type + " : " + e.getMessage());
            }
            return principal;
        }
        return null;
    }

    @Override
    public String toString() {
        return "PrincipalImplementation [name=" + this.getName() + ", type=" + this.getType() + "]";
    }
}

