/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ReviewStatus;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.Principal;
import javax.mail.internet.InternetAddress;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

class VeloCityGenerator {
    private static final String CODING_UTF_8 = "UTF-8";

    VeloCityGenerator() {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        Velocity.setProperty((String)"input.encoding", (Object)CODING_UTF_8);
        Velocity.setProperty((String)"output.encoding", (Object)CODING_UTF_8);
        Velocity.init();
    }

    protected StringWriter generateRequestEmail(PrimaryDataEntityVersion entityVersion, URL acceptURL, URL rejectURL, URL reviewURL, Principal principal, InternetAddress mailAdress, ReviewStatus.ReviewerType reviewerType, URL reviewerURL, PersistentIdentifier idType) throws VelocityException {
        VelocityContext context = new VelocityContext();
        context.put("id", (Object)idType.toString());
        context.put("reviewerType", (Object)reviewerType.name());
        context.put("reviewer", (Object)mailAdress.toString());
        context.put("principal", (Object)principal.getName());
        context.put("acceptURL", (Object)acceptURL.toString());
        context.put("rejectURL", (Object)rejectURL.toString());
        context.put("reviewURL", (Object)reviewURL.toString());
        context.put("infos", (Object)entityVersion.getMetaData());
        context.put("infos_string", (Object)entityVersion.getMetaData().toString());
        context.put("entity", (Object)entityVersion.getEntity());
        context.put("version", (Object)entityVersion);
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put("landingpage", (Object)reviewerURL.toString());
        StringWriter output = new StringWriter();
        try {
            switch (reviewerType.name()) {
                case "MANAGING": {
                    Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/RequestEmailManagingTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
                    break;
                }
                case "SCIENTIFIC": {
                    Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/RequestEmailScientificTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
                    break;
                }
                case "SUBSTITUTE": {
                    Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/RequestEmailSubstituteTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
                }
            }
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new VelocityException("unable to write eMail output", (Throwable)e);
        }
        return output;
    }

    protected StringWriter generateAcceptedEmail(String newId, URL landingPage, PublicReference publicReference) throws VelocityException {
        VelocityContext context = new VelocityContext();
        context.put("newId", (Object)newId);
        context.put("landingPage", (Object)landingPage);
        context.put("infos", (Object)publicReference.getVersion().getMetaData().toString());
        StringWriter output = new StringWriter();
        try {
            Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/AcceptedEmailTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new VelocityException("unable to write eMail output", (Throwable)e);
        }
        return output;
    }

    protected StringWriter generateRejectedEmail(PublicReference publicReference) throws VelocityException {
        VelocityContext context = new VelocityContext();
        context.put("infos", (Object)publicReference.getVersion().getMetaData().toString());
        StringWriter output = new StringWriter();
        try {
            Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/RejectedEmailTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new VelocityException("unable to write eMail output", (Throwable)e);
        }
        return output;
    }

    protected StringWriter generateStatusEmail(PublicReference reference) throws VelocityException {
        VelocityContext context = new VelocityContext();
        context.put("id", (Object)reference.getIdentifierType().toString());
        context.put("user", (Object)reference.getRequestedPrincipal().getName());
        context.put("reference", (Object)reference);
        context.put("version", (Object)reference.getVersion());
        context.put("infos", (Object)reference.getVersion().getMetaData().toString());
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        StringWriter output = new StringWriter();
        try {
            Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/file/implementation/StatusEmailTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new VelocityException("unable to write eMail output", (Throwable)e);
        }
        return output;
    }
}

