/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ReviewStatus;
import java.util.List;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CheckReviewStatusJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ApprovalServiceProvider app = null;
        try {
            app = DataManager.getImplProv().getApprovalServiceProvider().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            DataManager.getImplProv().getLogger().error((Object)e);
            throw new JobExecutionException("Unable to load ApprovalServiceProvider: " + e.getMessage(), e.getCause());
        }
        Map<PublicReference, List<ReviewStatus>> map = app.getAllOpenReviewProcesses();
        if (map.isEmpty()) {
            DataManager.getImplProv().getLogger().debug((Object)"Running CheckReviewStatusJob : found no open requests !");
        } else {
            DataManager.getImplProv().getLogger().debug((Object)("Running CheckReviewStatusJob : found " + map.size() + " open requests !"));
        }
        try {
            app.checkOpenReviewProcesses(map);
        }
        catch (EdalApprovalException e) {
            DataManager.getImplProv().getLogger().error((Object)e);
            throw new JobExecutionException("unable to check open review processes: " + e.getMessage(), e.getCause());
        }
    }
}

