/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalPublicationMetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalReferenceable;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteSearchConnector;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteXmlMapper;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlResource;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import javax.xml.bind.JAXBException;

public class DataCiteReference
implements EdalReferenceable {
    private static final String TEST_URL = "http://doi.ipk-gatersleben.de/testdata/demo_doi_landingpage/";
    private static final String TEST_DOI = "10.5072/EDALTEST/12345";

    @Override
    public String acceptApprovalRequest(PublicReference publicReference) throws EdalApprovalException {
        if (!DataManager.getConfiguration().isInTestMode()) {
            try {
                int year = Calendar.getInstance().get(1);
                String doi = this.getPersistentIdentifier(year);
                DataManager.getImplProv().getLogger().info((Object)("Next Free DOI from DataCite: " + doi));
                StringBuffer dataCiteXml = this.generateDataCiteXML(publicReference, doi);
                DataManager.getImplProv().getLogger().info((Object)("Generated DataCite XML : \n" + dataCiteXml));
                try {
                    publicReference.getVersion().getURL().toString();
                }
                catch (PrimaryDataEntityException e1) {
                    e1.printStackTrace();
                }
                DataManager.getImplProv().getLogger().info((Object)("Validating : " + doi + "..."));
                this.validateMetaData(publicReference.getVersion());
                DataManager.getImplProv().getLogger().info((Object)"Validation successful !");
                try {
                    DataManager.getImplProv().getApprovalServiceProvider().newInstance().storeNewDOI(publicReference, doi, year);
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new EdalApprovalException("unable to store a new DOI for the PublicReference");
                }
                return doi;
            }
            catch (EdalException | EdalPublicationMetaDataException e) {
                throw new EdalApprovalException("unable to accept approvalRequest", e);
            }
        }
        try {
            int year = Calendar.getInstance().get(1);
            StringBuffer dataCiteXml = this.generateDataCiteXML(publicReference, TEST_DOI);
            this.validateMetaData(publicReference.getVersion());
            System.out.println(dataCiteXml);
            System.out.println(TEST_DOI);
            try {
                DataManager.getImplProv().getApprovalServiceProvider().newInstance().storeNewDOI(publicReference, TEST_DOI, year);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new EdalApprovalException("unable to store a new DOI for the PublicReference");
            }
            DataManager.getImplProv().getLogger().warn((Object)"Your PublicReference was not posted to DataCite, because you are running in Test-Mode");
            return TEST_DOI;
        }
        catch (EdalException | EdalPublicationMetaDataException e) {
            throw new EdalApprovalException("unable to accept approvalRequest:" + e.getMessage(), e.getCause());
        }
    }

    private StringBuffer generateDataCiteXML(PublicReference publicReference, String doi) throws EdalPublicationMetaDataException {
        DataCiteXmlMapper xmlMapper = new DataCiteXmlMapper(publicReference.getVersion());
        XmlResource xmlResource = xmlMapper.createXmlResource();
        xmlResource.setIdentifier(new XmlIdentifier(doi));
        StringWriter strw = new StringWriter();
        try {
            xmlMapper.createXmlMarshaller().marshal((Object)xmlResource, (Writer)strw);
        }
        catch (JAXBException e) {
            throw new EdalPublicationMetaDataException("Unable to marshall meta data from PublicReference", e);
        }
        return strw.getBuffer();
    }

    private String getPersistentIdentifier(int year) throws EdalException {
        try {
            return new DataCiteSearchConnector().generateNewDOI(year);
        }
        catch (DataCiteException e) {
            throw new EdalException("unable to load persistent identifier", e);
        }
    }

    @Override
    public void rejectApprovalRequest(PublicReference publicReference) throws EdalApprovalException {
    }

    @Override
    public void validateMetaData(PrimaryDataEntityVersion entityVersion) throws EdalPublicationMetaDataException {
        DataCiteXmlMapper mapper = new DataCiteXmlMapper(entityVersion);
        XmlResource resource = mapper.createXmlResource();
        mapper.validateSchema(resource);
    }

    @Override
    public void validate(PrimaryDataEntityVersion entityVersion) throws EdalPublicationMetaDataException {
    }
}

