/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ReviewResult;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ReviewStatus;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ReviewProcess {
    private static final int DEFAULT_TIMEOUT = 432000000;

    public static ReviewResult review(List<ReviewStatus> reviewStatusList) throws EdalApprovalException {
        ReviewResult reviewResult = new ReviewResult();
        if (reviewStatusList.size() == 0) {
            try {
                ReviewStatus scientificReviewStatus = new ReviewStatus();
                scientificReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerScientific());
                scientificReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                scientificReviewStatus.setRequestedDate(Calendar.getInstance());
                scientificReviewStatus.setReviewerType(ReviewStatus.ReviewerType.SCIENTIFIC);
                ReviewStatus substituteReviewStatus = new ReviewStatus();
                substituteReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerSubstitute());
                substituteReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                substituteReviewStatus.setRequestedDate(Calendar.getInstance());
                substituteReviewStatus.setReviewerType(ReviewStatus.ReviewerType.SUBSTITUTE);
                ReviewStatus managingReviewStatus = new ReviewStatus();
                managingReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerManaging());
                managingReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                managingReviewStatus.setRequestedDate(Calendar.getInstance());
                managingReviewStatus.setReviewerType(ReviewStatus.ReviewerType.MANAGING);
                reviewResult.setReviewerStatusList(Arrays.asList(scientificReviewStatus, substituteReviewStatus, managingReviewStatus));
                reviewResult.setReviewStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                return reviewResult;
            }
            catch (EdalConfigurationException e) {
                throw new EdalApprovalException(e);
            }
        }
        if (reviewStatusList.size() != 3) {
            throw new EdalApprovalException("Unexpected reviewStatusList size. Expected was 3 but list size was " + reviewStatusList.size() + ".");
        }
        ReviewStatus scientificReviewStatus = null;
        ReviewStatus substituteReviewStatus = null;
        ReviewStatus managingReviewStatus = null;
        for (ReviewStatus reviewStatus : reviewStatusList) {
            switch (reviewStatus.getReviewerType()) {
                case SCIENTIFIC: {
                    scientificReviewStatus = reviewStatus;
                    break;
                }
                case SUBSTITUTE: {
                    substituteReviewStatus = reviewStatus;
                    break;
                }
                case MANAGING: {
                    managingReviewStatus = reviewStatus;
                }
            }
        }
        if (!ReviewProcess.isTimeoutExceeded(managingReviewStatus.getRequestedDate())) {
            if (managingReviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) {
                reviewResult.setReviewStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                return reviewResult;
            }
            reviewResult.setReviewStatusType(managingReviewStatus.getStatusType());
            return reviewResult;
        }
        if (!managingReviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) {
            reviewResult.setReviewStatusType(managingReviewStatus.getStatusType());
            return reviewResult;
        }
        if (!scientificReviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) {
            reviewResult.setReviewStatusType(scientificReviewStatus.getStatusType());
            return reviewResult;
        }
        if (!substituteReviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) {
            reviewResult.setReviewStatusType(substituteReviewStatus.getStatusType());
            return reviewResult;
        }
        reviewResult.setReviewStatusType(ReviewStatus.ReviewStatusType.REJECTED);
        return reviewResult;
    }

    private static boolean isTimeoutExceeded(Calendar requestedDate) {
        Calendar now = Calendar.getInstance();
        long difference = now.getTimeInMillis() - requestedDate.getTimeInMillis();
        return difference > 432000000L;
    }
}

