/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class DataCiteSearchConnector {
    private static final String IPK_PREFIX = "10.5447";
    private HttpSolrServer dataciteSolrServer = null;

    public DataCiteSearchConnector() throws DataCiteException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpHost httpProxy = new HttpHost(DataManager.getConfiguration().getHttpProxyHost(), DataManager.getConfiguration().getHttpProxyPort());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxy);
        }
        catch (EdalConfigurationException edalConfigurationException) {
            DataManager.getImplProv().getLogger().debug((Object)"SolrSearchServer use no proxy");
        }
        this.dataciteSolrServer = new HttpSolrServer("http://search.datacite.org/api/", (HttpClient)httpClient);
    }

    public int getNumberOfDOIs(int year) throws DataCiteException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("q", new String[]{"10.5447 and IPK and " + year});
        solrParams.set("fl", new String[]{"doi"});
        solrParams.set("qt", new String[]{"/"});
        int numberOfResult = 0;
        try {
            numberOfResult = this.dataciteSolrServer.query((SolrParams)solrParams).getResults().size();
        }
        catch (SolrServerException e) {
            e.printStackTrace();
            throw new DataCiteException("unable to query the number of stored DOIs", e);
        }
        return numberOfResult;
    }

    public String generateNewDOI(int year) throws DataCiteException {
        return "10.5447/IPK/" + year + "/" + this.getNumberOfDOIs(year);
    }
}

