/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlNameIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types.ContributorType;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="contributor")
public class XmlContributor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContributorType contributorType;
    private String contributorName;
    private XmlNameIdentifier nameIdentifier;

    public XmlContributor() {
    }

    public XmlContributor(String contributorName) {
        this();
        this.setContributorName(contributorName);
    }

    public XmlContributor(String contributorName, ContributorType contributorType) {
        this(contributorName);
        this.setContributorType(contributorType);
    }

    public XmlContributor(Person person) {
        this();
        if (person instanceof NaturalPerson) {
            NaturalPerson naturalPerson = (NaturalPerson)person;
            this.setContributorName(String.valueOf(naturalPerson.getGivenName()) + " " + naturalPerson.getSureName() + ", " + naturalPerson.getZip() + " " + naturalPerson.getAddressLine() + ", " + naturalPerson.getCountry());
        } else if (person instanceof LegalPerson) {
            LegalPerson legalPerson = (LegalPerson)person;
            this.setContributorName(String.valueOf(legalPerson.getLegalName()) + " " + legalPerson.getZip() + " " + legalPerson.getAddressLine() + ", " + legalPerson.getCountry());
        }
    }

    @XmlElement(required=true)
    public String getContributorName() {
        return this.contributorName;
    }

    @XmlAttribute
    public ContributorType getContributorType() {
        return this.contributorType;
    }

    @XmlElement
    public XmlNameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setContributorName(String contributorName) {
        this.contributorName = contributorName;
    }

    public void setContributorType(ContributorType contributorType) {
        this.contributorType = contributorType;
    }

    public void setNameIdentifier(XmlNameIdentifier nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }
}

