/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types.DateType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="dates")
public class XmlDates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<XmlDate> dateList = new ArrayList<XmlDate>();

    public XmlDates() {
    }

    public XmlDates(DateEvents elementValue) {
        this();
        Set<EdalDate> set = elementValue.getSet();
        for (EdalDate timePoint : set) {
            if (timePoint instanceof EdalDateRange) {
                EdalDateRange range = (EdalDateRange)timePoint;
                XmlDate xmlDate = new XmlDate();
                xmlDate.setValue(String.valueOf(String.format("%tF %<tR", range.getStartDate().getTime())) + "/" + String.format("%tF %<tR", range.getEndDate().getTime()));
                xmlDate.setDateType(DateType.Created);
                this.addDate(xmlDate);
                continue;
            }
            if (!(timePoint instanceof EdalDate)) continue;
            XmlDate xmlDate = new XmlDate();
            xmlDate.setValue(String.format("%tF %<tR", timePoint.getStartDate().getTime()));
            xmlDate.setDateType(DateType.Created);
            this.addDate(xmlDate);
        }
    }

    public void addDate(XmlDate date) throws IndexOutOfBoundsException {
        this.dateList.add(date);
    }

    public void addDate(int index, XmlDate date) throws IndexOutOfBoundsException {
        this.dateList.add(index, date);
    }

    public Iterator<? extends XmlDate> enumerateDate() {
        return this.dateList.iterator();
    }

    public XmlDate getDate(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.dateList.size()) {
            throw new IndexOutOfBoundsException("getDate: Index value '" + index + "' not in range [0.." + (this.dateList.size() - 1) + "]");
        }
        return this.dateList.get(index);
    }

    public XmlDate[] getDate() {
        XmlDate[] array = new XmlDate[]{};
        return this.dateList.toArray(array);
    }

    public int getDateCount() {
        return this.dateList.size();
    }

    public void removeAllDate() {
        this.dateList.clear();
    }

    public boolean removeDate(XmlDate date) {
        return this.dateList.remove(date);
    }

    public XmlDate removeDateAt(int index) {
        return this.dateList.remove(index);
    }

    public void setDate(int index, XmlDate date) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.dateList.size()) {
            throw new IndexOutOfBoundsException("setDate: Index value '" + index + "' not in range [0.." + (this.dateList.size() - 1) + "]");
        }
        this.dateList.set(index, date);
    }

    public void setDate(XmlDate[] dateArray) {
        this.dateList.clear();
        int i = 0;
        while (i < dateArray.length) {
            this.dateList.add(dateArray[i]);
            ++i;
        }
    }
}

