/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.sample.login.GoogleCallBackHandler;
import de.ipk_gatersleben.bit.bi.edal.sample.login.LoginCallbackHandler;
import de.ipk_gatersleben.bit.bi.edal.sample.login.UserCallBackHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SystemUtils;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import sun.security.krb5.KrbException;

public class EdalHelpers {
    public static Subject authenticateGoogleUser(String user) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubject("LoginModules.properties", "Google", new GoogleCallBackHandler(user));
    }

    public static Subject authenticateIPKKerberosUser(String user) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithKerberos("KerberosServer.properties", user);
    }

    public static Subject authenticateUser(String name, String password) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubject("LoginModules.properties", "User", new UserCallBackHandler(name, password));
    }

    public static Subject authenticateSampleUser() throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubject("LoginModules.properties", "Sample", null);
    }

    private static Subject authenticateSubject(String loginModulePropertyFile, String loginModule, CallbackHandler callbackhandler) throws EdalAuthenticateException {
        try {
            String config = EdalHelpers.class.getResource(loginModulePropertyFile).toString();
            System.setProperty("java.security.auth.login.config", config);
        }
        catch (Exception e) {
            throw new EdalAuthenticateException("can't load LoginModule property file", e);
        }
        LoginContext ctx = null;
        try {
            ctx = callbackhandler == null ? new LoginContext(loginModule) : new LoginContext(loginModule, callbackhandler);
            ctx.login();
        }
        catch (LoginException e) {
            throw new EdalAuthenticateException("can't login using LoginModule", e);
        }
        return ctx.getSubject();
    }

    private static Subject authenticateSubjectWithKerberos(String kerberosPropertyFile, String user) throws EdalAuthenticateException {
        try {
            String loginConfig = EdalHelpers.class.getResource("LoginModules.properties").toString();
            Properties properties = new Properties();
            try {
                Throwable throwable = null;
                Object var5_10 = null;
                try (InputStream is = EdalHelpers.class.getResourceAsStream(kerberosPropertyFile);){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new EdalAuthenticateException("unable to load Kerberos server properties", e);
            }
            if (!properties.containsKey("realm")) {
                throw new EdalAuthenticateException("no 'realm' paramter set");
            }
            if (!properties.containsKey("kdc")) {
                throw new EdalAuthenticateException("no 'kdc' paramter set");
            }
            System.setProperty("java.security.auth.login.config", loginConfig);
            System.setProperty("java.security.krb5.realm", properties.getProperty("realm"));
            System.setProperty("java.security.krb5.kdc", properties.getProperty("kdc"));
        }
        catch (Exception e) {
            throw new EdalAuthenticateException("can't load LoginModule property file ", e);
        }
        LoginContext ctx = null;
        boolean retry = true;
        while (retry) {
            try {
                ctx = new LoginContext("Kerberos", new LoginCallbackHandler(user));
                ctx.login();
                retry = false;
                return ctx.getSubject();
            }
            catch (LoginException e) {
                if (e.getCause() == null) {
                    return null;
                }
                if (!e.getCause().getClass().equals(KrbException.class)) continue;
                int result = JOptionPane.showConfirmDialog(null, "Your login attempt was not successful, try again. \nReason: Bad credentials.", "Login to IPK-Domain (LDAP)", 0);
                if (result == 0) {
                    retry = true;
                    continue;
                }
                if (result != 1) continue;
                return null;
            }
        }
        return null;
    }

    public static Subject authenticateWinOrUnixUser() throws EdalAuthenticateException {
        if (SystemUtils.IS_OS_UNIX) {
            return EdalHelpers.authenticateSubject("LoginModules.properties", "Unix", null);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return EdalHelpers.authenticateSubject("LoginModules.properties", "Windows", null);
        }
        throw new EdalAuthenticateException("You not using a Windows or Unix OS !");
    }

    public static void cleanMountPath(Path path) throws EdalException {
        try {
            EdalHelpers.deleteDir(path);
        }
        catch (EdalException e) {
            throw new EdalException("Can not clean mount path: " + e.getMessage());
        }
    }

    private static void deleteDir(Path directory) throws EdalException {
        if (Files.exists(directory, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                        if (exception == null) {
                            while (dir.toFile().delete()) {
                                1 var3_3 = this;
                                synchronized (var3_3) {
                                    try {
                                        this.wait(10L);
                                    }
                                    catch (InterruptedException e) {
                                        throw new IOException("could not wait to delete file: " + e.getMessage(), e);
                                    }
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        throw exception;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        while (file.toFile().delete()) {
                            1 var3_3 = this;
                            synchronized (var3_3) {
                                try {
                                    this.wait(10L);
                                }
                                catch (InterruptedException e) {
                                    throw new IOException("could not wait to delete file: " + e.getMessage(), e);
                                }
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new EdalException("could not delete file: " + e.getMessage());
            }
        }
    }

    public static ImplementationProvider getFileSystemImplementationProvider(boolean cleanMountPathBefore, EdalConfiguration config) throws EdalException {
        if (cleanMountPathBefore) {
            try {
                EdalHelpers.cleanMountPath(config.getMountPath());
                EdalHelpers.cleanMountPath(config.getDataPath());
            }
            catch (EdalException e) {
                throw new EdalException("Can not clean mount path before starting eDAL: " + e.getMessage(), e);
            }
        }
        if (Files.notExists(config.getMountPath(), LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(config.getMountPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new EdalException("Can not create mount path before starting eDAL: " + e.getMessage(), e);
            }
        }
        if (Files.notExists(config.getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(config.getDataPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new EdalException("Can not create data path before start eDAL: " + e.getMessage(), e);
            }
        }
        FileSystemImplementationProvider mountPoint = new FileSystemImplementationProvider(config);
        return mountPoint;
    }

    public static void getSearchStatistic(Statistics statistics) {
        try {
            if (!statistics.isStatisticsEnabled()) {
                System.out.println("WARN: statistics disabled");
            }
            System.out.println("\n******** Search-Statistic ********");
            SecondLevelCacheStatistics metaDataStatistics = null;
            try {
                metaDataStatistics = statistics.getSecondLevelCacheStatistics("search.metadata");
                long metaDataHit = metaDataStatistics.getHitCount();
                long metaDataMiss = metaDataStatistics.getMissCount();
                double metaDataRatio = (double)metaDataHit / (double)(metaDataHit + metaDataMiss);
                System.out.println("\nsearch.metadata-Cache:");
                System.out.println("Hit-Ratio : " + metaDataRatio);
                System.out.println("Hits : " + metaDataHit);
                System.out.println("Miss : " + metaDataMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.metadata-Cache");
            }
            SecondLevelCacheStatistics versionStatistics = null;
            try {
                versionStatistics = statistics.getSecondLevelCacheStatistics("search.version");
                long versionHit = versionStatistics.getHitCount();
                long versionMiss = versionStatistics.getMissCount();
                double versionRatio = (double)versionHit / (double)(versionHit + versionMiss);
                System.out.println("\nsearch.version-Cache:");
                System.out.println("Hit-Ratio : " + versionRatio);
                System.out.println("Hits : " + versionHit);
                System.out.println("Miss : " + versionMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.version-Cache");
            }
            SecondLevelCacheStatistics entityStatistics = null;
            try {
                entityStatistics = statistics.getSecondLevelCacheStatistics("search.entity");
                long entityHit = entityStatistics.getHitCount();
                long entityMiss = entityStatistics.getMissCount();
                double entityRatio = (double)entityHit / (double)(entityHit + entityMiss);
                System.out.println("\nsearch.entity-Cache:");
                System.out.println("Hit-Ratio : " + entityRatio);
                System.out.println("Hits : " + entityHit);
                System.out.println("Miss : " + entityMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.entity-Cache");
            }
            System.out.println("\n**********************************\n");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("couldnt found statistic");
        }
    }

    public static void getStatistic(Statistics statistics) {
        try {
            if (!statistics.isStatisticsEnabled()) {
                System.out.println("WARN: statistics disabled");
            }
            System.out.println("\n******** Permission-Statistic ********");
            SecondLevelCacheStatistics rootStatistics = null;
            try {
                rootStatistics = statistics.getSecondLevelCacheStatistics("query.root");
                long rootHit = rootStatistics.getHitCount();
                long rootMiss = rootStatistics.getMissCount();
                double rootRatio = (double)rootHit / (double)(rootHit + rootMiss);
                System.out.println("\nquery.root-Cache:");
                System.out.println("Hit-Ratio : " + rootRatio);
                System.out.println("Hits : " + rootHit);
                System.out.println("Miss : " + rootMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use query.root-Cache");
            }
            SecondLevelCacheStatistics permissionStatistics = null;
            try {
                permissionStatistics = statistics.getSecondLevelCacheStatistics("query.permission");
                long permissionHit = permissionStatistics.getHitCount();
                long permissionMiss = permissionStatistics.getMissCount();
                double permissionRatio = (double)permissionHit / (double)(permissionHit + permissionMiss);
                System.out.println("\nquery.permission-Cache:");
                System.out.println("Hit-Ratio : " + permissionRatio);
                System.out.println("Hits : " + permissionHit);
                System.out.println("Miss : " + permissionMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use query.permission-Cache");
            }
            SecondLevelCacheStatistics principalStatistics = null;
            try {
                principalStatistics = statistics.getSecondLevelCacheStatistics("query.principal");
                long principalHit = principalStatistics.getHitCount();
                long principalMiss = principalStatistics.getMissCount();
                double principalRatio = (double)principalHit / (double)(principalHit + principalMiss);
                System.out.println("\nquery.principal-Cache:");
                System.out.println("Hit-Ratio : " + principalRatio);
                System.out.println("Hits : " + principalHit);
                System.out.println("Miss : " + principalMiss);
                System.out.println("\n**************************************");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use query.principal-Cache");
            }
            SecondLevelCacheStatistics listStatistics = null;
            try {
                listStatistics = statistics.getSecondLevelCacheStatistics("query.list");
                long listHit = listStatistics.getHitCount();
                long listMiss = listStatistics.getMissCount();
                double listRatio = (double)listHit / (double)(listHit + listMiss);
                System.out.println("\nquery.list-Cache:");
                System.out.println("Hit-Ratio : " + listRatio);
                System.out.println("Hits : " + listHit);
                System.out.println("Miss : " + listMiss);
                System.out.println("\n**************************************");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use query.list-Cache");
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("couldnt found statistic");
        }
    }
}

