/*
 * Copyright (c) 2014 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.swing.JOptionPane;

import org.apache.commons.lang.SystemUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;

public class GoogleOauth {
	private static String openidurl = "https://accounts.google.com/o/oauth2/";
	private static String clientid = "185350669209-g332o78obs1033ep4kk4ke2mf2833455.apps.googleusercontent.com";
	private static String clientsecret = "6s2W5F2XfZU97TL0DTWPG7T1";
	private static String callbackurl = "urn:ietf:wg:oauth:2.0:oob";
	private static String code = null;
	private static String openidusername = "Email";
	private static String openidpassword = "Passwd";
	private static String openidloginbutton = "signIn";
	private static String openidcode = "code";
	private static final String SUBMIT_APPROVE_ACCESS = "submit_approve_access";
	private static final String SMS_USER_PIN = "smsUserPin";
	private static final String SMS_VERIFY_PIN = "smsVerifyPin";

	/**
	 * Get back if the user is already logged by checking if a cookie exists.
	 * 
	 * @param username
	 * @return true if the user is logged, otherwise false
	 */
	public static boolean isLogged(String username) {
		try {
			Set<Cookie> cookieset = getcookies(username);
			if (cookieset.size() > 0) {
				return true;
			}
		} catch (Exception e) {
			DataManager.getImplProv().getLogger().error(e);
		}
		return false;
	}

	public static GooglePrincipal authenticateGoogleUser(String emailaddress, String userpassword, boolean keepLogin, String proxy) throws Exception {
		String access_token = null;
		WebClient webClient;

		if (proxy != null && proxy.indexOf(":") > 0) {
			String proxyHost = proxy.substring(0, proxy.indexOf(":"));
			String proxyPort = proxy.substring(proxy.indexOf(":") + 1);

			webClient = new WebClient(BrowserVersion.FIREFOX_24, proxyHost, Integer.valueOf(proxyPort));
		} else {
			webClient = new WebClient(BrowserVersion.FIREFOX_24);
		}

		webClient.getOptions().setJavaScriptEnabled(true);
		webClient.getOptions().setCssEnabled(true);
		webClient.setAjaxController(new NicelyResynchronizingAjaxController());
		webClient.getOptions().setTimeout(5000);
		webClient.getOptions().setThrowExceptionOnScriptError(false);
		webClient.waitForBackgroundJavaScript(15000);

		try {
			if (keepLogin) {
				Set<Cookie> cookieset = getcookies(emailaddress);
				if (cookieset.size() == 0) {
					loginwithoutcookie(webClient, keepLogin, emailaddress, userpassword);
					access_token = getaccesstoken(webClient);
				} else {
					loginwithcookie(webClient, cookieset);
					access_token = getaccesstoken(webClient);
				}

			} else {
				deletecookie(emailaddress);
				loginwithoutcookie(webClient, keepLogin, emailaddress, userpassword);
				access_token = getaccesstoken(webClient);
			}
		}
		/*
		 * we have to handle 3 exceptions: java.net.UnknownHostException means
		 * httpproxy is not correct org.apache.http.conn.ConnectTimeoutException
		 * httpproxy port is not correct
		 * com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException google
		 * changed their service url
		 */
		catch (java.net.UnknownHostException e) {
			throw new EdalAuthenticateException("Please check your HTTP Proxy!");
		} catch (org.apache.http.conn.ConnectTimeoutException e) {
			throw new EdalAuthenticateException("Please check your HTTP Proxy Configuration!");
		} catch (com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException e) {
			throw new EdalAuthenticateException("the Google OAuth service has exception!");
		}

		JSONParser parser = new JSONParser();
		UnexpectedPage peoplePage = webClient.getPage("https://www.googleapis.com/plus/v1/people/me?access_token=" + access_token);
		Object obj = parser.parse(peoplePage.getWebResponse().getContentAsString());
		JSONObject jsonobj = (JSONObject) obj;
		/*
		 * String familyname = null; String givenName = null; String imageurl =
		 * null; if (jsonobj.get("name") != null) { familyname = ((JSONObject)
		 * (jsonobj.get("name"))).get("familyName").toString(); givenName =
		 * ((JSONObject) (jsonobj.get("name"))).get("givenName").toString(); }
		 * if (jsonobj.get("image") != null) { imageurl = ((JSONObject)
		 * (jsonobj.get("image"))).get("url").toString(); }
		 * 
		 * System.out.println(familyname); System.out.println(givenName);
		 * System.out.println(imageurl);
		 */
		if ("person".equals(jsonobj.get("objectType"))) {
			GooglePrincipal googlePrincipal = new GooglePrincipal(emailaddress);
			return googlePrincipal;
		} else {
			throw new EdalAuthenticateException("Please check your username and password!");
		}

	}

	private static void loginwithcookie(WebClient webClient, Set<Cookie> cookieset) throws Exception {
		try {
			for (Cookie cookie : cookieset) {
				webClient.getCookieManager().addCookie(cookie);
			}

			HtmlPage rootPage = webClient.getPage(openidurl + "auth?scope=email%20profile&redirect_uri=" + callbackurl + "&response_type=code&client_id=" + clientid);
			HtmlButton appbutton = rootPage.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
			Thread.sleep(2000);
			HtmlPage fpage = appbutton.click();
			HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
			code = codeinput.getValueAttribute();
		} catch (ElementNotFoundException e) {
			// ignore
		}
	}

	private static void loginwithoutcookie(WebClient webClient, boolean savecookie, String emailaddress, String userpassword) throws Exception {
		HtmlPage loginPage = webClient.getPage(openidurl + "auth?scope=email%20profile&redirect_uri=" + callbackurl + "&response_type=code&client_id=" + clientid);
		HtmlInput usernameintputBox = loginPage.getHtmlElementById(openidusername);
		usernameintputBox.setValueAttribute(emailaddress);

		HtmlInput passwordintputBox = loginPage.getHtmlElementById(openidpassword);
		passwordintputBox.setValueAttribute(userpassword);

		HtmlElement loginbutton = loginPage.getHtmlElementById(openidloginbutton);
		HtmlPage approvepage = loginbutton.click();

		try {
			if (approvepage.getHtmlElementById(openidloginbutton) != null) {
				// wrong username or password
				throw new EdalAuthenticateException("Please check your username and password!");
			}
		} catch (ElementNotFoundException e) {
			// ignore
		}

		try {
			if (approvepage.getHtmlElementById(SUBMIT_APPROVE_ACCESS) != null) {
				HtmlButton appbutton = approvepage.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
				Thread.sleep(2000);
				HtmlPage fpage = appbutton.click();
				HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
				code = codeinput.getValueAttribute();
			}
		} catch (ElementNotFoundException e) {
			// ignore
		}

		try {
			if (approvepage.getHtmlElementById(SMS_VERIFY_PIN) != null) {
				HtmlSubmitInput appbutton = approvepage.getHtmlElementById(SMS_VERIFY_PIN);
				HtmlInput pinbox = approvepage.getHtmlElementById(SMS_USER_PIN);

				String pincode = JOptionPane.showInputDialog("Please Enter your pincode: ");
				if (pincode == null) {
					System.exit(0);
				}

				pinbox.setValueAttribute(pincode);
				Thread.sleep(2000);
				HtmlPage page3 = appbutton.click();

				HtmlButton okbutton = page3.getHtmlElementById(SUBMIT_APPROVE_ACCESS);
				Thread.sleep(2000);
				HtmlPage fpage = okbutton.click();
				HtmlInput codeinput = fpage.getHtmlElementById(openidcode);
				code = codeinput.getValueAttribute();
			}
		} catch (ElementNotFoundException e) {
			// ignore
		}

		if (code != null && savecookie) {
			writecookies(webClient.getCookieManager().getCookies(), emailaddress);
		}

		if (code == null) {
			throw new EdalAuthenticateException("Please check your username and password!");
		}
	}

	private static String getaccesstoken(WebClient webClient) throws Exception {
		WebRequest requestSettings = new WebRequest(new URL(openidurl + "token"), HttpMethod.POST);
		requestSettings.setRequestParameters(getAssocQuery());

		Page page = webClient.getPage(requestSettings);

		String pageContent = page.getWebResponse().getContentAsString();
		JSONParser parser = new JSONParser();
		Object obj = parser.parse(pageContent);
		JSONObject jsonobj = (JSONObject) obj;
		String access_token = jsonobj.get("access_token").toString();

		return access_token;
	}

	private static List<NameValuePair> getAssocQuery() {
		List<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new NameValuePair("code", code));
		list.add(new NameValuePair("client_id", clientid));
		list.add(new NameValuePair("client_secret", clientsecret));
		list.add(new NameValuePair("redirect_uri", callbackurl));
		list.add(new NameValuePair("grant_type", "authorization_code"));
		return list;
	}

	private static void deletecookie(String emailaddress) throws Exception {
		File tempfile = new File(getFilepath(emailaddress));
		if (tempfile.exists()) {
			tempfile.delete();
		}
	}

	private static void writecookies(Set<Cookie> cookieset, String emailaddress) throws Exception {
		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(getFilepath(emailaddress)))));
		for (Cookie cookie : cookieset) {
			bw.write(cookie.getDomain() + " " + cookie.getName() + " " + cookie.getValue());
			bw.newLine();
		}
		bw.close();

		if (SystemUtils.IS_OS_WINDOWS) {

			Path path = Paths.get(getFilepath(emailaddress));

			Boolean hidden = (Boolean) Files.getAttribute(path, "dos:hidden", LinkOption.NOFOLLOW_LINKS);
			if (hidden != null && !hidden) {
				Files.setAttribute(path, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
			}
		}
	}

	private static Set<Cookie> getcookies(String emailaddress) throws Exception {
		Set<Cookie> cookies = new HashSet<Cookie>();
		File tempfile = new File(getFilepath(emailaddress));
		if (tempfile.exists()) {
			BufferedReader br = null;
			Reader fr = null;
			fr = new FileReader(getFilepath(emailaddress));
			br = new BufferedReader(fr);
			while (br.ready()) {
				String line = br.readLine();
				String[] arr = line.split("\\s+");
				if (arr.length == 3) {
					cookies.add(new Cookie(arr[0], arr[1], arr[2]));
				}
			}
			br.close();
			fr.close();
		}
		return cookies;
	}

	private static String getFilepath(String emailaddress) {
		return System.getProperty("user.home") + File.separator + "." + emailaddress + "_google_cookie.txt";
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		System.out.println(EdalHelpers.authenticateGoogleUser("gaterslebenchen@gmail.com", "proxy1.ipk-gatersleben.de", 3128));
	}
}
