/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.PipedThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.VeloCityHtmlGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.WebPageCache;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ZipThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class EdalJettyHandler
extends AbstractHandler {
    private static HashMap<Integer, List<String>> hashmap = new HashMap();
    private static ExecutorService executor;
    private static EdalThreadPoolExcecutor zipExecutor;
    private static final int CorePoolSizeForZipExecutor;
    private static final int MaximumPoolSizeForZipExecutor;
    private static WebPageCache cache;
    private static /* synthetic */ int[] $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions;

    static {
        CorePoolSizeForZipExecutor = Runtime.getRuntime().availableProcessors();
        MaximumPoolSizeForZipExecutor = 2 * Runtime.getRuntime().availableProcessors();
        cache = new WebPageCache();
        executor = DataManager.getJettyThreadPool();
        zipExecutor = new EdalThreadPoolExcecutor(CorePoolSizeForZipExecutor, MaximumPoolSizeForZipExecutor, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
        cache.init();
    }

    /*
     * Unable to fully structure code
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block52: {
            block53: {
                if (!request.getMethod().equalsIgnoreCase("GET")) break block52;
                url = request.getRequestURI().toString();
                DataManager.getImplProv().getLogger().debug((Object)url);
                tokenizer = new StringTokenizer(url, "/");
                if (tokenizer.hasMoreTokens()) break block53;
                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no ID and version specified");
                break block52;
            }
            methodToken = tokenizer.nextToken().toUpperCase();
            try {
                switch (EdalJettyHandler.$SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions()[EdalHttpFunctions.valueOf(methodToken).ordinal()]) {
                    case 7: 
                    case 8: {
                        if (tokenizer.hasMoreTokens()) {
                            internalId = tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                uuidToken = tokenizer.nextToken();
                                if (tokenizer.hasMoreTokens()) {
                                    versionToken = tokenizer.nextToken();
                                    try {
                                        versionNumber = Long.parseLong(versionToken);
                                        entity = null;
                                        if (tokenizer.hasMoreTokens()) {
                                            reviewerToken = tokenizer.nextToken();
                                            if (tokenizer.hasMoreElements()) {
                                                methodTokenForReviewer = tokenizer.nextToken();
                                                if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                    this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                    break;
                                                }
                                                if (methodTokenForReviewer.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                    this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, reviewerToken);
                                                    break;
                                                }
                                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process '" + methodTokenForReviewer + "'");
                                                break;
                                            }
                                            if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.DOWNLOAD.name())) {
                                                this.responseDownloadRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                break;
                                            }
                                            if (reviewerToken.equalsIgnoreCase(EdalHttpFunctions.ZIP.name())) {
                                                this.responseZipRequest(response, entity, uuidToken, versionNumber, internalId, methodToken, null);
                                                break;
                                            }
                                            reviewer = 0;
                                            try {
                                                reviewer = Integer.parseInt(reviewerToken);
                                            }
                                            catch (NumberFormatException v0) {
                                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "unable to process reviewer ID '" + reviewerToken + "', please check again");
                                                break;
                                            }
                                            entity = DataManager.getPrimaryDataEntityForReviewer(uuidToken, versionNumber, internalId, reviewer);
                                            this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(methodToken), reviewer);
                                            break;
                                        }
                                        entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuidToken, versionNumber, PersistentIdentifier.valueOf(methodToken));
                                        this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(methodToken), internalId);
                                    }
                                    catch (EdalException e) {
                                        this.sendMessage(response, HttpStatus.Code.LOCKED, e.getMessage());
                                    }
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no version number set");
                                break;
                            }
                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no entity id set");
                            break;
                        }
                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "no internal id set");
                        break;
                    }
                    case 5: {
                        uuidToken = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            versionToken = tokenizer.nextToken();
                            try {
                                versionNumber = Integer.parseInt(versionToken);
                                entity = null;
                                if (tokenizer.hasMoreElements()) {
                                    downloadToken = tokenizer.nextToken();
                                    if (EdalHttpFunctions.valueOf(downloadToken.toUpperCase()).equals((Object)EdalHttpFunctions.DOWNLOAD)) {
                                        entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                        if (!entity.isDirectory()) {
                                            this.sendFile((PrimaryDataFile)entity, versionNumber, response);
                                            break;
                                        }
                                        this.sendEntityMetaData(response, entity);
                                    }
                                    break;
                                }
                                entity = DataManager.getPrimaryDataEntityByID(uuidToken, versionNumber);
                                this.sendEntityMetaData(response, entity);
                            }
                            catch (EdalException | NumberFormatException e) {
                                if (e.getClass().equals(NumberFormatException.class)) {
                                    this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to cast '" + versionToken + "' to a version number");
                                    break;
                                }
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to send data : " + e.getMessage());
                            }
                            break;
                        }
                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no version number set");
                        break;
                    }
                    case 1: {
                        ticketAccept = tokenizer.nextToken();
                        if (!tokenizer.hasMoreElements()) ** GOTO lbl104
                        try {
                            reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                            if (!this.checkIfAllowedToClick(reviewerHashCode, ticketAccept)) ** GOTO lbl98
                            DataManager.getImplProv().getApprovalServiceProvider().newInstance().accept(ticketAccept, reviewerHashCode);
                            ** GOTO lbl106
lbl98:
                            // 1 sources

                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                        }
                        catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                            EdalJettyHandler.deleteTicketFromHashMap(ticketAccept);
                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Can not to accept ticket it seems to be already accepted/rejected: " + e.getMessage());
                        }
                        break;
lbl104:
                        // 1 sources

                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                        break;
lbl106:
                        // 1 sources

                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                        break;
                    }
                    case 2: {
                        ticketReject = tokenizer.nextToken();
                        if (!tokenizer.hasMoreElements()) ** GOTO lbl122
                        try {
                            reviewerHashCode = Integer.parseInt(tokenizer.nextToken());
                            if (!this.checkIfAllowedToClick(reviewerHashCode, ticketReject)) ** GOTO lbl116
                            DataManager.getImplProv().getApprovalServiceProvider().newInstance().reject(ticketReject, reviewerHashCode);
                            ** GOTO lbl124
lbl116:
                            // 1 sources

                            this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "Already clicked");
                        }
                        catch (EdalApprovalException | IllegalAccessException | InstantiationException | NumberFormatException e) {
                            EdalJettyHandler.deleteTicketFromHashMap(ticketReject);
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "Can not to reject ticket  it seems to be already accepted/rejected: " + e.getMessage());
                        }
                        break;
lbl122:
                        // 1 sources

                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "No ReviewerCode definded");
                        break;
lbl124:
                        // 1 sources

                        this.sendMessage(response, HttpStatus.Code.OK, "Thank you");
                        break;
                    }
                    case 6: {
                        uuid = tokenizer.nextToken();
                        emailAddress = tokenizer.nextToken();
                        successful = false;
                        try {
                            successful = DataManager.getImplProv().getPermissionProvider().newInstance().validateRootUser(new InternetAddress(emailAddress), UUID.fromString(uuid));
                        }
                        catch (IllegalAccessException | InstantiationException | AddressException v1) {
                            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "eDAL-Server Admin confirmation failed");
                        }
                        if (successful.booleanValue()) {
                            try {
                                this.sendMessage(response, HttpStatus.Code.OK, "Thank you <br/>You have successfully registered as administrator for eDAL-Server on " + EdalJettyServer.getServerURL() + "<br/>The server is now started in working mode.");
                            }
                            catch (EdalException v2) {
                                this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "unable to load server URL");
                            }
                            break;
                        }
                        this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "root user validation failed");
                        break;
                    }
                    case 9: {
                        if (tokenizer.hasMoreTokens() && (logoUrl = tokenizer.nextToken()).equalsIgnoreCase("edal_scaled.png")) {
                            this.sendEmbeddedFile(response, "edal_scaled.png", "image/png");
                        }
                        break;
                    }
                    default: {
                        this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "path has to start with '" + (Object)EdalHttpFunctions.ACCEPT + "'" + " or '" + (Object)EdalHttpFunctions.REJECT + "'" + " or '" + (Object)EdalHttpFunctions.REVIEW + "'");
                        break;
                    }
                    case 11: {
                        if (tokenizer.hasMoreTokens()) {
                            fileUrl = tokenizer.nextToken();
                            this.sendEmbeddedFile(response, "css/" + fileUrl, "text/css");
                        }
                        break;
                    }
                    case 12: {
                        if (tokenizer.hasMoreTokens()) {
                            fileUrl = tokenizer.nextToken();
                            this.sendEmbeddedFile(response, "js/" + fileUrl, "application/javascript");
                        }
                        break;
                    }
                    case 13: {
                        if (tokenizer.hasMoreTokens()) {
                            fileUrl = tokenizer.nextToken();
                            if (fileUrl.contains("svg")) {
                                this.sendEmbeddedFile(response, "fonts/" + fileUrl, "image/svg+xml");
                            }
                            if (fileUrl.contains("eot")) {
                                this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/vnd.ms-fontobject");
                            }
                            if (fileUrl.contains("woff")) {
                                this.sendEmbeddedFile(response, "fonts/" + fileUrl, "application/font-woff");
                            }
                            if (fileUrl.contains("ttf")) {
                                this.sendEmbeddedFile(response, "fonts/" + fileUrl, "font/ttf");
                            }
                        }
                        break;
                    }
                    case 14: {
                        if (tokenizer.hasMoreTokens()) {
                            fileUrl = tokenizer.nextToken();
                            this.sendEmbeddedFile(response, "fileicons/" + fileUrl, "image/png");
                        }
                        break;
                    }
                }
            }
            catch (IllegalArgumentException v3) {
                this.sendMessage(response, HttpStatus.Code.FORBIDDEN, "path has to start with '" + (Object)EdalHttpFunctions.ACCEPT + "'" + " or '" + (Object)EdalHttpFunctions.REJECT + "'" + " or '" + (Object)EdalHttpFunctions.REVIEW + "'");
            }
        }
        response.flushBuffer();
    }

    private boolean checkIfAllowedToClick(int reviewerHashCode, String ticketAccept) {
        List<String> list = hashmap.get(reviewerHashCode);
        if (list != null) {
            return !list.contains(ticketAccept);
        }
        ArrayList<String> newlist = new ArrayList<String>();
        newlist.add(ticketAccept);
        hashmap.put(reviewerHashCode, newlist);
        return true;
    }

    private void responseDownloadRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, Long versionNumber, String internalId, String identifierType, String reviewerCode) throws EdalException {
        if (reviewerCode == null) {
            entity = DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForPersistentIdentifier(response, entity, versionNumber, PersistentIdentifier.valueOf(identifierType), internalId);
            }
        } else {
            entity = DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerCode));
            if (!entity.isDirectory()) {
                this.sendFile((PrimaryDataFile)entity, versionNumber, response);
            } else {
                this.sendEntityMetaDataForReviewer(response, entity, versionNumber, internalId, PersistentIdentifier.valueOf(identifierType), Integer.parseInt(reviewerCode));
            }
        }
    }

    private void responseZipRequest(HttpServletResponse response, PrimaryDataEntity entity, String uuid, long versionNumber, String internalId, String identifierType, String reviewerId) throws EdalException {
        if (!zipExecutor.isShutdown() && zipExecutor.getActiveCount() >= CorePoolSizeForZipExecutor) {
            this.sendMessage(response, HttpStatus.Code.INSUFFICIENT_STORAGE, "No more free slots for downloading zip archive, please try again later");
        } else {
            entity = reviewerId == null ? DataManager.getPrimaryDataEntityForPersistenIdentifier(uuid, versionNumber, PersistentIdentifier.valueOf(identifierType)) : DataManager.getPrimaryDataEntityForReviewer(uuid, versionNumber, internalId, Integer.parseInt(reviewerId));
            if (entity.isDirectory()) {
                try {
                    response.setHeader("Content-Disposition", "inline; filename=\"" + entity.getName() + ".zip" + "\"");
                    response.setStatus(HttpStatus.Code.OK.getCode());
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    ServletOutputStream responseBody = response.getOutputStream();
                    ZipOutputStream zout = new ZipOutputStream((OutputStream)responseBody);
                    ZipThread zipThread = new ZipThread(countDownLatch, zout, (PrimaryDataDirectory)entity);
                    if (zipExecutor.isShutdown()) {
                        zipExecutor = new EdalThreadPoolExcecutor(CorePoolSizeForZipExecutor, MaximumPoolSizeForZipExecutor, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
                    }
                    zipExecutor.execute(zipThread);
                    try {
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException e) {
                            throw new EdalException("unable to send zip file '" + entity.getName() + ".zip'", e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            zout.close();
                        }
                        catch (EofException eofException) {
                            DataManager.getImplProv().getLogger().warn((Object)("HTTP Zip Response for '" + entity.getName() + ".zip' canceled by user"));
                            zipThread.stopListThread();
                        }
                        responseBody.close();
                        throw throwable;
                    }
                    try {
                        zout.close();
                    }
                    catch (EofException eofException) {
                        DataManager.getImplProv().getLogger().warn((Object)("HTTP Zip Response for '" + entity.getName() + ".zip' canceled by user"));
                        zipThread.stopListThread();
                    }
                    responseBody.close();
                }
                catch (IOException e) {
                    throw new EdalException("unable to send zip file '" + entity.getName() + ".zip'", e);
                }
            }
        }
    }

    private void sendEmbeddedFile(HttpServletResponse response, String fileName, String contentType) {
        try {
            int length;
            InputStream file = EdalJettyHandler.class.getResourceAsStream(fileName);
            int fileSize = file.available();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setContentLength(fileSize);
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)fileSize);
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = file.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            pipedOut.flush();
            try {
                countDownLatch.await();
                file.close();
                pipedOut.close();
                httpIn.close();
            }
            catch (InterruptedException e) {
                DataManager.getImplProv().getLogger().error((Object)("unable to wait for sending file : " + e.getMessage()));
            }
            responseBody.close();
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send file : " + e.getMessage()));
        }
    }

    private void sendEntityMetaData(HttpServletResponse response, PrimaryDataEntity entity) throws EdalException {
        try {
            int length;
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            StringWriter w = null;
            w = entity.isDirectory() ? velo.generateHtmlForDirectory((PrimaryDataDirectory)entity) : velo.generateHtmlForFile((PrimaryDataFile)entity);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(w.getBuffer()).getBytes());
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            ServletOutputStream responseBody = response.getOutputStream();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)bis.available());
            executor.execute(pipedThread);
            byte[] buffer = new byte[0x100000];
            while ((length = bis.read(buffer)) != -1) {
                pipedOut.write(buffer, 0, length);
            }
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send html page", e);
                }
            }
            finally {
                try {
                    bis.close();
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close html streams : " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new EdalException("unable to send the html page over HTTP", e);
        }
        catch (EdalException e) {
            throw e;
        }
    }

    private void sendEntityMetaDataForPersistentIdentifier(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, PersistentIdentifier identifierType, String internalId) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, 0);
        if (cache.get(cacheKey) == null) {
            DataManager.getImplProv().getLogger().debug((Object)("Regenerate Webpage : " + cacheKey));
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                VeloCityHtmlGenerator velocityGenerator = new VeloCityHtmlGenerator();
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? (OutputStreamWriter)velocityGenerator.generateHtmlForDirectoryOfSnapshot((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, teeOutputStream, latch) : (OutputStreamWriter)velocityGenerator.generateHtmlForFileOfSnapshot((PrimaryDataFile)entity, versionNumber, identifierType, internalId, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                    cache.put(cacheKey, cacheFileOutputStream);
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
        } else {
            DataManager.getImplProv().getLogger().debug((Object)("Reload Webpage from Cache : " + cacheKey));
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = cache.get(cacheKey);
                cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                cacheFileInputStream.close();
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendEntityMetaDataForReviewer(HttpServletResponse response, PrimaryDataEntity entity, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode) throws EdalException {
        String cacheKey = this.generateCacheKey(identifierType, internalId, entity, versionNumber, reviewerCode);
        if (cache.get(cacheKey) == null) {
            DataManager.getImplProv().getLogger().debug((Object)("Regenerate Webpage : " + cacheKey));
            try {
                ByteArrayOutputStream cacheFileOutputStream = new ByteArrayOutputStream();
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)response.getOutputStream(), (OutputStream)cacheFileOutputStream);
                CountDownLatch latch = new CountDownLatch(1);
                VeloCityHtmlGenerator velocityGenerator = new VeloCityHtmlGenerator();
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = entity.isDirectory() ? (OutputStreamWriter)velocityGenerator.generateHtmlForDirectoryForReviewer((PrimaryDataDirectory)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch) : (OutputStreamWriter)velocityGenerator.generateHtmlForFileForReviewer((PrimaryDataFile)entity, versionNumber, internalId, identifierType, reviewerCode, teeOutputStream, latch);
                response.setContentType("text/html");
                response.setStatus(HttpStatus.Code.OK.getCode());
                try {
                    latch.await();
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (EofException eofException) {
                    DataManager.getImplProv().getLogger().warn((Object)"HTTP Response canceled by user");
                    outputStreamWriter.close();
                    teeOutputStream.flush();
                    teeOutputStream.close();
                }
                catch (InterruptedException e) {
                    throw new EdalException(e);
                }
            }
            catch (IOException e) {
                throw new EdalException(e);
            }
        } else {
            DataManager.getImplProv().getLogger().debug((Object)("Reload Webpage from Cache : " + cacheKey));
            response.setContentType("text/html");
            response.setStatus(HttpStatus.Code.OK.getCode());
            try {
                ByteArrayOutputStream cacheFileInputStream = cache.get(cacheKey);
                cacheFileInputStream.writeTo((OutputStream)response.getOutputStream());
                cacheFileInputStream.close();
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final String generateCacheKey(PersistentIdentifier identifierType, String internalId, PrimaryDataEntity entity, long versionNumber, int reviewerCode) {
        return new String(String.valueOf(identifierType.toString()) + internalId + entity.getID() + String.valueOf(versionNumber) + String.valueOf(reviewerCode));
    }

    private void sendFile(PrimaryDataFile file, long versionNumber, HttpServletResponse response) throws EdalException {
        PrimaryDataFile currentFile = file;
        try {
            currentFile.switchCurrentVersion(currentFile.getVersionByRevisionNumber(versionNumber));
        }
        catch (PrimaryDataEntityVersionException primaryDataEntityVersionException) {
            this.sendMessage(response, HttpStatus.Code.NOT_FOUND, "no file found");
        }
        try {
            String type = "";
            Long size = null;
            try {
                type = ((DataFormat)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.FORMAT)).getMimeType();
                size = ((DataSize)currentFile.getCurrentVersion().getMetaData().getElementValue(EnumDublinCoreElements.SIZE)).getFileSize();
            }
            catch (MetaDataException e) {
                throw new EdalException("unable to load the MIME type/file size", e);
            }
            response.setContentType(type);
            response.setHeader("Content-Disposition", "inline; filename=\"" + currentFile.getName() + "\"");
            response.addHeader("Content-Length", size.toString());
            response.setStatus(HttpStatus.Code.OK.getCode());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServletOutputStream responseBody = response.getOutputStream();
            PipedInputStream httpIn = new PipedInputStream(0x100000);
            PipedOutputStream pipedOut = new PipedOutputStream(httpIn);
            PipedThread pipedThread = new PipedThread(httpIn, (OutputStream)responseBody, countDownLatch, (long)size);
            executor.execute(pipedThread);
            currentFile.read(pipedOut);
            try {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new EdalException("unable to send file", e);
                }
            }
            finally {
                try {
                    pipedOut.close();
                    httpIn.close();
                    responseBody.close();
                }
                catch (Exception e) {
                    DataManager.getImplProv().getLogger().error((Object)("unable to close download streams : " + e.getMessage()));
                }
            }
        }
        catch (PrimaryDataFileException | IOException e) {
            throw new EdalException("unable to send file", e);
        }
    }

    private void sendMessage(HttpServletResponse response, HttpStatus.Code responseCode, String message) {
        try {
            VeloCityHtmlGenerator velo = new VeloCityHtmlGenerator();
            String htmlOutput = velo.generateHtmlForErrorMessage(responseCode, message).toString();
            response.setStatus(responseCode.getCode());
            response.setContentType("text/html");
            ServletOutputStream responseBody = response.getOutputStream();
            responseBody.write(htmlOutput.getBytes());
            responseBody.close();
        }
        catch (EdalException | IOException e) {
            DataManager.getImplProv().getLogger().error((Object)("unable to send " + responseCode + "-message : " + e.getClass()));
        }
    }

    public static void deleteTicketFromHashMap(String ticket) {
        for (Map.Entry<Integer, List<String>> entry : hashmap.entrySet()) {
            List<String> list = entry.getValue();
            if (!list.contains(ticket)) continue;
            list.remove(ticket);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions() {
        if ($SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions != null) {
            return $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions;
        }
        int[] nArray = new int[EdalHttpFunctions.values().length];
        try {
            nArray[EdalHttpFunctions.ACCEPT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.CSS.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.DOI.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.DOWNLOAD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.EDAL.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.FILEICONS.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.FONTS.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.JS.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.LOGIN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.LOGO.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.REJECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.REVIEW.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.URL.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdalHttpFunctions.ZIP.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$EdalHttpFunctions = nArray;
        return nArray;
    }
}

