/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class EdalJettyServer {
    public static final String EDAL_PATH_SEPARATOR = "/";
    private static URL url = null;
    private boolean useSSL = false;
    private Server eDALServer = null;

    protected EdalJettyServer(EdalConfiguration configuration) {
        this.useSSL = configuration.isUseSSLForHttpListener();
        this.eDALServer = new Server((ThreadPool)new ExecutorThreadPool(DataManager.getJettyThreadPool()));
        HandlerCollection collection = new HandlerCollection();
        collection.addHandler((Handler)new EdalJettyHandler());
        if (this.useSSL) {
            SslContextFactory contextFactory = new SslContextFactory();
            KeyStore keystore = null;
            try {
                keystore = KeyStore.getInstance("JKS");
                keystore.load(new FileInputStream(configuration.getCertificatePathForHttpListener().getPath()), configuration.getKeystorePasswordForHttpListener().toCharArray());
            }
            catch (IOException | GeneralSecurityException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to load/open keystore : " + e.getMessage()));
            }
            contextFactory.setKeyStore(keystore);
            contextFactory.setKeyStorePassword(configuration.getKeystorePasswordForHttpListener());
            ServerConnector sslConnector = new ServerConnector(this.eDALServer, contextFactory);
            try {
                sslConnector.setPort(configuration.getHttpPort());
                this.eDALServer.setConnectors(new Connector[]{sslConnector});
                this.eDALServer.setHandler((Handler)collection);
                this.setURL(new URL("https://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + configuration.getHttpPort()));
            }
            catch (EdalConfigurationException | MalformedURLException | UnknownHostException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to initialize HTTPS-server : " + e.getMessage()));
            }
        } else {
            ServerConnector connector = new ServerConnector(this.eDALServer);
            try {
                connector.setPort(configuration.getHttpPort());
                this.eDALServer.setConnectors(new Connector[]{connector});
                this.eDALServer.setHandler((Handler)collection);
                this.setURL(new URL("http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + configuration.getHttpPort()));
            }
            catch (EdalConfigurationException | MalformedURLException | UnknownHostException e) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to initialize HTTP-server : " + e.getMessage()));
            }
        }
    }

    protected void start() {
        try {
            this.eDALServer.start();
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().info((Object)("HTTPS-Server is listening on : " + EdalJettyServer.getServerURL()));
            } else {
                DataManager.getImplProv().getLogger().info((Object)("HTTP-Server is listening on : " + EdalJettyServer.getServerURL()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to start HTTPS Server : " + e.getMessage()));
            } else {
                DataManager.getImplProv().getLogger().error((Object)("Unable to start HTTP Server : " + e.getMessage()));
            }
            System.exit(0);
        }
    }

    protected void stop() {
        try {
            this.eDALServer.stop();
        }
        catch (Exception e) {
            if (this.useSSL) {
                DataManager.getImplProv().getLogger().error((Object)("Unable to stop HTTPS-Server : " + e.getMessage()));
            }
            DataManager.getImplProv().getLogger().error((Object)("Unable to stop HTTP-Server : " + e.getMessage()));
        }
    }

    private void setURL(URL url) {
        EdalJettyServer.url = url;
    }

    public static URL getServerURL() throws EdalException {
        if (url != null) {
            return url;
        }
        throw new EdalException("no eDAL HTTP server started");
    }

    public static URL generateMethodURL(String ticket, int reviewerCode, EdalHttpFunctions method) throws EdalException {
        try {
            URI uri = new URI(EdalJettyServer.getServerURL().toString());
            URL methodURL = new URL(String.valueOf(uri.getScheme()) + "://" + uri.getHost() + ":" + uri.getPort() + EDAL_PATH_SEPARATOR + (Object)((Object)method) + EDAL_PATH_SEPARATOR + ticket + EDAL_PATH_SEPARATOR + reviewerCode);
            return methodURL;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new EdalException("unable to generate URL for " + (Object)((Object)method), e);
        }
    }

    public static URL generateReviewerURL(URL entityURL, int reviewersCode) throws EdalException {
        try {
            URL reviewerUrl = new URL(String.valueOf(entityURL.toString()) + EDAL_PATH_SEPARATOR + reviewersCode);
            return reviewerUrl;
        }
        catch (MalformedURLException e) {
            throw new EdalException("unable to generate ReviewerURL", e);
        }
    }
}

