/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.DoiImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewStatusImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.TicketImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.UrlImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.VeloCityGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewProcess;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewResult;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewStatus;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.exception.VelocityException;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ApprovalServiceProviderImplementation
implements ApprovalServiceProvider {
    private static final int REMAINDER_CYCLE = 172800000;
    private static Map<String, PublicReferenceImplementation> synchronizedMap = Collections.synchronizedMap(new HashMap());

    static {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        List ticketImplementation = session.createCriteria(TicketImplementation.class).list();
        for (TicketImplementation ticket : ticketImplementation) {
            synchronizedMap.put(ticket.getTicket(), ticket.getReference());
        }
        transaction.commit();
        session.close();
    }

    @Override
    public void accept(String ticket, int reviewerID) throws EdalApprovalException {
        this.changeReviewStatus(ticket, reviewerID, ReviewStatus.ReviewStatusType.ACCEPTED);
    }

    @Override
    public void approve(PublicReference reference, InternetAddress emailNotificationAddress) throws EdalApprovalException {
        if (reference instanceof PublicReferenceImplementation) {
            PublicReferenceImplementation internalRef = (PublicReferenceImplementation)reference;
            internalRef.setPublicationStatus(PublicationStatus.UNDER_REVIEW);
            ReviewResult result = ReviewProcess.review(new ArrayList<ReviewStatus>());
            HashSet<ReviewStatusImplementation> reviewSet = new HashSet<ReviewStatusImplementation>();
            if (result != null) {
                for (ReviewStatus status : result.getReviewerStatusList()) {
                    org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                    Transaction transaction = session.beginTransaction();
                    ReviewStatusImplementation reviewStatus = new ReviewStatusImplementation();
                    reviewStatus.setPublicReference(internalRef);
                    reviewStatus.setEmailAddress(status.getEmailAddress().getAddress());
                    reviewStatus.setRequestedDate(Calendar.getInstance());
                    reviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                    reviewStatus.setReviewerType(status.getReviewerType());
                    reviewSet.add(reviewStatus);
                    session.save((Object)reviewStatus);
                    transaction.commit();
                    session.close();
                }
            }
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            internalRef.setReviewStatusSet(reviewSet);
            session.saveOrUpdate((Object)internalRef);
            transaction.commit();
            session.close();
            String ticket = UUID.randomUUID().toString();
            this.storeTicket(ticket, reference, emailNotificationAddress);
            synchronizedMap.put(ticket, internalRef);
            try {
                for (ReviewStatus reviewStatus : result.getReviewerStatusList()) {
                    this.sendRequestApprovalMail(ticket, reference, reviewStatus.getEmailAddress(), reviewStatus.getReviewerType());
                }
                this.sendStatusMailToRequestedPerson(emailNotificationAddress, reference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to send requestApprovalEmails", e);
            }
        } else {
            throw new EdalApprovalException("reference object is no instanceof PublicReferenceImplementation");
        }
    }

    private void changeReviewStatus(String ticket, int reviewerCode, ReviewStatus.ReviewStatusType status) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        ReviewersImplementation reviewerImplementation = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)reviewerCode)).uniqueResult();
        if (reviewerImplementation == null) {
            throw new EdalApprovalException("unable to find a reviewer with this code");
        }
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        if (ticketImplementation == null) {
            throw new EdalApprovalException("unable to find a ticket with this code");
        }
        List reviewStatusList = session.createCriteria(ReviewStatusImplementation.class).add((Criterion)Restrictions.eq((String)"emailAddress", (Object)reviewerImplementation.getEmailAddress())).add((Criterion)Restrictions.eq((String)"publicReference", (Object)ticketImplementation.getReference())).list();
        for (ReviewStatusImplementation reviewStatusImplementation : reviewStatusList) {
            reviewStatusImplementation.setStatusType(status);
            session.saveOrUpdate((Object)reviewStatusImplementation);
        }
        session.getTransaction().commit();
        session.close();
    }

    @Override
    public void checkOpenReviewProcesses(Map<PublicReference, List<ReviewStatus>> results) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        for (Map.Entry<PublicReference, List<ReviewStatus>> result : results.entrySet()) {
            TicketImplementation ticket = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"reference", (Object)result.getKey())).uniqueResult();
            DataManager.getImplProv().getLogger().debug((Object)("CheckOpenReviewProcess for Ticket : \t" + ticket.getTicket()));
            try {
                this.updateReviewStatus(result.getKey(), ReviewProcess.review(result.getValue()));
            }
            catch (EdalApprovalException e) {
                throw new EdalApprovalException("unable to check open review processes: " + e.getMessage(), e.getCause());
            }
        }
        session.close();
    }

    private String createLandingPageString(PublicReference reference) {
        return "/" + reference.getIdentifierType().toString() + "/" + reference.getInternalID() + "/" + reference.getVersion().getEntity().getID() + "/" + reference.getVersion().getRevision();
    }

    private URL createLandingPageURL(PublicReferenceImplementation reference) throws EdalApprovalException {
        try {
            return new URL(EdalJettyServer.getServerURL(), this.createLandingPageString(reference));
        }
        catch (EdalException | MalformedURLException e) {
            throw new EdalApprovalException("unable to create URL for the landing page : " + e.getMessage(), e);
        }
    }

    private void deleteReviewStatus(PublicReferenceImplementation reference) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List reviewStatus = session.createCriteria(ReviewStatusImplementation.class).add((Criterion)Restrictions.eq((String)"publicReference", (Object)reference)).list();
        for (ReviewStatusImplementation reviewStatusImplementation : reviewStatus) {
            session.delete((Object)reviewStatusImplementation);
        }
        session.getTransaction().commit();
        session.close();
    }

    private void deleteTicket(String ticket) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        session.delete((Object)ticketImplementation);
        session.getTransaction().commit();
        session.close();
        EdalJettyHandler.deleteTicketFromHashMap(ticket);
    }

    @Override
    public Map<PublicReference, List<ReviewStatus>> getAllOpenReviewProcesses() {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        List publicReferences = session.createCriteria(PublicReferenceImplementation.class).add(Restrictions.isNull((String)"acceptedDate")).add(Restrictions.isNull((String)"rejectedDate")).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).list();
        DataManager.getImplProv().getLogger().debug((Object)("open PublicReferences : " + publicReferences.size()));
        session.close();
        HashMap<PublicReference, List<ReviewStatus>> openReviewProcesses = new HashMap<PublicReference, List<ReviewStatus>>(publicReferences.size());
        for (PublicReferenceImplementation publicReference : publicReferences) {
            Set<ReviewStatusImplementation> privateSet = publicReference.getReviewStatusSet();
            DataManager.getImplProv().getLogger().debug((Object)("open ReviewStatus : " + privateSet.size()));
            if (privateSet.isEmpty()) continue;
            ArrayList<ReviewStatus> publicSet = new ArrayList<ReviewStatus>(privateSet.size());
            for (ReviewStatusImplementation reviewStatusImplementation : privateSet) {
                publicSet.add(reviewStatusImplementation.toReviewStatus());
            }
            openReviewProcesses.put(publicReference, publicSet);
        }
        DataManager.getImplProv().getLogger().debug((Object)("open ReviewProcesses : " + openReviewProcesses.size()));
        return openReviewProcesses;
    }

    @Override
    public String getNewURL(PublicReference reference) throws EdalApprovalException {
        String url = "";
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        int year = Calendar.getInstance().get(1);
        int numberOfStoredIds = session.createCriteria(UrlImplementation.class).add((Criterion)Restrictions.eq((String)"year", (Object)year)).list().size();
        try {
            url = EdalJettyServer.getServerURL() + "/" + year + "/" + numberOfStoredIds + "/" + ((UntypedData)reference.getVersion().getMetaData().getElementValue(EnumDublinCoreElements.TITLE)).toString();
        }
        catch (EdalException | MetaDataException e) {
            e.printStackTrace();
        }
        PublicReferenceImplementation publicReferenceImplementation = (PublicReferenceImplementation)reference;
        publicReferenceImplementation.setVersion(reference.getVersion());
        publicReferenceImplementation.setAcceptedDate(Calendar.getInstance());
        publicReferenceImplementation.setAssignedID(url);
        publicReferenceImplementation.setPublicationStatus(PublicationStatus.ACCEPTED);
        publicReferenceImplementation.setPublic(true);
        publicReferenceImplementation.setIdentifierType(PersistentIdentifier.URL);
        UrlImplementation urlImplementation = new UrlImplementation();
        urlImplementation.setReference(publicReferenceImplementation);
        urlImplementation.setUrl(url);
        urlImplementation.setYear(year);
        session.update((Object)publicReferenceImplementation);
        session.save((Object)urlImplementation);
        transaction.commit();
        session.close();
        return url;
    }

    @Override
    public PublicReference getPublicReferenceByInternalId(String internalId) throws EdalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PublicReferenceImplementation publicReference = (PublicReferenceImplementation)session.createCriteria(PublicReferenceImplementation.class).add((Criterion)Restrictions.eq((String)"internalID", (Object)internalId)).uniqueResult();
        session.close();
        if (publicReference != null) {
            return publicReference;
        }
        throw new EdalException("no PublicReference with ID '" + internalId + "' found !");
    }

    @Override
    public void reject(String ticket, int reviewerID) throws EdalApprovalException {
        this.changeReviewStatus(ticket, reviewerID, ReviewStatus.ReviewStatusType.REJECTED);
    }

    private void sendAcceptedMail(String newId, String emailAddress, URL landingPage, PublicReference publicReference) throws EdalApprovalException {
        String message;
        VeloCityGenerator veloCityGenerator = new VeloCityGenerator();
        try {
            message = veloCityGenerator.generateAcceptedEmail(newId, landingPage, publicReference).toString();
        }
        catch (VelocityException e) {
            throw new EdalApprovalException("unable to generate e-mail", e);
        }
        this.sendEmail(message, "[eDAL - data publication accepted]", emailAddress);
    }

    private void sendEmail(String message, String subject, String emailAddress) {
        Session session = null;
        InternetAddress addressFrom = null;
        Properties properties = new Properties();
        properties.put("mail.smtp.host", DataManager.getConfiguration().getMailSmtpHost());
        if (DataManager.getConfiguration().getMailSmtpLogin() == null || DataManager.getConfiguration().getMailSmtpLogin().isEmpty()) {
            session = Session.getDefaultInstance((Properties)properties);
            try {
                addressFrom = new InternetAddress(DataManager.getConfiguration().getEdalEmailAddress(), "eDAL-Service <" + DataManager.getConfiguration().getEdalEmailAddress() + ">");
            }
            catch (UnsupportedEncodingException e) {
                DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
            }
        } else {
            properties.put("mail.smtp.auth", "true");
            Authenticator authenticator = new Authenticator(){
                private PasswordAuthentication authentication = new PasswordAuthentication(DataManager.getConfiguration().getMailSmtpLogin(), DataManager.getConfiguration().getMailSmtpPassword());

                protected PasswordAuthentication getPasswordAuthentication() {
                    return this.authentication;
                }
            };
            session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            try {
                addressFrom = new InternetAddress(DataManager.getConfiguration().getMailSmtpLogin(), "eDAL-Service <" + DataManager.getConfiguration().getEdalEmailAddress() + ">");
            }
            catch (UnsupportedEncodingException e) {
                DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
            }
        }
        MimeMessage mail = new MimeMessage(session);
        try {
            mail.setFrom((Address)addressFrom);
            InternetAddress addressTo = new InternetAddress(emailAddress);
            mail.setRecipient(Message.RecipientType.TO, (Address)addressTo);
            mail.setSubject(subject);
            mail.setContent((Object)message, "text/html; charset=UTF-8");
            Transport.send((Message)mail);
        }
        catch (MessagingException e) {
            DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
        }
    }

    private void sendRejectedMails(String emailAddress, PublicReference publicReference) throws EdalApprovalException {
        String message;
        VeloCityGenerator veloCityGenerator = new VeloCityGenerator();
        try {
            message = veloCityGenerator.generateRejectedEmail(publicReference).toString();
        }
        catch (VelocityException e) {
            throw new EdalApprovalException("unable to generate e-mail", e);
        }
        this.sendEmail(message, "[eDAL - data publication rejected]", emailAddress);
    }

    private void sendRequestApprovalMail(String ticket, PublicReference reference, InternetAddress emailAddress, ReviewStatus.ReviewerType reviewerType) throws EdalApprovalException {
        DataManager.getImplProv().getLogger().debug((Object)("Send Requestmail :" + emailAddress));
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        int hashCode = emailAddress.getAddress().hashCode();
        ReviewersImplementation reviewer = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)hashCode)).add((Criterion)Restrictions.eq((String)"emailAddress", (Object)emailAddress.getAddress())).uniqueResult();
        if (reviewer == null) {
            reviewer = new ReviewersImplementation(emailAddress.getAddress(), hashCode);
            Transaction transaction = session.beginTransaction();
            session.save((Object)reviewer);
            transaction.commit();
        }
        session.close();
        VeloCityGenerator veloCityGenerator = new VeloCityGenerator();
        try {
            StringWriter stringWriter = veloCityGenerator.generateRequestEmail(reference.getVersion(), EdalJettyServer.generateMethodURL(ticket, emailAddress.hashCode(), EdalHttpFunctions.ACCEPT), EdalJettyServer.generateMethodURL(ticket, emailAddress.hashCode(), EdalHttpFunctions.REJECT), EdalJettyServer.generateMethodURL(ticket, emailAddress.hashCode(), EdalHttpFunctions.REVIEW), reference.getRequestedPrincipal(), emailAddress, reviewerType, EdalJettyServer.generateReviewerURL(this.createLandingPageURL((PublicReferenceImplementation)reference), hashCode), reference.getIdentifierType());
            this.sendEmail(stringWriter.toString(), "[eDAL - review request for data publication" + (Object)((Object)reference.getIdentifierType()) + "]", emailAddress.getAddress());
        }
        catch (EdalException | VelocityException e) {
            throw new EdalApprovalException("unable to generate e-mail", e);
        }
    }

    private void sendStatusMailToRequestedPerson(InternetAddress emailAddress, PublicReference publicReference) throws EdalApprovalException {
        try {
            StringWriter stringWriter = new VeloCityGenerator().generateStatusEmail(publicReference);
            this.sendEmail(stringWriter.toString(), "[eDAL - requesting status]", emailAddress.getAddress());
        }
        catch (VelocityException e) {
            throw new EdalApprovalException("unable to generate e-mail", e);
        }
    }

    private void setPublicReferenceToFalse(String ticket) throws EdalApprovalException {
        PublicReferenceImplementation publicRef = synchronizedMap.get(ticket);
        if (publicRef == null) {
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
            PublicReferenceImplementation publicReference = ticketImplementation.getReference();
            transaction.commit();
            session.close();
            try {
                publicReference.getReferencable().rejectApprovalRequest(publicReference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to reject PublicReference", e);
            }
            org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction2 = session2.beginTransaction();
            publicReference.setRejectedDate(Calendar.getInstance());
            publicReference.setPublicationStatus(PublicationStatus.REJECTED);
            session2.update((Object)publicReference);
            transaction2.commit();
            session2.close();
        } else {
            try {
                publicRef.getReferencable().rejectApprovalRequest(publicRef);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to reject PublicReference", e);
            }
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            publicRef.setRejectedDate(Calendar.getInstance());
            publicRef.setPublicationStatus(PublicationStatus.REJECTED);
            session.update((Object)publicRef);
            transaction.commit();
            session.close();
        }
    }

    private String setPublicReferenceToTrue(String ticket) throws EdalApprovalException {
        PublicReferenceImplementation publicRef = synchronizedMap.get(ticket);
        if (publicRef == null) {
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
            PublicReferenceImplementation publicReference = ticketImplementation.getReference();
            transaction.commit();
            session.close();
            String newId = "";
            try {
                newId = publicReference.getReferencable().acceptApprovalRequest(publicReference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to get new ID: " + e.getMessage(), e.getCause());
            }
            org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction2 = session2.beginTransaction();
            publicReference.setAssignedID(newId);
            publicReference.setPublic(true);
            publicReference.setAcceptedDate(Calendar.getInstance());
            publicReference.setPublicationStatus(PublicationStatus.ACCEPTED);
            session2.update((Object)publicReference);
            transaction2.commit();
            session2.close();
            return newId;
        }
        String newId = "";
        try {
            newId = publicRef.getReferencable().acceptApprovalRequest(publicRef);
        }
        catch (EdalException e) {
            throw new EdalApprovalException("unable to get new ID: " + e.getMessage(), e.getCause());
        }
        publicRef.setAssignedID(newId);
        publicRef.setPublic(true);
        publicRef.setAcceptedDate(Calendar.getInstance());
        publicRef.setPublicationStatus(PublicationStatus.ACCEPTED);
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)publicRef);
        transaction.commit();
        session.close();
        return newId;
    }

    @Override
    public String storeNewDOI(PublicReference reference, String doi, int year) throws EdalApprovalException {
        if (reference instanceof PublicReferenceImplementation) {
            PublicReferenceImplementation publicReferenceImplementation = (PublicReferenceImplementation)reference;
            publicReferenceImplementation.setVersion(reference.getVersion());
            publicReferenceImplementation.setAcceptedDate(Calendar.getInstance());
            publicReferenceImplementation.setAssignedID(doi);
            publicReferenceImplementation.setPublicationStatus(PublicationStatus.ACCEPTED);
            publicReferenceImplementation.setPublic(true);
            publicReferenceImplementation.setIdentifierType(reference.getIdentifierType());
            DoiImplementation doiImplementation = new DoiImplementation();
            doiImplementation.setReference(publicReferenceImplementation);
            doiImplementation.setUrl(doi);
            doiImplementation.setYear(year);
            try {
                org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                Transaction transaction = session.beginTransaction();
                session.saveOrUpdate((Object)publicReferenceImplementation);
                transaction.commit();
                session.close();
                org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                Transaction transaction2 = session2.beginTransaction();
                session2.save((Object)doiImplementation);
                transaction2.commit();
                session2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return doi;
        }
        throw new EdalApprovalException("reference object is no instanceof PublicReferenceImplementation");
    }

    private void storeTicket(String ticket, PublicReference reference, InternetAddress emailNotificationAddress) {
        PublicReferenceImplementation publicReference = (PublicReferenceImplementation)reference;
        publicReference.setRequestedDate(Calendar.getInstance());
        publicReference.setLandingPage(this.createLandingPageString(reference));
        TicketImplementation ticketImplementation = new TicketImplementation(ticket, publicReference, emailNotificationAddress.getAddress());
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)publicReference);
        session.save((Object)ticketImplementation);
        transaction.commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReviewStatus(PublicReference publicReference, ReviewResult result) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TicketImplementation ticket = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"reference", (Object)publicReference)).uniqueResult();
        session.close();
        switch (result.getReviewResult()) {
            case ACCEPTED: {
                Map<String, PublicReferenceImplementation> map = synchronizedMap;
                synchronized (map) {
                    if (synchronizedMap.containsKey(ticket.getTicket())) {
                        String newId = "";
                        try {
                            newId = this.setPublicReferenceToTrue(ticket.getTicket());
                        }
                        catch (EdalException e) {
                            throw new EdalApprovalException("unable to set PublicReference to TRUE: " + e.getMessage(), e.getCause());
                        }
                        this.deleteReviewStatus(ticket.getReference());
                        this.deleteTicket(ticket.getTicket());
                        try {
                            this.sendAcceptedMail(newId, ticket.getEmailNotificationAddress(), this.createLandingPageURL(ticket.getReference()), publicReference);
                        }
                        catch (EdalApprovalException e) {
                            throw new EdalApprovalException("unable to send Accepted-Email", e);
                        }
                        synchronizedMap.remove(ticket.getTicket());
                    }
                    break;
                }
            }
            case REJECTED: {
                try {
                    this.setPublicReferenceToFalse(ticket.getTicket());
                }
                catch (EdalApprovalException e) {
                    throw new EdalApprovalException("unable to set PublicReference to FALSE: " + e.getMessage(), e.getCause());
                }
                try {
                    this.sendRejectedMails(ticket.getEmailNotificationAddress(), publicReference);
                }
                catch (EdalApprovalException e) {
                    throw new EdalApprovalException("unable to send Rejected-Email", e);
                }
                this.deleteReviewStatus(ticket.getReference());
                this.deleteTicket(ticket.getTicket());
                synchronizedMap.remove(ticket.getTicket());
                break;
            }
            case UNDECIDED: {
                Calendar now = Calendar.getInstance();
                if (now.getTimeInMillis() - ticket.getReminderEmailSend().getTimeInMillis() <= 172800000L) break;
                for (ReviewStatus reviewStatus : result.getReviewerStatusList()) {
                    if (!reviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) continue;
                    try {
                        this.sendRequestApprovalMail(ticket.getTicket(), ticket.getReference(), reviewStatus.getEmailAddress(), reviewStatus.getReviewerType());
                    }
                    catch (EdalApprovalException e) {
                        throw new EdalApprovalException("unable to send notification email to reviewer " + reviewStatus.getEmailAddress(), e);
                    }
                }
                ticket.setReminderEmailSend(now);
                this.updateTicketReminder(ticket);
                break;
            }
        }
    }

    private void updateTicketReminder(TicketImplementation ticket) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)ticket);
        transaction.commit();
        session.close();
    }
}

