/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.HttpServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ApprovalServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.HttpServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.IndexWriterThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PermissionProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ServiceProviderImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.SupportedPrincipals;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.PermissionProvider;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaValidator;

public class FileSystemImplementationProvider
implements ImplementationProvider {
    private static final String EDALDB_DBNAME = "edaldb";
    private Logger logger;
    private static final int SQL_ERROR_DATABASE_IN_USE = 90020;
    private static final int SQL_ERROR_DATABASE_NOT_FOUND = 90013;
    private boolean autoIndexing;
    private EdalConfiguration configuration;
    private Connection connection;
    private String databasePassword;
    private String databaseUsername;
    private IndexWriterThread indexThread;
    private SessionFactory sessionFactory;

    public FileSystemImplementationProvider(EdalConfiguration configuration) {
        StandardServiceRegistry serviceRegistry;
        block31: {
            this.logger = null;
            this.connection = null;
            this.indexThread = null;
            this.sessionFactory = null;
            this.configuration = configuration;
            try {
                this.setDatabaseUsername(this.getConfiguration().getDatabaseUsername());
                this.setDatabasePassword(this.getConfiguration().getDatabasePassword());
            }
            catch (EdalConfigurationException e) {
                e.printStackTrace();
            }
            this.logger = configuration.getLogger();
            this.setAutoIndexing(this.autoIndexing);
            try {
                try {
                    Class.forName("org.h2.Driver");
                    this.setConnection(DriverManager.getConnection("jdbc:h2:" + this.getMountPath() + ";IFEXISTS=TRUE;DB_CLOSE_ON_EXIT=FALSE;MVCC=TRUE", this.getDatabaseUsername(), this.getDatabasePassword()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.getLogger().error((Object)"Could not find driver for H2 connection !");
                    System.exit(0);
                }
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 90020) {
                    this.getLogger().warn((Object)"Database still in use -> close and restart please !");
                    System.exit(0);
                }
                if (se.getErrorCode() != 90013) break block31;
                this.getLogger().info((Object)"No database found -> creating new database...");
                try {
                    this.setConnection(DriverManager.getConnection("jdbc:h2:" + this.getMountPath() + ";DB_CLOSE_ON_EXIT=FALSE;MVCC=TRUE", this.getDatabaseUsername(), this.getDatabasePassword()));
                }
                catch (SQLException sQLException) {
                    this.getLogger().error((Object)"Could not start H2 connection !");
                    System.exit(0);
                }
            }
        }
        Configuration config = new Configuration();
        config.configure(FileSystemImplementationProvider.class.getResource("hibernate.cfg.xml"));
        config.setProperty("hibernate.connection.url", "jdbc:h2:" + this.getMountPath());
        config.setProperty("hibernate.connection.username", this.getDatabaseUsername());
        config.setProperty("hibernate.connection.password", this.getDatabasePassword());
        config.setProperty("hibernate.search.default.indexBase", Paths.get(this.getMountPath().toString(), "lucene").toString());
        if (!this.isAutoIndexing()) {
            config.setProperty("hibernate.search.indexing_strategy", "manual");
        }
        Boolean exists = false;
        try {
            Throwable throwable = null;
            Object var5_11 = null;
            try (ResultSet result = this.getConnection().createStatement().executeQuery("SELECT count(*) FROM ENTITIES ");){
                result.last();
                int resultSize = result.getInt("COUNT(*)");
                if (resultSize > 0) {
                    exists = true;
                }
                result.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            exists = false;
        }
        CacheManager.create((InputStream)FileSystemImplementationProvider.class.getResourceAsStream("ehcache.xml"));
        if (!exists.booleanValue()) {
            new SchemaExport(config).create(false, true);
            try {
                serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
                this.setSessionFactory(config.buildSessionFactory((ServiceRegistry)serviceRegistry));
            }
            catch (HibernateException e) {
                this.logger.error((Object)"Lucene Index damaged", (Throwable)e);
                this.logger.info((Object)"Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
        } else {
            try {
                serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
                this.setSessionFactory(config.buildSessionFactory((ServiceRegistry)serviceRegistry));
            }
            catch (HibernateException e) {
                this.logger.debug((Object)"Lucene Index damaged", (Throwable)e);
                this.logger.info((Object)"Lucene Index damaged -> clean up index directory to rebuild the index !");
                System.exit(0);
            }
            try {
                new SchemaValidator(config).validate();
                this.getLogger().info((Object)"Database schema validation : successful");
            }
            catch (HibernateException e) {
                this.getLogger().error((Object)("Found existing, but not compatible database schema in path '" + configuration.getMountPath() + "' (" + e.getMessage() + ") "));
                this.getLogger().error((Object)"Please delete path or specify another mount path !");
                System.exit(0);
            }
        }
        this.getSessionFactory().getStatistics().setStatisticsEnabled(true);
        if (!this.isAutoIndexing()) {
            this.setIndexThread(new IndexWriterThread(this.getSessionFactory()));
            this.getIndexThread().start();
        }
    }

    @Override
    public MetaDataImplementation createMetaDataInstance() {
        return new MetaDataImplementation();
    }

    @Override
    public Class<? extends ApprovalServiceProvider> getApprovalServiceProvider() {
        return ApprovalServiceProviderImplementation.class;
    }

    @Override
    public EdalConfiguration getConfiguration() {
        return this.configuration;
    }

    private Connection getConnection() {
        return this.connection;
    }

    public Path getDataPath() {
        return Paths.get(this.getConfiguration().getDataPath().toString(), EDALDB_DBNAME);
    }

    private String getDatabasePassword() {
        return this.databasePassword;
    }

    private String getDatabaseUsername() {
        return this.databaseUsername;
    }

    private IndexWriterThread getIndexThread() {
        return this.indexThread;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public Path getMountPath() {
        return Paths.get(this.getConfiguration().getMountPath().toString(), EDALDB_DBNAME);
    }

    @Override
    public Class<? extends PermissionProvider> getPermissionProvider() {
        return PermissionProviderImplementation.class;
    }

    @Override
    public Class<? extends PrimaryDataDirectory> getPrimaryDataDirectoryProvider() {
        return PrimaryDataDirectoryImplementation.class;
    }

    @Override
    public PrimaryDataEntity reloadPrimaryDataEntityByID(String uuid, long versionNumber) throws EdalException {
        PrimaryDataEntityVersion version;
        Session session = this.getSessionFactory().openSession();
        Criteria getFile = session.createCriteria(PrimaryDataFileImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataFileImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
        PrimaryDataFile file = (PrimaryDataFile)getFile.uniqueResult();
        if (file == null) {
            PrimaryDataEntityVersion version2;
            Criteria getDirectory = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add((Criterion)Restrictions.eq((String)"ID", (Object)uuid));
            PrimaryDataDirectory directory = (PrimaryDataDirectory)getDirectory.uniqueResult();
            if (directory == null) {
                session.close();
                throw new EdalException("found no entity with ID '" + uuid + "'");
            }
            try {
                version2 = directory.getVersionByRevisionNumber(versionNumber);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException(e.getMessage(), e);
            }
            try {
                directory.switchCurrentVersion(version2);
            }
            catch (PrimaryDataEntityVersionException e) {
                session.close();
                throw new EdalException("unable to switch the version with the number " + versionNumber, e);
            }
            session.close();
            return directory;
        }
        try {
            version = file.getVersionByRevisionNumber(versionNumber);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException(e.getMessage(), e);
        }
        try {
            file.switchCurrentVersion(version);
        }
        catch (PrimaryDataEntityVersionException e) {
            session.close();
            throw new EdalException("unable to switch the version with the number " + versionNumber, e);
        }
        session.close();
        return file;
    }

    @Override
    public Class<? extends PrimaryDataFile> getPrimaryDataFileProvider() {
        return PrimaryDataFileImplementation.class;
    }

    public Session getSession() {
        return this.getSessionFactory().openSession();
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Statistics getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    private boolean isAutoIndexing() {
        return this.autoIndexing;
    }

    @Override
    public PrimaryDataDirectory mount(List<Class<? extends Principal>> supportedPrincipals) throws PrimaryDataDirectoryException {
        Session session = this.getSessionFactory().openSession();
        Criteria checkRoot = session.createCriteria(PrimaryDataDirectoryImplementation.class).add((Criterion)Restrictions.eq((String)"class", PrimaryDataDirectoryImplementation.class)).add(Restrictions.isNull((String)"parentDirectory"));
        if (checkRoot.uniqueResult() == null) {
            session.close();
            DataManager.getImplProv().getLogger().info((Object)"Creating new RootDirectory...");
            Session sess = this.getSessionFactory().openSession();
            Transaction transaction = sess.beginTransaction();
            for (Class<? extends Principal> clazz : supportedPrincipals) {
                sess.save((Object)new SupportedPrincipals(clazz));
            }
            transaction.commit();
            sess.close();
            PrimaryDataDirectory newRootDirectory = null;
            try {
                Constructor<? extends PrimaryDataDirectory> constructor = DataManager.getImplProv().getPrimaryDataDirectoryProvider().getConstructor(PrimaryDataDirectory.class, String.class);
                newRootDirectory = constructor.newInstance(null, "/");
            }
            catch (Exception e) {
                throw new PrimaryDataDirectoryException("Can not instantiate the constructor to mount implementation: " + e.getMessage(), e);
            }
            return newRootDirectory;
        }
        Criteria principals = session.createCriteria(SupportedPrincipals.class);
        List privatePrincipals = principals.list();
        ArrayList<SupportedPrincipals> publicPrincipals = new ArrayList<SupportedPrincipals>(supportedPrincipals.size());
        for (Class<? extends Principal> clazz : supportedPrincipals) {
            publicPrincipals.add(new SupportedPrincipals(clazz));
        }
        if (!privatePrincipals.containsAll(publicPrincipals)) {
            DataManager.getImplProv().getLogger().warn((Object)"Not all principals are supported , please define new list and connect again !");
            throw new PrimaryDataDirectoryException("Not all principals are supported , please define new list and connect again !");
        }
        DataManager.getImplProv().getLogger().info((Object)"All principals are supported !");
        DataManager.getImplProv().getLogger().info((Object)"Getting existing RootDirectory...");
        PrimaryDataDirectoryImplementation existingRootDirectory = (PrimaryDataDirectoryImplementation)checkRoot.uniqueResult();
        session.close();
        PrimaryDataDirectoryImplementation existingRootDirectoryOrg = existingRootDirectory;
        return existingRootDirectoryOrg;
    }

    private void setAutoIndexing(boolean autoIndexing) {
        this.autoIndexing = autoIndexing;
    }

    private void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    private void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    private void setIndexThread(IndexWriterThread indexThread) {
        this.indexThread = indexThread;
    }

    private void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void shutdown() {
        if (!this.isAutoIndexing()) {
            this.getIndexThread().waitForFinish();
        }
        try {
            this.getConnection().close();
            this.getSessionFactory().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Class<? extends ServiceProvider> getServiceProvider() {
        return ServiceProviderImplementation.class;
    }

    @Override
    public Class<? extends HttpServiceProvider> getHttpServiceProvider() {
        return HttpServiceProviderImplementation.class;
    }
}

