/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ServiceProviderImplementation
implements ServiceProvider {
    @Override
    public Long getUsedStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(DataManager.getImplProv().getConfiguration().getDataPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request used space", e);
        }
    }

    @Override
    public Long getAvailableStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            return Files.getFileStore(DataManager.getImplProv().getConfiguration().getDataPath()).getUsableSpace();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request available space", e);
        }
    }

    @Override
    public void cleanUp() {
    }

    private void deleteRecursiveDirectory(PrimaryDataDirectoryImplementation directory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        try {
            this.deleteFilesRecursively(session, directory);
            this.deleteDirectoriesRecursively(session, directory);
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        this.deleteDirectoryAndPermissions(directory);
        session.getTransaction().commit();
        session.close();
    }

    public void deleteDirectoriesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (!primaryDataEntity.isDirectory()) continue;
                if (((PrimaryDataDirectory)primaryDataEntity).listPrimaryDataEntities().size() == 0) {
                    this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
                    continue;
                }
                this.deleteDirectoriesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
            }
        }
    }

    public void deleteFilesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (primaryDataEntity.isDirectory()) {
                    this.deleteFilesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                    continue;
                }
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)primaryDataEntity);
            }
        }
    }

    private void deleteFileAndPermissions(PrimaryDataFileImplementation file) {
        System.out.println("Deleting local File");
        for (PrimaryDataEntityVersion version : file.getVersions()) {
            Path path = file.getPathToLocalFile(version);
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Deleting PrimaryDataFile");
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        session.delete((Object)file);
        List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)file.getID())).list();
        for (EdalPermissionImplementation permission : permissions) {
            session.delete((Object)permission);
        }
        session.getTransaction().commit();
        session.close();
    }

    private void deleteDirectoryAndPermissions(PrimaryDataDirectoryImplementation directory) {
        System.out.println("Deleting PrimaryDataDirectory");
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        session.delete((Object)directory);
        List permissions = session.createCriteria(EdalPermissionImplementation.class).add((Criterion)Restrictions.eq((String)"internId", (Object)directory.getID())).list();
        for (EdalPermissionImplementation permission : permissions) {
            session.delete((Object)permission);
        }
        session.getTransaction().commit();
        session.close();
    }
}

