/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import java.util.Calendar;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity(name="TICKETS")
public class TicketImplementation {
    private String ticket;
    private PublicReferenceImplementation reference;
    private String emailNotificationAddress;
    private Calendar reminderEmailSend;

    protected TicketImplementation() {
    }

    protected TicketImplementation(String ticket, PublicReferenceImplementation publicReference, String emailNotificationAddress) {
        this.setTicket(ticket);
        this.setReference(publicReference);
        this.setEmailNotificationAddress(emailNotificationAddress);
        this.setReminderEmailSend(Calendar.getInstance());
    }

    protected String getEmailNotificationAddress() {
        return this.emailNotificationAddress;
    }

    @OneToOne
    protected PublicReferenceImplementation getReference() {
        return this.reference;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getReminderEmailSend() {
        return this.reminderEmailSend == null ? Calendar.getInstance() : this.reminderEmailSend;
    }

    @Id
    protected String getTicket() {
        return this.ticket;
    }

    protected void setEmailNotificationAddress(String emailNotificationAddress) {
        this.emailNotificationAddress = emailNotificationAddress;
    }

    protected void setReference(PublicReferenceImplementation reference) {
        this.reference = reference;
    }

    public void setReminderEmailSend(Calendar reminderEmailSend) {
        this.reminderEmailSend = reminderEmailSend;
    }

    protected void setTicket(String ticket) {
        this.ticket = ticket;
    }
}

