/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalPublicationMetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalReferenceable;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMDSConnector;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteSearchConnector;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteXmlMapper;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.XmlFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlResource;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import javax.xml.bind.JAXBException;

public class DataCiteReference
implements EdalReferenceable {
    private static final String TEST_URL = "http://doi.ipk-gatersleben.de/testdata/demo_doi_landingpage/";
    private static final String TEST_DOI = "10.5072/EDALTEST/12345";

    @Override
    public String acceptApprovalRequest(PublicReference publicReference) throws EdalApprovalException {
        Class<DataCiteReference> clazz = DataCiteReference.class;
        synchronized (DataCiteReference.class) {
            if (!DataManager.getConfiguration().isInTestMode()) {
                try {
                    int year = Calendar.getInstance().get(1);
                    String doi = "";
                    try {
                        doi = new DataCiteSearchConnector(DataManager.getConfiguration()).generateNewDOI(year);
                    }
                    catch (DataCiteException e) {
                        throw new EdalApprovalException("unable to generate new DOI", e);
                    }
                    DataManager.getImplProv().getLogger().info((Object)("Next Free DOI from DataCite: " + doi));
                    StringBuffer dataCiteXml = this.generateDataCiteXML(publicReference, doi);
                    DataManager.getImplProv().getLogger().info((Object)("Generated DataCite XML : \n" + dataCiteXml));
                    String internalURL = this.createLandingPageURL(publicReference).toString();
                    DataManager.getImplProv().getLogger().info((Object)("Validating : " + doi + "..."));
                    this.validateMetaData(publicReference.getVersion());
                    DataManager.getImplProv().getLogger().info((Object)"Validation successful !");
                    DataCiteMDSConnector connector = new DataCiteMDSConnector(DataManager.getConfiguration());
                    try {
                        DataManager.getImplProv().getLogger().info((Object)("Posting MetaData for : " + doi + "..."));
                        connector.postMetadata(XmlFunctions.parse(dataCiteXml.toString()));
                        DataManager.getImplProv().getLogger().info((Object)("Posting URL : " + internalURL + "..."));
                        connector.postDOI(doi, internalURL);
                        DataManager.getImplProv().getLogger().info((Object)("Post was successful for : " + doi));
                    }
                    catch (DataCiteException e) {
                        throw new EdalApprovalException("unable to post metadata and DOI to DataCite : ", e);
                    }
                    try {
                        DataManager.getImplProv().getApprovalServiceProvider().newInstance().storeNewDOI(publicReference, doi, year);
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        throw new EdalApprovalException("unable to store a new DOI for the PublicReference");
                    }
                    return doi;
                }
                catch (EdalException | EdalPublicationMetaDataException e) {
                    e.printStackTrace();
                    throw new EdalApprovalException("unable to accept approvalRequest", e);
                }
            }
            try {
                int year = Calendar.getInstance().get(1);
                StringBuffer dataCiteXml = this.generateDataCiteXML(publicReference, TEST_DOI);
                this.validateMetaData(publicReference.getVersion());
                System.out.println(dataCiteXml);
                System.out.println(TEST_DOI);
                try {
                    DataManager.getImplProv().getApprovalServiceProvider().newInstance().storeNewDOI(publicReference, TEST_DOI, year);
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new EdalApprovalException("unable to store a new DOI for the PublicReference");
                }
                DataManager.getImplProv().getLogger().warn((Object)"Your PublicReference was not posted to DataCite, because you are running in Test-Mode");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return TEST_DOI;
            }
            catch (EdalException | EdalPublicationMetaDataException e) {
                throw new EdalApprovalException("unable to accept approvalRequest:" + e.getMessage(), e.getCause());
            }
        }
    }

    private StringBuffer generateDataCiteXML(PublicReference publicReference, String doi) throws EdalPublicationMetaDataException {
        DataCiteXmlMapper xmlMapper = new DataCiteXmlMapper(publicReference.getVersion());
        XmlResource xmlResource = xmlMapper.createXmlResource();
        xmlResource.setIdentifier(new XmlIdentifier(doi));
        StringWriter strw = new StringWriter();
        try {
            xmlMapper.createXmlMarshaller().marshal((Object)xmlResource, (Writer)strw);
        }
        catch (JAXBException e) {
            throw new EdalPublicationMetaDataException("Unable to marshall meta data from PublicReference", e);
        }
        return strw.getBuffer();
    }

    private String createLandingPageString(PublicReference reference) {
        String landingpage = "/" + reference.getIdentifierType().toString() + "/" + reference.getInternalID() + "/" + reference.getVersion().getEntity().getID() + "/" + reference.getVersion().getRevision();
        return landingpage;
    }

    private URL createLandingPageURL(PublicReference reference) throws EdalApprovalException {
        URL url = null;
        try {
            url = EdalJettyServer.getServerURL();
            return new URL(url, this.createLandingPageString(reference));
        }
        catch (EdalException | MalformedURLException e) {
            throw new EdalApprovalException("unable to create URL for the landing page : " + e.getMessage(), e);
        }
    }

    @Override
    public void rejectApprovalRequest(PublicReference publicReference) throws EdalApprovalException {
    }

    @Override
    public void validateMetaData(PrimaryDataEntityVersion entityVersion) throws EdalPublicationMetaDataException {
        DataCiteXmlMapper mapper = new DataCiteXmlMapper(entityVersion);
        XmlResource resource = mapper.createXmlResource();
        mapper.validateSchema(resource);
    }

    @Override
    public void validate(PrimaryDataEntityVersion entityVersion) throws EdalPublicationMetaDataException {
    }
}

