/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types;

import java.util.HashMap;
import java.util.Map;

public enum ResourceType {
    Audiovisual("Audiovisual"),
    Collection("Collection"),
    Dataset("Dataset"),
    Event("Event"),
    Image("Image"),
    InteractiveResource("InteractiveResource"),
    Model("Model"),
    Other("Other"),
    PhysicalObject("PhysicalObject"),
    Service("Service"),
    Software("Software"),
    Sound("Sound"),
    Text("Text"),
    Workflow("Workflow");

    private final String value;
    private static final Map<String, ResourceType> ENUM_CONSTANTS;

    static {
        ENUM_CONSTANTS = new HashMap<String, ResourceType>();
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType c = resourceTypeArray[n2];
            ENUM_CONSTANTS.put(c.value, c);
            ++n2;
        }
    }

    private ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType fromValue(String value) {
        ResourceType c = ENUM_CONSTANTS.get(value);
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(value);
    }

    public void setValue(String value) {
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }
}

