/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class EdalCompositePolicy
extends Policy {
    private List<Policy> policies = Collections.emptyList();

    public EdalCompositePolicy(List<Policy> policies) {
        this.policies = new ArrayList<Policy>(policies);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        for (Policy p : this.policies) {
            PermissionCollection permsCol = p.getPermissions(codesource);
            Enumeration<Permission> en = permsCol.elements();
            while (en.hasMoreElements()) {
                Permission p1 = en.nextElement();
                perms.add(p1);
            }
        }
        return perms;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        for (Policy p : this.policies) {
            PermissionCollection permCol = p.getPermissions(domain);
            Enumeration<Permission> en = permCol.elements();
            while (en.hasMoreElements()) {
                Permission p1 = en.nextElement();
                perms.add(p1);
            }
        }
        return perms;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        for (Policy p : this.policies) {
            if (!p.implies(domain, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        for (Policy p : this.policies) {
            p.refresh();
        }
    }
}

