/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import de.ipk_gatersleben.bit.bi.edal.sample.login.GoogleLoginDialog;
import de.ipk_gatersleben.bit.bi.edal.sample.login.GoogleOauth;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GoogleCallBackHandler
implements CallbackHandler {
    private String password;
    private String username;
    private boolean keepLogin;
    private String httpProxyHost;
    private int httpProxyPort;
    private boolean alreadySetted = false;

    public GoogleCallBackHandler() {
    }

    public GoogleCallBackHandler(String name, String httpProxyHost, int httpProxyPort) {
        this.username = name;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.keepLogin = GoogleOauth.isLogged(this.username);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        GoogleLoginDialog loginDialog = null;
        if (!this.alreadySetted) {
            loginDialog = new GoogleLoginDialog(null, "Login to Google+", this.username, this.keepLogin);
            loginDialog.setVisible(true);
            if (loginDialog.getStatus() == 1) {
                this.username = loginDialog.getUsername();
                this.password = loginDialog.getPassword();
                this.keepLogin = loginDialog.isKeepLoginChecked();
                this.alreadySetted = true;
            }
            if (loginDialog.getStatus() == 0) {
                this.alreadySetted = true;
            }
        }
        if (loginDialog.getStatus() == 1) {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.username);
                } else if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password.toCharArray());
                } else if (callback instanceof ConfirmationCallback) {
                    ConfirmationCallback cc = (ConfirmationCallback)callback;
                    if (this.keepLogin) {
                        cc.setSelectedIndex(0);
                    } else {
                        cc.setSelectedIndex(1);
                    }
                } else if (callback instanceof TextInputCallback) {
                    TextInputCallback tic = (TextInputCallback)callback;
                    if (this.httpProxyHost != null) {
                        tic.setText(String.valueOf(this.httpProxyHost) + ":" + this.httpProxyPort);
                    }
                }
                ++n2;
            }
        }
    }
}

