/*
 * Copyright (c) 2015 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.sample.login;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * Password callback handler for resolving user name and password for a JAAS
 * login.
 * 
 * @author arendd
 */
public class GoogleCallBackHandler implements CallbackHandler {

	private String password;
	private String username;
	private boolean keepLogin;
	private String httpProxyHost;
	private int httpProxyPort;

	private boolean alreadySetted = false;

	public GoogleCallBackHandler() {
		super();
	}

	public GoogleCallBackHandler(final String name, final String httpProxyHost, final int httpProxyPort) {
		super();
		this.username = name;
		this.httpProxyHost = httpProxyHost;
		this.httpProxyPort = httpProxyPort;
		if (GoogleOauth.isLogged(username)) {
			this.keepLogin = true;
		} else {
			this.keepLogin = false;
		}

	}

	/**
	 * Handles the callbacks, and sets the user/password detail.
	 * 
	 * @param callbacks
	 *            the callbacks to handle
	 * @throws IOException
	 *             if an input or output error occurs.
	 */
	public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {

		GoogleLoginDialog loginDialog= null;
		
		if (!alreadySetted) {

			loginDialog = new GoogleLoginDialog(null, "Login to Google+", this.username, this.keepLogin);
			loginDialog.setVisible(true);

			if (loginDialog.getStatus() == LoginDialog.TRY_LOGIN) {
				this.username = loginDialog.getUsername();
				this.password = loginDialog.getPassword();
				this.keepLogin = loginDialog.isKeepLoginChecked();
				alreadySetted = true;
			}
			if (loginDialog.getStatus() == LoginDialog.ABORT) {
				alreadySetted = true;
			}

		}

		if (loginDialog.getStatus() == LoginDialog.TRY_LOGIN) {

			for (final Callback callback : callbacks) {
				if (callback instanceof NameCallback) {

					final NameCallback nc = (NameCallback) callback;

					nc.setName(this.username);

				} else if (callback instanceof PasswordCallback) {

					final PasswordCallback pc = (PasswordCallback) callback;

					pc.setPassword(this.password.toCharArray());
				} else if (callback instanceof ConfirmationCallback) {

					final ConfirmationCallback cc = (ConfirmationCallback) callback;

					if (this.keepLogin) {
						cc.setSelectedIndex(ConfirmationCallback.YES);
					} else {
						cc.setSelectedIndex(ConfirmationCallback.NO);
					}
				} else if (callback instanceof TextInputCallback) {

					final TextInputCallback tic = (TextInputCallback) callback;

					if (httpProxyHost != null) {
						tic.setText(httpProxyHost + ":" + httpProxyPort);
					}
				}
			}
		}
	}

}