/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.util.UriFilter;
import java.net.URI;

public class HostnameFilter
implements UriFilter {
    private static final String PROTOCOL_ENDING = "://";
    private String matchTo;
    private String protocolFilter;
    private Mode mode;

    public HostnameFilter(Mode mode, String matchTo) {
        this.mode = mode;
        this.matchTo = matchTo.toLowerCase();
        this.extractProtocolFilter();
    }

    private void extractProtocolFilter() {
        int protocolIndex = this.matchTo.indexOf(PROTOCOL_ENDING);
        if (protocolIndex != -1) {
            this.protocolFilter = this.matchTo.substring(0, protocolIndex);
            this.matchTo = this.matchTo.substring(protocolIndex + PROTOCOL_ENDING.length());
        }
    }

    @Override
    public boolean accept(URI uri) {
        if (uri == null || uri.getAuthority() == null) {
            return false;
        }
        if (!this.isProtocolMatching(uri)) {
            return false;
        }
        String host = uri.getAuthority();
        int index = host.indexOf(58);
        if (index != -1) {
            host = host.substring(0, index);
        }
        switch (this.mode) {
            case BEGINS_WITH: {
                return host.toLowerCase().startsWith(this.matchTo);
            }
            case ENDS_WITH: {
                return host.toLowerCase().endsWith(this.matchTo);
            }
            case REGEX: {
                return host.toLowerCase().matches(this.matchTo);
            }
        }
        return false;
    }

    private boolean isProtocolMatching(URI uri) {
        return this.protocolFilter == null || uri.getScheme() == null || uri.getScheme().equalsIgnoreCase(this.protocolFilter);
    }

    public static enum Mode {
        BEGINS_WITH,
        ENDS_WITH,
        REGEX;

    }
}

