/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.util.PlatformUtil;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.security.auth.NTUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMDSConnector;
import de.ipk_gatersleben.bit.bi.edal.sample.login.GooglePrincipal;
import de.ipk_gatersleben.bit.bi.edal.sample.login.SamplePrincipal;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public final class EdalConfiguration {
    private static final String MSG_UNABLE_TO_SET_PROXY = "unable to set proxy: ";
    private static Logger logger = null;
    public static final String DATACITE_SEARCH_URL = "http://search.datacite.org/api/";
    private static final String DATACITE_MDS_URL = "https://mds.datacite.org/doi";
    public static final String DATACITE_TESTPREFIX = "10.5072";
    private boolean inTestMode = false;
    public static final int DATACITE_CONNECTION_TIMEOUT = 10000;
    public static final int DATACITE_CONNECTION_READ_TIMEOUT = 10000;
    public static final int SMTP_CONNECTION_TIMEOUT = 5000;
    private static final String[] MAIL_SERVER_NAMES;
    private final String edalEmailAddress = "noreply@nodomain.com.invalid";
    private String dataCitePassword;
    private String dataCitePrefix;
    private String dataCiteUser;
    public static final Path DEFAULT_PATH;
    private Path mountPath = DEFAULT_PATH;
    private Path dataPath = DEFAULT_PATH;
    public static final URL KEY_STORE_PATH;
    public static final String KEYSTORE_PASSWORD = "eDALkey";
    private boolean useSSL = true;
    private InternetAddress errorEmailAddress;
    private Logger errorLogger;
    private String databasePassword;
    private String databaseUsername;
    private int httpPort;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpsProxyHost;
    private int httpsProxyPort;
    private String mailSmtpHost;
    private String mailSmtpLogin;
    private String mailSmtpPassword;
    private InternetAddress reviewerManaging;
    private InternetAddress reviewerScientific;
    private InternetAddress reviewerSubstitute;
    private InternetAddress rootUser;
    private List<Class<? extends Principal>> supportedPrincipals;
    private boolean useSystemProxies = false;
    public static final List<Class<? extends Principal>> DEFAULT_SUPPORTED_PRINCIPALS;
    public static final String DEFAULT_DATABASE_USERNAME = "sa";
    public static final String DEFAULT_DATABASE_PASSWORD = "";
    public static final int DEFAULT_HTTP_PORT = 8085;
    private boolean useSSLForHttpListener = false;
    private URL certificatePathForHttpListener = null;
    private String keystorePasswordForHttpListener = "";
    private List<String> aliasDomainNames = null;

    static {
        DOMConfigurator.configure((URL)EdalConfiguration.class.getResource("log4j.xml"));
        logger = Logger.getLogger((String)"eDAL-API");
        MAIL_SERVER_NAMES = new String[]{"IMAP", "POP", "MAIL", "SMTP", "EXCHANGE"};
        DEFAULT_PATH = Paths.get(System.getProperty("user.home"), "edal");
        KEY_STORE_PATH = EdalConfiguration.class.getClassLoader().getResource("de/ipk_gatersleben/bit/bi/edal/primary_data/keystore.jks");
        DEFAULT_SUPPORTED_PRINCIPALS = new ArrayList<Class>(Arrays.asList(SamplePrincipal.class, NTUserPrincipal.class, UnixPrincipal.class, KerberosPrincipal.class, GooglePrincipal.class));
    }

    public static InetSocketAddress guessProxySettings() {
        ArrayList<ProxySearch.Strategy> strategies = new ArrayList<ProxySearch.Strategy>();
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.WIN);
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.IE);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.KDE);
            strategies.add(ProxySearch.Strategy.GNOME);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.MAC_OS) {
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            strategies.add(ProxySearch.Strategy.ENV_VAR);
            strategies.add(ProxySearch.Strategy.JAVA);
            strategies.add(ProxySearch.Strategy.BROWSER);
            strategies.add(ProxySearch.Strategy.FIREFOX);
        } else {
            strategies.add(ProxySearch.Strategy.OS_DEFAULT);
        }
        ProxySearch proxySearch = null;
        for (ProxySearch.Strategy strategy : strategies) {
            proxySearch = new ProxySearch();
            proxySearch.addStrategy(strategy);
            try {
                List<Proxy> proxyList = proxySearch.getProxySelector().select(new URI(DATACITE_MDS_URL));
                if (proxyList == null) continue;
                for (Proxy proxy2 : proxyList) {
                    InetSocketAddress address;
                    Proxy proxy = proxy2;
                    if (!proxy.type().equals((Object)Proxy.Type.HTTP) || (address = (InetSocketAddress)proxy.address()) == null) continue;
                    return address;
                }
            }
            catch (NullPointerException | URISyntaxException exception) {
                logger.info((Object)("No proxy settings found for strategy " + (Object)((Object)strategy)));
            }
        }
        return null;
    }

    public static String guessSmtpSettings(String smtpLogin, String smtpPassword) throws EdalConfigurationException {
        String[] stringArray = MAIL_SERVER_NAMES;
        int n = MAIL_SERVER_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String mailServerNames = stringArray[n2];
            Properties properties = new Properties();
            properties.put("mail.smtp.host", mailServerNames);
            properties.put("mail.smtp.connectiontimeout", (Object)5000);
            properties.put("mail.smtp.timeout", (Object)5000);
            properties.put("mail.smtp.ssl.trust", mailServerNames);
            Session session = Session.getDefaultInstance((Properties)properties);
            try {
                if (!smtpLogin.isEmpty() && !smtpPassword.isEmpty()) {
                    session.getTransport("smtp").connect(smtpLogin, smtpPassword);
                } else {
                    session.getTransport("smtp").connect();
                }
                logger.info((Object)("SMTP connection test: " + mailServerNames + " : successful"));
                return mailServerNames;
            }
            catch (MessagingException e) {
                logger.warn((Object)("SMTP connection test: " + mailServerNames + " -> failed : " + e.getMessage()));
                ++n2;
            }
        }
        throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings");
    }

    private EdalConfiguration() throws EdalConfigurationException {
        this.setDatabaseUsername(DEFAULT_DATABASE_USERNAME);
        this.setDatabasePassword(DEFAULT_DATABASE_PASSWORD);
        this.setSupportedPrincipals(DEFAULT_SUPPORTED_PRINCIPALS);
        this.setHttpPort(8085);
        this.setMailSmtpHost(DEFAULT_DATABASE_PASSWORD);
        this.setMailSmtpLogin(DEFAULT_DATABASE_PASSWORD);
        this.setMailSmtpPassword(DEFAULT_DATABASE_PASSWORD);
    }

    public EdalConfiguration(String dataCiteUser, String dataCitePassword, String dataCitePrefix, InternetAddress scientificReviewer, InternetAddress substituteReviewer, InternetAddress managingReviewer, InternetAddress rootUser) throws EdalConfigurationException {
        this();
        this.setDataCiteUser(dataCiteUser);
        this.setDataCitePassword(dataCitePassword);
        this.setDataCitePrefix(dataCitePrefix);
        this.setReviewerScientific(scientificReviewer);
        this.setReviewerSubstitute(substituteReviewer);
        this.setReviewerManaging(managingReviewer);
        this.setRootUser(rootUser);
        this.setErrorEmailAddress(rootUser);
        this.validate();
    }

    public EdalConfiguration(String dataCiteUser, String dataCitePassword, String dataCitePrefix, InternetAddress scientificReviewer, InternetAddress substituteReviewer, InternetAddress managingReviewer, InternetAddress rootUser, String httpProxyHost, int httpProxyPort, String httpsProxyHost, int httpsProxyPort, String smtpHost, String smtpLogin, String smtpPassword) throws EdalConfigurationException {
        this();
        this.setUseSystemProxies(true);
        this.setHttpProxyHost(httpProxyHost);
        this.setHttpProxyPort(httpProxyPort);
        this.setHttpsProxyHost(httpsProxyHost);
        this.setHttpsProxyPort(httpsProxyPort);
        this.setDataCiteUser(dataCiteUser);
        this.setDataCitePassword(dataCitePassword);
        this.setDataCitePrefix(dataCitePrefix);
        this.setReviewerScientific(scientificReviewer);
        this.setReviewerSubstitute(substituteReviewer);
        this.setReviewerManaging(managingReviewer);
        this.setRootUser(rootUser);
        this.setErrorEmailAddress(rootUser);
        this.setMailSmtpHost(smtpHost);
        this.setMailSmtpLogin(smtpLogin);
        this.setMailSmtpPassword(smtpPassword);
        this.validate();
    }

    public void addSupportedPrincipal(Class<? extends Principal> principal) {
        this.supportedPrincipals.add(principal);
    }

    protected URL getCertificatePathForHttpListener() {
        return this.certificatePathForHttpListener;
    }

    public String getDataCitePassword() throws EdalConfigurationException {
        if (this.dataCitePassword == null || this.dataCitePassword.isEmpty()) {
            throw new EdalConfigurationException("no DataCite password set!");
        }
        return this.dataCitePassword;
    }

    public String getDataCitePrefix() throws EdalConfigurationException {
        if (this.dataCitePrefix == null || this.dataCitePrefix.isEmpty()) {
            throw new EdalConfigurationException("no DataCite prefix set!");
        }
        return this.dataCitePrefix;
    }

    public String getDataCiteUser() throws EdalConfigurationException {
        if (this.dataCiteUser == null || this.dataCiteUser.isEmpty()) {
            throw new EdalConfigurationException("no DataCite user name set!");
        }
        return this.dataCiteUser;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public String getEdalEmailAddress() {
        return "noreply@nodomain.com.invalid";
    }

    protected InternetAddress getErrorEmailAddress() throws EdalConfigurationException {
        if (this.errorEmailAddress == null) {
            throw new EdalConfigurationException("no error Email address set!");
        }
        return this.errorEmailAddress;
    }

    public Logger getErrorLogger() {
        return this.errorLogger;
    }

    public String getDatabasePassword() throws EdalConfigurationException {
        if (this.databasePassword == null) {
            throw new EdalConfigurationException("no database password set!");
        }
        return this.databasePassword;
    }

    public String getDatabaseUsername() throws EdalConfigurationException {
        if (this.databaseUsername == null || this.databaseUsername.isEmpty()) {
            throw new EdalConfigurationException("no database user name set!");
        }
        return this.databaseUsername;
    }

    public int getHttpPort() throws EdalConfigurationException {
        if (this.httpPort == 0) {
            throw new EdalConfigurationException("no http port set! ");
        }
        return this.httpPort;
    }

    public String getHttpProxyHost() throws EdalConfigurationException {
        if (this.httpProxyHost == null || this.httpProxyHost.isEmpty()) {
            throw new EdalConfigurationException("no HTTP proxy host set!");
        }
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() throws EdalConfigurationException {
        if (this.httpProxyPort == 0) {
            throw new EdalConfigurationException("no HTTP proxy port set!");
        }
        return this.httpProxyPort;
    }

    public String getHttpsProxyHost() throws EdalConfigurationException {
        if (this.httpsProxyHost == null || this.httpsProxyHost.isEmpty()) {
            throw new EdalConfigurationException("no HTTPS proxy host set!");
        }
        return this.httpsProxyHost;
    }

    public int getHttpsProxyPort() throws EdalConfigurationException {
        if (this.httpsProxyPort == 0) {
            throw new EdalConfigurationException("no HTTPS port host set!");
        }
        return this.httpsProxyPort;
    }

    protected String getKeystorePasswordForHttpListener() {
        return this.keystorePasswordForHttpListener;
    }

    public Logger getLogger() {
        return logger;
    }

    public String getMailSmtpHost() {
        return this.mailSmtpHost;
    }

    public String getMailSmtpLogin() {
        return this.mailSmtpLogin;
    }

    public String getMailSmtpPassword() {
        return this.mailSmtpPassword;
    }

    public Path getMountPath() {
        return this.mountPath;
    }

    public InternetAddress getReviewerManaging() throws EdalConfigurationException {
        if (this.reviewerManaging == null) {
            throw new EdalConfigurationException("no email address for the managing reviewer set!");
        }
        try {
            this.reviewerManaging.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for managing reviewer: " + e.getMessage());
        }
        return this.reviewerManaging;
    }

    public InternetAddress getReviewerScientific() throws EdalConfigurationException {
        if (this.reviewerScientific == null) {
            throw new EdalConfigurationException("no email address for the scientific reviewer set!");
        }
        try {
            this.reviewerScientific.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for scientific reviewer: " + e.getMessage());
        }
        return this.reviewerScientific;
    }

    public InternetAddress getReviewerSubstitute() throws EdalConfigurationException {
        if (this.reviewerSubstitute == null) {
            throw new EdalConfigurationException("no email address for the substitute reviewer set!");
        }
        try {
            this.reviewerSubstitute.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for substitute reviewer: " + e.getMessage());
        }
        return this.reviewerSubstitute;
    }

    public InternetAddress getRootUser() throws EdalConfigurationException {
        if (this.rootUser == null) {
            throw new EdalConfigurationException("no email address for the root user set!");
        }
        try {
            this.rootUser.validate();
        }
        catch (AddressException e) {
            throw new EdalConfigurationException("invalid email address for root user: " + e.getMessage());
        }
        return this.rootUser;
    }

    public List<Class<? extends Principal>> getSupportedPrincipals() throws EdalConfigurationException {
        if (this.supportedPrincipals.isEmpty()) {
            throw new EdalConfigurationException("no supported principals defined!");
        }
        return this.supportedPrincipals;
    }

    public boolean isInTestMode() {
        return this.inTestMode;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isUseSSLForHttpListener() {
        return this.useSSLForHttpListener;
    }

    public boolean isUseSystemProxies() {
        return this.useSystemProxies;
    }

    protected void setCertificatePathForHttpListener(URL certificatePathForHttpListener) {
        this.certificatePathForHttpListener = certificatePathForHttpListener;
    }

    private void setDataCitePassword(String dataCitePassword) {
        this.dataCitePassword = dataCitePassword;
    }

    private void setDataCitePrefix(String dataCitePrefix) {
        this.dataCitePrefix = dataCitePrefix;
    }

    private void setDataCiteUser(String dataCiteUser) {
        this.dataCiteUser = dataCiteUser;
    }

    public void setDataPath(Path dataPath) {
        this.dataPath = dataPath;
    }

    protected void setErrorEmailAddress(InternetAddress errorEmailAddress) {
        this.errorEmailAddress = errorEmailAddress;
    }

    private void setErrorLogger(Logger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpsProxyHost(String httpsProxyHost) {
        this.httpsProxyHost = httpsProxyHost;
    }

    public void setHttpsProxyPort(int httpsProxyPort) {
        this.httpsProxyPort = httpsProxyPort;
    }

    private void setInTestMode(boolean inTestMode) {
        this.inTestMode = inTestMode;
    }

    protected void setKeystorePasswordForHttpListener(String keystorePasswordForHttpListener) {
        this.keystorePasswordForHttpListener = keystorePasswordForHttpListener;
    }

    public void setMailSmtpHost(String mailSmtpHost) {
        this.mailSmtpHost = mailSmtpHost;
    }

    public void setMailSmtpLogin(String mailSmtpLogin) {
        this.mailSmtpLogin = mailSmtpLogin;
    }

    public void setMailSmtpPassword(String mailSmtpPassword) {
        this.mailSmtpPassword = mailSmtpPassword;
    }

    public void setMountPath(Path mountPath) {
        this.mountPath = mountPath;
    }

    private void setReviewerManaging(InternetAddress reviewerManaging) {
        this.reviewerManaging = reviewerManaging;
    }

    private void setReviewerScientific(InternetAddress reviewerScientific) {
        this.reviewerScientific = reviewerScientific;
    }

    private void setReviewerSubstitute(InternetAddress reviewerSubstitute) {
        this.reviewerSubstitute = reviewerSubstitute;
    }

    private void setRootUser(InternetAddress rootUser) {
        this.rootUser = rootUser;
    }

    public void setSupportedPrincipals(List<Class<? extends Principal>> supportedPrincipals) {
        this.supportedPrincipals = supportedPrincipals;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setUseSSLForHttpListener(boolean useSSLForHttpListener, URL pathToKeyStore, String keystorePassword) {
        this.useSSLForHttpListener = useSSLForHttpListener;
        this.setCertificatePathForHttpListener(pathToKeyStore);
        this.setKeystorePasswordForHttpListener(keystorePassword);
    }

    public void setUseSystemProxies(boolean useSystemProxies) {
        this.useSystemProxies = useSystemProxies;
    }

    private boolean validate() throws EdalConfigurationException {
        this.getMountPath();
        this.getDatabaseUsername();
        this.getDatabasePassword();
        this.getHttpPort();
        this.getSupportedPrincipals();
        this.getReviewerScientific();
        this.getReviewerSubstitute();
        this.getReviewerManaging();
        this.getRootUser();
        this.validateProxies();
        this.validateDataCiteConnection();
        this.validateDataCiteAuthentication();
        this.validateDateCiteSolrSearch();
        this.validateSmtpSettings();
        return true;
    }

    private boolean validateDataCiteAuthentication() throws EdalConfigurationException {
        if (!this.getDataCitePrefix().equals(DATACITE_TESTPREFIX)) {
            DataCiteMDSConnector connector;
            this.getDataCiteUser();
            this.getDataCitePassword();
            this.getDataCitePrefix();
            try {
                connector = new DataCiteMDSConnector(this);
            }
            catch (EdalException edalException) {
                throw new EdalConfigurationException("DataCite Authentification Test failed : unable to create DataCiteMDSConnector");
            }
            ClientResponse response = connector.getDOI(String.valueOf(this.getDataCitePrefix()) + "/" + UUID.randomUUID().toString());
            if (response.getStatus() != 404 && response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new EdalConfigurationException("DataCite Authentification failed: please check username and password");
                }
                if (response.getStatus() == 500) {
                    throw new EdalConfigurationException("DataCite Authentification failed: please check prefix");
                }
                throw new EdalConfigurationException("DataCite Authentification Test failed: " + response.getStatus() + " : " + response.getStatusInfo().getReasonPhrase());
            }
            logger.info((Object)"DataCite Authentification Test: successful");
            List<String> landingPageDomainNames = this.requestRegisteredDataCiteDomainName();
            if (landingPageDomainNames == null) {
                throw new EdalConfigurationException("DataCite Domain Check failed: no registrated domain found");
            }
            logger.info((Object)("DataCite Domain Check: " + landingPageDomainNames.toString()));
            this.setAliasDomainNames(landingPageDomainNames);
            return true;
        }
        this.setInTestMode(true);
        logger.warn((Object)"DataCite Authentication : skiped (Publication-Module is running in test mode)");
        return true;
    }

    private List<String> requestRegisteredDataCiteDomainName() throws EdalConfigurationException {
        WebClient webClient = null;
        webClient = System.getProperty("http.proxyHost") != null ? new WebClient(BrowserVersion.getDefault(), System.getProperty("https.proxyHost"), Integer.valueOf(System.getProperty("https.proxyPort")).intValue()) : new WebClient(BrowserVersion.getDefault());
        try {
            HtmlPage loginPage = (HtmlPage)webClient.getPage("https://mds.datacite.org/login");
            HtmlForm form = (HtmlForm)loginPage.getForms().get(0);
            form.getInputByName("j_username").setValueAttribute(this.getDataCiteUser());
            form.getInputByName("j_password").setValueAttribute(this.getDataCitePassword());
            form.getInputByValue("Submit").click();
            HtmlPage userInfoPage = (HtmlPage)webClient.getPage("https://mds.datacite.org/userinfo");
            String registeredDomainsString = userInfoPage.getElementById("_s_org_datacite_mds_domain_Datacentre_domains_domains_id").asText();
            if (registeredDomainsString.contains(",")) {
                String[] registeredDomains = registeredDomainsString.split(",");
                return Arrays.asList(registeredDomains);
            }
            return new ArrayList<String>(Arrays.asList(registeredDomainsString));
        }
        catch (FailingHttpStatusCodeException | IOException | NullPointerException e) {
            new EdalConfigurationException("DataCite Domain Check failed: " + e.getMessage());
            return null;
        }
    }

    private boolean validateDataCiteConnection() throws EdalConfigurationException {
        try {
            logger.debug((Object)"connecting to DataCite...");
            Authenticator.setDefault(null);
            URL url = new URL(DATACITE_MDS_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Authorization", null);
            connection.getResponseCode();
            logger.info((Object)"DataCite Connection Test : successful");
            return true;
        }
        catch (IOException e) {
            throw new EdalConfigurationException("unable to access DataCite : " + e.getMessage() + ", please check your proxy settings", e);
        }
    }

    private boolean validateDateCiteSolrSearch() throws EdalConfigurationException {
        RequestConfig requestConfig = null;
        try {
            requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).setProxy(new HttpHost(this.getHttpProxyHost(), this.getHttpProxyPort())).build();
        }
        catch (EdalConfigurationException e) {
            logger.debug((Object)("DataCite SolrSearch Test : No Proxy Settings configured: " + e.getMessage()));
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(requestConfig).build();
        HttpSolrServer server = new HttpSolrServer(DATACITE_SEARCH_URL, (HttpClient)httpClient);
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("q", new String[]{"wind"});
        solrParams.set("qt", new String[]{"/"});
        try {
            if (server.query((SolrParams)solrParams).getResults().isEmpty()) {
                throw new EdalConfigurationException("unable to find results for query");
            }
            logger.info((Object)"DataCite SolrSearch Test : successful");
        }
        catch (SolrServerException e) {
            logger.error((Object)e);
            throw new EdalConfigurationException("unable to query DOIs: " + e.getMessage() + ", please check your proxy settings");
        }
        return true;
    }

    private boolean validateProxies() throws EdalConfigurationException {
        if ((this.httpProxyHost == null || this.httpProxyHost.isEmpty()) && (this.httpsProxyHost == null || this.httpsProxyHost.isEmpty()) && this.httpProxyPort == 0 & this.httpsProxyPort == 0) {
            logger.info((Object)"No Proxy Settings configured");
            this.setUseSystemProxies(false);
        }
        if (this.isUseSystemProxies()) {
            System.setProperty("java.net.useSystemProxies", "true");
            try {
                this.getHttpProxyHost();
                System.setProperty("http.proxyHost", this.getHttpProxyHost());
            }
            catch (EdalConfigurationException e) {
                logger.error((Object)(MSG_UNABLE_TO_SET_PROXY + e.getMessage()));
            }
            try {
                this.getHttpProxyPort();
                System.setProperty("http.proxyPort", String.valueOf(this.getHttpProxyPort()));
            }
            catch (EdalConfigurationException e) {
                logger.error((Object)("unabale to set Proxy : " + e.getMessage()));
            }
            try {
                this.getHttpsProxyHost();
                System.setProperty("https.proxyHost", this.getHttpsProxyHost());
            }
            catch (EdalConfigurationException e) {
                logger.error((Object)(MSG_UNABLE_TO_SET_PROXY + e.getMessage()));
            }
            try {
                this.getHttpsProxyPort();
                System.setProperty("https.proxyPort", String.valueOf(this.getHttpsProxyPort()));
            }
            catch (EdalConfigurationException e) {
                logger.error((Object)(MSG_UNABLE_TO_SET_PROXY + e.getMessage()));
            }
            logger.info((Object)"apply manual proxy settings");
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            ArrayList<ProxySearch.Strategy> strategies = new ArrayList<ProxySearch.Strategy>();
            if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.WIN);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.IE);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.KDE);
                strategies.add(ProxySearch.Strategy.GNOME);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.MAC_OS) {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
                strategies.add(ProxySearch.Strategy.ENV_VAR);
                strategies.add(ProxySearch.Strategy.JAVA);
                strategies.add(ProxySearch.Strategy.BROWSER);
                strategies.add(ProxySearch.Strategy.FIREFOX);
            } else {
                strategies.add(ProxySearch.Strategy.OS_DEFAULT);
            }
            ProxySearch proxySearch = null;
            boolean findProxySettings = false;
            for (ProxySearch.Strategy strategy : strategies) {
                proxySearch = new ProxySearch();
                proxySearch.addStrategy(strategy);
                try {
                    List<Proxy> proxyList = proxySearch.getProxySelector().select(new URI(DATACITE_MDS_URL));
                    if (proxyList != null) {
                        for (Proxy proxy2 : proxyList) {
                            InetSocketAddress address;
                            Proxy proxy = proxy2;
                            if (!proxy.type().equals((Object)Proxy.Type.HTTP) || (address = (InetSocketAddress)proxy.address()) == null) continue;
                            System.setProperty("http.proxyHost", address.getHostName());
                            System.setProperty("https.proxyHost", address.getHostName());
                            System.setProperty("http.proxyPort", Integer.toString(address.getPort()));
                            System.setProperty("https.proxyPort", Integer.toString(address.getPort()));
                            logger.info((Object)("Found HTTP Proxy : " + address.getHostName() + ":" + address.getPort()));
                            this.setHttpProxyHost(address.getHostName());
                            this.setHttpProxyPort(address.getPort());
                            this.setHttpsProxyHost(address.getHostName());
                            this.setHttpsProxyPort(address.getPort());
                            findProxySettings = true;
                        }
                    }
                }
                catch (NullPointerException | URISyntaxException exception) {
                    logger.debug((Object)("No Proxy Settings found for Strategy " + (Object)((Object)strategy)));
                }
                if (!findProxySettings) continue;
                logger.info((Object)("Proxy Settings determined automatically for Strategy : " + (Object)((Object)strategy)));
                break;
            }
            if (!findProxySettings) {
                logger.info((Object)"No automatic Proxy Settings found");
            }
        }
        return true;
    }

    private boolean validateSmtpSettings() throws EdalConfigurationException {
        if (!this.getMailSmtpHost().isEmpty()) {
            Properties properties = new Properties();
            properties.put("mail.smtp.host", this.getMailSmtpHost());
            properties.put("mail.smtp.connectiontimeout", (Object)5000);
            properties.put("mail.smtp.timeout", (Object)5000);
            properties.put("mail.smtp.ssl.trust", this.getMailSmtpHost());
            Session session = Session.getDefaultInstance((Properties)properties);
            if (this.getMailSmtpLogin().isEmpty()) {
                try {
                    session.getTransport("smtp").connect(this.getMailSmtpHost(), null, null);
                    logger.info((Object)"SMTP Connection Test -> successful");
                }
                catch (MessagingException e) {
                    logger.warn((Object)("SMTP Connection Test -> failed : " + e.getMessage()));
                    throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings : " + e.getMessage());
                }
                return true;
            }
            try {
                session.getTransport("smtp").connect(this.getMailSmtpHost(), this.getMailSmtpLogin(), this.getMailSmtpPassword());
                logger.info((Object)"SMTP Connection Test -> successful");
            }
            catch (MessagingException e) {
                logger.warn((Object)("SMTP Connection Test -> failed : " + e.getMessage()));
                throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings : " + e.getMessage());
            }
            return true;
        }
        String[] stringArray = MAIL_SERVER_NAMES;
        int n = MAIL_SERVER_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String mailServerNames = stringArray[n2];
            Properties properties = new Properties();
            properties.put("mail.smtp.host", mailServerNames);
            properties.put("mail.smtp.connectiontimeout", (Object)5000);
            properties.put("mail.smtp.timeout", (Object)5000);
            properties.put("mail.smtp.ssl.trust", mailServerNames);
            Session session = Session.getDefaultInstance((Properties)properties);
            try {
                if (!this.getMailSmtpLogin().isEmpty() && !this.getMailSmtpPassword().isEmpty()) {
                    session.getTransport("smtp").connect(this.getMailSmtpLogin(), this.getMailSmtpPassword());
                } else {
                    session.getTransport("smtp").connect();
                }
                Logger edalLogger = Logger.getLogger((String)"EDAL_SMTP_ERROR_APPENDER");
                SMTPAppender smtp = new SMTPAppender();
                smtp.setName("SMTP-APP");
                smtp.setFrom(this.getEdalEmailAddress());
                smtp.setTo(this.getErrorEmailAddress().getAddress());
                smtp.setSubject("[eDAL ERROR]");
                smtp.setSMTPHost(mailServerNames);
                smtp.setSMTPUsername(this.getMailSmtpLogin());
                smtp.setSMTPPassword(this.getMailSmtpPassword());
                smtp.setThreshold((Priority)Level.FATAL);
                smtp.setBufferSize(512);
                smtp.setLayout((Layout)new SimpleLayout());
                smtp.activateOptions();
                edalLogger.addAppender((Appender)smtp);
                this.setErrorLogger(edalLogger);
                logger.info((Object)("SMTP Connection Test: " + mailServerNames + " : successful"));
                return true;
            }
            catch (MessagingException e) {
                e.printStackTrace();
                logger.warn((Object)("SMTP Connection Test: " + mailServerNames + " -> failed : " + e.getMessage()));
                ++n2;
            }
        }
        throw new EdalConfigurationException("unable to connect to eMail Server, check SMTP settings");
    }

    public List<String> getAliasDomainNames() {
        return this.aliasDomainNames;
    }

    private void setAliasDomainNames(List<String> aliasDomainNames) {
        this.aliasDomainNames = aliasDomainNames;
    }
}

