/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.GenerateLocations;
import de.ipk_gatersleben.bit.bi.edal.primary_data.MergingThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.solr.internal.csv.CSVPrinter;
import org.apache.solr.internal.csv.CSVStrategy;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.jetty.http.HttpStatus;
import org.hibernate.Criteria;
import org.hibernate.Session;

class VeloCityHtmlGenerator {
    private static final String STRING_VERSION = "version";
    private static final String STRING_NO_PUBLIC_REFERENCE_FOR_THIS_VERSION_SET = "No Public Reference for this version set!";
    private static final String STRING_UNABLE_TO_LOAD_VERSIONS_OF = "unable to load versions of ";
    private static final String STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE = "PublicReference and version number are not compatible";
    private static final String STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER = "unable to initialize ApprovalServiceProvider: ";
    private static final String STRING_ALLOBJECTS = "allobjects";
    private static final String STRING_REVIEWER_CODE = "reviewerCode";
    private static final String STRING_INTERNAL_ID = "internalId";
    private static final String STRING_IDENTIFIER_TYPE = "identifierType";
    private static final String STRING_DATE = "date";
    private static final String STRING_ENTITY = "entity";
    private static final String STRING_ALL_ELEMENTS = "allElements";
    private static final String STRING_UNABLE_TO_WRITE_HTML_OUTPUT = "unable to write HTML output";
    private static final String CODING_UTF_8 = "UTF-8";
    private static final String STRING_SERVER_URL = "serverURL";

    VeloCityHtmlGenerator() {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        Velocity.setProperty((String)"input.encoding", (Object)CODING_UTF_8);
        Velocity.setProperty((String)"output.encoding", (Object)CODING_UTF_8);
        Velocity.init();
    }

    protected StringWriter generateEmailForChangedRootUser(InternetAddress newAddress, InternetAddress oldAddress) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("newRoot", (Object)newAddress);
        context.put("oldRoot", (Object)oldAddress);
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/ChangedRootUserEmailTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected StringWriter generateEmailForDoubleOptIn(InternetAddress address, UUID uuid) throws EdalException {
        VelocityContext context = new VelocityContext();
        String url = String.valueOf(EdalJettyServer.getServerURL().toString()) + "/" + EdalHttpFunctions.LOGIN.toString() + "/" + uuid.toString() + "/" + address.getAddress();
        context.put(STRING_SERVER_URL, (Object)url);
        context.put("server", (Object)EdalJettyServer.getServerURL());
        context.put("root", (Object)address);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/DoubleOptInEmailTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected StringWriter generateHtmlForDirectory(PrimaryDataDirectory directory) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put(STRING_ENTITY, (Object)directory);
        context.put(STRING_VERSION, (Object)directory.getCurrentVersion());
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL().toString());
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("title", (Object)EnumDublinCoreElements.TITLE);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("year", (Object)1);
        try {
            context.put(STRING_ALLOBJECTS, directory.listPrimaryDataEntities());
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/DirectoryTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected Writer generateHtmlForDirectoryForReviewer(PrimaryDataDirectory directory, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        Calendar date = null;
        Long publicReferenceDirectorySize = new Long(0L);
        try {
            date = DataManager.getImplProv().getApprovalServiceProvider().newInstance().getPublicReferenceByInternalId(internalId).getCreationDate();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EdalException(STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER + e.getMessage(), e);
        }
        catch (EdalException e) {
            throw e;
        }
        try {
            if (!directory.getVersionByDate(date).equals(directory.getVersionByRevisionNumber(versionNumber))) {
                return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE);
            }
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(STRING_UNABLE_TO_LOAD_VERSIONS_OF + directory + " :" + e.getMessage(), e);
        }
        if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + directory.getID())) {
            publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + directory.getID());
        }
        VelocityContext context = new VelocityContext();
        context.put(STRING_IDENTIFIER_TYPE, (Object)identifierType.toString());
        context.put(STRING_INTERNAL_ID, (Object)internalId);
        context.put(STRING_DATE, (Object)date);
        context.put(STRING_ENTITY, (Object)directory);
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL().toString());
        context.put(STRING_REVIEWER_CODE, (Object)String.valueOf(reviewerCode));
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("size", (Object)DataSize.StorageUnit.of(publicReferenceDirectorySize).format(publicReferenceDirectorySize));
        context.put("SizeList", CalculateDirectorySizeThread.directorySizes);
        context.put("DataSizeClass", DataSize.StorageUnit.class);
        context.put("EnumSize", (Object)EnumDublinCoreElements.SIZE);
        List<PrimaryDataEntity> list = null;
        try {
            list = directory.listPrimaryDataEntities();
            context.put(STRING_ALLOBJECTS, list);
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)teeOutputStream);
        MergingThread thread = new MergingThread("de/ipk_gatersleben/bit/bi/edal/primary_data/DirectoryTemplateForReviewer.xml", CODING_UTF_8, (Context)context, output, latch, list);
        thread.start();
        return output;
    }

    /*
     * Unable to fully structure code
     */
    protected Writer generateHtmlForDirectoryOfSnapshot(PrimaryDataDirectory directory, long versionNumber, String internalId, PersistentIdentifier identifierType, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        block21: {
            date = null;
            try {
                date = DataManager.getImplProv().getApprovalServiceProvider().newInstance().getPublicReferenceByInternalId(internalId).getCreationDate();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new EdalException("unable to initialize ApprovalServiceProvider: " + e.getMessage(), e);
            }
            try {
                if (!directory.getVersionByDate(date).equals(directory.getVersionByRevisionNumber(versionNumber))) {
                    return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "PublicReference and version number are not compatible");
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to load versions of " + directory + " :" + e.getMessage(), e);
            }
            log = DataManager.getImplProv().getLogger();
            currentDirectory = directory;
            primaryDataEntityVersion = null;
            publicReferenceDirectorySize = new Long(0L);
            primaryDataEntityVersion = currentDirectory.getVersionByRevisionNumber(versionNumber);
            foundPublicReference = false;
            try {
                if (primaryDataEntityVersion.getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    currentDirectory.switchCurrentVersion(primaryDataEntityVersion);
                    if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) {
                        publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                    }
                }
                break block21;
            }
            catch (PrimaryDataEntityVersionException e) {
                log.debug((Object)(currentDirectory + " has no " + (Object)identifierType));
                ** while (!foundPublicReference)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    log.debug((Object)("try ParentDirectory '" + currentDirectory.getParentDirectory() + "'"));
                    if (currentDirectory.getParentDirectory() == null) {
                        return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!");
                    }
                    if (!currentDirectory.getParentDirectory().getVersionByDate(date).getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                    if (primaryDataEntityVersion.getRevisionDate().before(date)) {
                        log.debug((Object)(currentDirectory.getParentDirectory() + " has " + (Object)identifierType));
                        foundPublicReference = true;
                        currentDirectory = directory;
                        if (!CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(internalId) + "/" + currentDirectory.getID())) continue;
                        publicReferenceDirectorySize = CalculateDirectorySizeThread.directorySizes.get(String.valueOf(internalId) + "/" + currentDirectory.getID());
                        continue;
                    }
                    return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!");
                }
                catch (PrimaryDataDirectoryException | PrimaryDataEntityVersionException v0) {
                    try {
                        log.debug((Object)("ParentDirectory has no " + (Object)identifierType));
                        foundPublicReference = false;
                        try {
                            currentDirectory = currentDirectory.getParentDirectory();
                            continue;
                        }
                        catch (PrimaryDataDirectoryException v1) {
                            throw new EdalException("unable to get parent directory: " + e.getMessage(), e);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new EdalException("unable to get version by version number: " + e.getMessage(), e);
                    }
                }
            }
        }
        context = new VelocityContext();
        context.put("date", (Object)date);
        context.put("identifierType", (Object)identifierType.toString());
        context.put("internalId", (Object)internalId);
        context.put("entity", (Object)currentDirectory);
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put("serverURL", (Object)EdalJettyServer.getServerURL().toString());
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("size", (Object)DataSize.StorageUnit.of(publicReferenceDirectorySize).format(publicReferenceDirectorySize));
        context.put("SizeList", CalculateDirectorySizeThread.directorySizes);
        context.put("DataSizeClass", DataSize.StorageUnit.class);
        context.put("EnumSize", (Object)EnumDublinCoreElements.SIZE);
        list = null;
        try {
            list = currentDirectory.listPrimaryDataEntities();
            context.put("allobjects", list);
        }
        catch (PrimaryDataDirectoryException e) {
            throw new EdalException("unable to load entity list of the directory", e);
        }
        output = new OutputStreamWriter((OutputStream)teeOutputStream);
        thread = new MergingThread("de/ipk_gatersleben/bit/bi/edal/primary_data/DirectoryTemplateForSnapshot.xml", "UTF-8", (Context)context, output, latch, list);
        thread.start();
        return output;
    }

    protected StringWriter generateHtmlForErrorMessage(HttpStatus.Code responseCode, String message) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("responseCode", (Object)responseCode.getCode());
        context.put("title", (Object)responseCode.getMessage());
        context.put("message", (Object)message);
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/HtmlMessageTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected OutputStreamWriter generateHtmlForReport(String function, HttpStatus.Code responseCode, OutputStream outputStream, CountDownLatch latch) throws Exception {
        HashMap<String, HashSet<String>> accessMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> ipMap = new HashMap<String, HashSet<String>>();
        HashMap<String, Long> downloadedVolume = new HashMap<String, Long>();
        HashMap<String, Long> accessNumbers = new HashMap<String, Long>();
        TreeMap<String, String[]> accessStatistic = new TreeMap<String, String[]>();
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Criteria getFile = session.createCriteria(PublicReferenceImplementation.class);
        List publicReferences = getFile.list();
        session.close();
        Path pathToLogFiles = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log");
        File[] fileArray = pathToLogFiles.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object strLine;
            File file = fileArray[n2];
            FileInputStream is = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((strLine = bufferedReader.readLine()) != null) {
                String ipAddress;
                String publicReferenceId;
                String[] split = ((String)strLine).split("\t");
                if (!split[5].startsWith("GET /DOI/") || (publicReferenceId = split[5].split("/")[2]).length() != 36) continue;
                if (split[5].endsWith("ZIP HTTP/1.1") && split[6].equals("200")) {
                    String directoryId = split[5].split("/")[3];
                    if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(publicReferenceId) + "/" + directoryId)) {
                        if (downloadedVolume.containsKey(publicReferenceId)) {
                            downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        } else {
                            downloadedVolume.put(publicReferenceId, CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        }
                    }
                }
                if (accessMap.containsKey(ipAddress = split[1])) {
                    ((HashSet)accessMap.get(ipAddress)).add(publicReferenceId);
                } else {
                    accessMap.put(ipAddress, new HashSet<String>(Arrays.asList(publicReferenceId)));
                }
                if (downloadedVolume.containsKey(publicReferenceId)) {
                    downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + Long.parseLong(split[7]));
                } else {
                    downloadedVolume.put(publicReferenceId, Long.parseLong(split[7]));
                }
                if (ipMap.containsKey(publicReferenceId)) {
                    ((HashSet)ipMap.get(publicReferenceId)).add(ipAddress);
                    continue;
                }
                ipMap.put(publicReferenceId, new HashSet<String>(Arrays.asList(ipAddress)));
            }
            bufferedReader.close();
            is.close();
            ++n2;
        }
        for (Map.Entry entry : accessMap.entrySet()) {
            for (String string : (HashSet)entry.getValue()) {
                if (accessNumbers.containsKey(string)) {
                    Long number = (Long)accessNumbers.get(string) + 1L;
                    accessNumbers.put(string, number);
                    continue;
                }
                accessNumbers.put(string, new Long(1L));
            }
        }
        for (Map.Entry entry : accessNumbers.entrySet()) {
            PublicReference reference = null;
            try {
                ApprovalServiceProvider appService = DataManager.getImplProv().getApprovalServiceProvider().newInstance();
                reference = appService.getPublicReferenceByInternalId((String)entry.getKey());
            }
            catch (EdalException | IllegalAccessException | IllegalArgumentException | InstantiationException exception) {}
            if (reference == null || reference.getAssignedID() == null) continue;
            if (function != null) {
                if (!reference.getAssignedID().contains(function)) continue;
                accessStatistic.put(reference.getAssignedID(), new String[]{reference.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey())), GenerateLocations.generateGpsLocations((HashSet)ipMap.get(reference.getInternalID()))});
                continue;
            }
            accessStatistic.put(reference.getAssignedID(), new String[]{reference.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey())), GenerateLocations.generateGpsLocations((HashSet)ipMap.get(reference.getInternalID()))});
        }
        ArrayList<String> stringList = new ArrayList<String>();
        long totalAccesses = 0L;
        long totalDownloadVolume = 0L;
        for (Map.Entry entry : accessStatistic.entrySet()) {
            String size = ((String[])entry.getValue())[2] != null ? DataSize.StorageUnit.of(new Long(((String[])entry.getValue())[2])).format(new Long(((String[])entry.getValue())[2])) : "0";
            stringList.add(String.valueOf((String)entry.getKey()) + "\t" + ((String[])entry.getValue())[0] + "\t" + ((String[])entry.getValue())[1] + "\t" + size + "\t" + ((String[])entry.getValue())[3]);
            totalAccesses += Long.valueOf(((String[])entry.getValue())[1]).longValue();
            totalDownloadVolume += Long.valueOf(((String[])entry.getValue())[2]).longValue();
        }
        String string = DataSize.StorageUnit.of(new Long(totalDownloadVolume)).format(totalDownloadVolume);
        VelocityContext context = new VelocityContext();
        context.put("responseCode", (Object)responseCode.getCode());
        context.put("title", (Object)"Request-Statistics");
        context.put("accessStatistic", stringList);
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL());
        if (function == null) {
            context.put("dois", (Object)publicReferences.size());
            context.put("filter", (Object)"ALL");
        } else {
            context.put("dois", (Object)stringList.size());
            context.put("filter", (Object)function);
        }
        context.put("totalAccesses", (Object)totalAccesses);
        context.put("totalDownloadVolume", (Object)string);
        OutputStreamWriter output = new OutputStreamWriter(outputStream);
        MergingThread thread = new MergingThread("de/ipk_gatersleben/bit/bi/edal/primary_data/ReportTemplate.xml", CODING_UTF_8, (Context)context, output, latch, null);
        thread.start();
        return output;
    }

    protected StringWriter generateHtmlForFile(PrimaryDataFile file) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put(STRING_ENTITY, (Object)file);
        context.put(STRING_VERSION, (Object)file.getCurrentVersion());
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL().toString());
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        context.put("title", (Object)EnumDublinCoreElements.TITLE);
        context.put("creator", (Object)EnumDublinCoreElements.CREATOR);
        context.put("format", (Object)EnumDublinCoreElements.FORMAT);
        context.put("year", (Object)1);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)"de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplate.xml", (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException(STRING_UNABLE_TO_WRITE_HTML_OUTPUT, e);
        }
        return output;
    }

    protected Writer generateHtmlForFileForReviewer(PrimaryDataFile file, long versionNumber, String internalId, PersistentIdentifier identifierType, int reviewerCode, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        Calendar date = null;
        try {
            date = DataManager.getImplProv().getApprovalServiceProvider().newInstance().getPublicReferenceByInternalId(internalId).getCreationDate();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EdalException(STRING_UNABLE_TO_INITIALIZE_APPROVAL_SERVICE_PROVIDER + e.getMessage(), e);
        }
        catch (EdalException e) {
            throw e;
        }
        try {
            if (!file.getVersionByDate(date).equals(file.getVersionByRevisionNumber(versionNumber))) {
                return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, STRING_PUBLIC_REFERENCE_AND_VERSION_NUMBER_ARE_NOT_COMPATIBLE);
            }
        }
        catch (PrimaryDataEntityVersionException e) {
            throw new EdalException(STRING_UNABLE_TO_LOAD_VERSIONS_OF + file + " :" + e.getMessage(), e);
        }
        VelocityContext context = new VelocityContext();
        context.put(STRING_IDENTIFIER_TYPE, (Object)identifierType.toString());
        context.put(STRING_INTERNAL_ID, (Object)internalId);
        context.put(STRING_DATE, (Object)date);
        context.put(STRING_ENTITY, (Object)file);
        context.put(STRING_ALL_ELEMENTS, MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put(STRING_SERVER_URL, (Object)EdalJettyServer.getServerURL().toString());
        context.put(STRING_REVIEWER_CODE, (Object)String.valueOf(reviewerCode));
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)teeOutputStream);
        MergingThread thread = new MergingThread("de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplateForReviewer.xml", CODING_UTF_8, (Context)context, output, latch, null);
        thread.start();
        return output;
    }

    /*
     * Unable to fully structure code
     */
    protected Writer generateHtmlForFileOfSnapshot(PrimaryDataFile file, long versionNumber, PersistentIdentifier identifierType, String internalId, TeeOutputStream teeOutputStream, CountDownLatch latch) throws EdalException {
        block21: {
            date = null;
            try {
                date = DataManager.getImplProv().getApprovalServiceProvider().newInstance().getPublicReferenceByInternalId(internalId).getCreationDate();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new EdalException("unable to initialize ApprovalServiceProvider: " + e.getMessage(), e);
            }
            try {
                if (!file.getVersionByDate(date).equals(file.getVersionByRevisionNumber(versionNumber))) {
                    return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "PublicReference and version number are not compatible");
                }
            }
            catch (PrimaryDataEntityVersionException e) {
                throw new EdalException("unable to load versions of " + file + " :" + e.getMessage(), e);
            }
            log = DataManager.getImplProv().getLogger();
            currentFile = file;
            primaryDataEntityVersion = null;
            primaryDataEntityVersion = currentFile.getVersionByRevisionNumber(versionNumber);
            foundPublicReference = false;
            try {
                if (primaryDataEntityVersion.getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    currentFile.switchCurrentVersion(primaryDataEntityVersion);
                }
                break block21;
            }
            catch (PrimaryDataEntityVersionException e) {
                log.debug((Object)(currentFile + " has no " + (Object)identifierType));
                currentDirectory = null;
                try {
                    currentDirectory = currentFile.getParentDirectory();
                }
                catch (PrimaryDataDirectoryException v0) {}
                ** while (!foundPublicReference)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    log.debug((Object)("try ParentDirectory '" + currentDirectory + "'"));
                    if (currentDirectory == null) {
                        return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!");
                    }
                    if (!currentDirectory.getVersionByDate(date).getPublicReference(identifierType).getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                    if (primaryDataEntityVersion.getRevisionDate().before(date)) {
                        log.debug((Object)(currentDirectory + " has " + (Object)identifierType));
                        foundPublicReference = true;
                        currentFile = file;
                        continue;
                    }
                    return this.generateHtmlForErrorMessage(HttpStatus.Code.NOT_FOUND, "No Public Reference for this version set!");
                }
                catch (PrimaryDataEntityVersionException v1) {
                    try {
                        log.debug((Object)("ParentDirectory has no " + (Object)identifierType));
                        foundPublicReference = false;
                        try {
                            if (currentDirectory.getParentDirectory() == null) {
                                throw new EdalException("root Directory arrived -> no reference found" + e.getMessage(), e);
                            }
                            currentDirectory = currentDirectory.getParentDirectory();
                            continue;
                        }
                        catch (PrimaryDataDirectoryException v2) {
                            throw new EdalException("unable to get parent directory: " + e.getMessage(), e);
                        }
                    }
                    catch (PrimaryDataEntityVersionException e) {
                        throw new EdalException("unable to get version by revision number: " + e.getMessage(), e);
                    }
                }
            }
        }
        context = new VelocityContext();
        context.put("identifierType", (Object)identifierType.toString());
        context.put("entity", (Object)file);
        context.put("date", (Object)date);
        context.put("allElements", MetaData.ELEMENT_TYPE_MAP.keySet());
        context.put("serverURL", (Object)EdalJettyServer.getServerURL().toString());
        context.put("internalId", (Object)internalId);
        context.put("description", (Object)EnumDublinCoreElements.DESCRIPTION);
        output = new OutputStreamWriter((OutputStream)teeOutputStream);
        thread = new MergingThread("de/ipk_gatersleben/bit/bi/edal/primary_data/FileTemplateForSnapshot.xml", "UTF-8", (Context)context, output, latch, null);
        thread.start();
        return output;
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStreamWriter generateCSVForReport(String function, String filetype, HttpStatus.Code responseCode, OutputStream responseBody, CountDownLatch latch) throws Exception {
        HashMap<String, HashSet<String>> accessMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> ipMap = new HashMap<String, HashSet<String>>();
        HashMap<String, Long> downloadedVolume = new HashMap<String, Long>();
        HashMap<String, Long> accessNumbers = new HashMap<String, Long>();
        TreeMap<String, String[]> accessStatistic = new TreeMap<String, String[]>();
        Path pathToLogFiles = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "jetty_log");
        File[] fileArray = pathToLogFiles.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strLine;
            File file = fileArray[n2];
            FileInputStream is = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((strLine = br.readLine()) != null) {
                String ipAddress;
                String publicReferenceId;
                String[] split = strLine.split("\t");
                if (!split[5].startsWith("GET /DOI/") || (publicReferenceId = split[5].split("/")[2]).length() != 36) continue;
                if (split[5].endsWith("ZIP HTTP/1.1") && split[6].equals("200")) {
                    String directoryId = split[5].split("/")[3];
                    if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(publicReferenceId) + "/" + directoryId)) {
                        if (downloadedVolume.containsKey(publicReferenceId)) {
                            downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        } else {
                            downloadedVolume.put(publicReferenceId, CalculateDirectorySizeThread.directorySizes.get(String.valueOf(publicReferenceId) + "/" + directoryId));
                        }
                    }
                }
                if (accessMap.containsKey(ipAddress = split[1])) {
                    ((HashSet)accessMap.get(ipAddress)).add(publicReferenceId);
                } else {
                    accessMap.put(ipAddress, new HashSet<String>(Arrays.asList(publicReferenceId)));
                }
                if (downloadedVolume.containsKey(publicReferenceId)) {
                    downloadedVolume.put(publicReferenceId, (Long)downloadedVolume.get(publicReferenceId) + Long.parseLong(split[7]));
                } else {
                    downloadedVolume.put(publicReferenceId, Long.parseLong(split[7]));
                }
                if (ipMap.containsKey(publicReferenceId)) {
                    ((HashSet)ipMap.get(publicReferenceId)).add(ipAddress);
                    continue;
                }
                ipMap.put(publicReferenceId, new HashSet<String>(Arrays.asList(ipAddress)));
            }
            br.close();
            is.close();
            ++n2;
        }
        for (Map.Entry entry : accessMap.entrySet()) {
            for (String string : (HashSet)entry.getValue()) {
                if (accessNumbers.containsKey(string)) {
                    Long number = (Long)accessNumbers.get(string) + 1L;
                    accessNumbers.put(string, number);
                    continue;
                }
                accessNumbers.put(string, new Long(1L));
            }
        }
        for (Map.Entry entry : accessNumbers.entrySet()) {
            void var14_17;
            Object var14_15 = null;
            try {
                ApprovalServiceProvider appService = DataManager.getImplProv().getApprovalServiceProvider().newInstance();
                PublicReference publicReference = appService.getPublicReferenceByInternalId((String)entry.getKey());
            }
            catch (EdalException | IllegalAccessException | IllegalArgumentException | InstantiationException exception) {}
            if (var14_17 == null || var14_17.getAssignedID() == null) continue;
            if (function != null) {
                if (var14_17.getAssignedID().contains(function)) {
                    accessStatistic.put(var14_17.getAssignedID(), new String[]{var14_17.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey()))});
                    continue;
                }
                if (!function.equals("ALL")) continue;
                accessStatistic.put(var14_17.getAssignedID(), new String[]{var14_17.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey()))});
                continue;
            }
            accessStatistic.put(var14_17.getAssignedID(), new String[]{var14_17.getVersion().getMetaData().toString(), String.valueOf(entry.getValue()), String.valueOf(downloadedVolume.get(entry.getKey()))});
        }
        OutputStreamWriter output = new OutputStreamWriter(responseBody);
        CSVPrinter printer = new CSVPrinter((Writer)output, CSVStrategy.DEFAULT_STRATEGY);
        for (Map.Entry entry : accessStatistic.entrySet()) {
            String size = ((String[])entry.getValue())[2] != null ? DataSize.StorageUnit.of(new Long(((String[])entry.getValue())[2])).format(new Long(((String[])entry.getValue())[2])) : "0";
            printer.print((String)entry.getKey(), true);
            printer.print(((String[])entry.getValue())[0], true);
            printer.print(((String[])entry.getValue())[1], true);
            printer.print(size, true);
            printer.println();
            printer.flush();
        }
        latch.countDown();
        return output;
    }
}

