/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpFunctions;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalJettyServer;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.DoiImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewStatusImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewersImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.TicketImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.UrlImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.VeloCityGenerator;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.ApprovalServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewProcess;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewResult;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewStatus;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.exception.VelocityException;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ApprovalServiceProviderImplementation
implements ApprovalServiceProvider {
    private static final String UNABLE_TO_GENERATE_E_MAIL = "unable to generate e-mail";
    private static final String EMAIL_SENDER = "eDAL-Service <" + DataManager.getConfiguration().getEdalEmailAddress() + ">";
    private static final int REMAINDER_CYCLE = 14;
    private static Map<String, PublicReferenceImplementation> synchronizedMap;
    private static VeloCityGenerator velocityGenerator;

    static {
        velocityGenerator = new VeloCityGenerator();
        synchronizedMap = Collections.synchronizedMap(new HashMap());
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        List ticketImplementation = session.createCriteria(TicketImplementation.class).list();
        for (TicketImplementation ticket : ticketImplementation) {
            synchronizedMap.put(ticket.getTicket(), ticket.getReference());
        }
        transaction.commit();
        session.close();
    }

    @Override
    public void accept(String ticket, int reviewerID) throws EdalApprovalException {
        this.changeReviewStatus(ticket, reviewerID, ReviewStatus.ReviewStatusType.ACCEPTED);
    }

    @Override
    public void acceptTicketByUser(String ticket, int reviewerHashCode) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        session.close();
        if (ticketImplementation != null) {
            if (ticketImplementation.getEmailNotificationAddress().hashCode() != reviewerHashCode) {
                throw new EdalApprovalException("wrong ticket number for this reviewer code");
            }
        } else {
            throw new EdalApprovalException("no ticket with this number found");
        }
        ticketImplementation.setUserAnswer(true);
        this.updateTicket(ticketImplementation);
    }

    @Override
    public void approve(PublicReference reference, InternetAddress emailNotificationAddress) throws EdalApprovalException {
        if (reference instanceof PublicReferenceImplementation) {
            PublicReferenceImplementation internalRef = (PublicReferenceImplementation)reference;
            internalRef.setPublicationStatus(PublicationStatus.UNDER_REVIEW);
            ReviewResult result = ReviewProcess.review(new ArrayList<ReviewStatus>());
            HashSet<ReviewStatusImplementation> reviewSet = new HashSet<ReviewStatusImplementation>();
            if (result != null) {
                for (ReviewStatus status : result.getReviewerStatusList()) {
                    org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                    Transaction transaction = session.beginTransaction();
                    ReviewStatusImplementation reviewStatus = new ReviewStatusImplementation();
                    reviewStatus.setPublicReference(internalRef);
                    reviewStatus.setEmailAddress(status.getEmailAddress().getAddress());
                    reviewStatus.setRequestedDate(Calendar.getInstance());
                    reviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
                    reviewStatus.setReviewerType(status.getReviewerType());
                    reviewSet.add(reviewStatus);
                    session.save((Object)reviewStatus);
                    transaction.commit();
                    session.close();
                }
            }
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            internalRef.setReviewStatusSet(reviewSet);
            session.saveOrUpdate((Object)internalRef);
            transaction.commit();
            session.close();
            String ticket = UUID.randomUUID().toString();
            this.storeNewTicket(ticket, reference, emailNotificationAddress);
            synchronizedMap.put(ticket, internalRef);
            try {
                for (ReviewStatus reviewStatus : result.getReviewerStatusList()) {
                    this.sendRequestApprovalMail(ticket, reference, reviewStatus.getEmailAddress(), reviewStatus.getReviewerType());
                }
                this.sendStatusMailToRequestedPerson(emailNotificationAddress, reference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to send requestApprovalEmails", e);
            }
        } else {
            throw new EdalApprovalException("reference object is no instanceof PublicReferenceImplementation");
        }
    }

    private void changeReviewStatus(String ticket, int reviewerCode, ReviewStatus.ReviewStatusType status) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        ReviewersImplementation reviewerImplementation = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)reviewerCode)).uniqueResult();
        if (reviewerImplementation == null) {
            throw new EdalApprovalException("unable to find a reviewer with this code");
        }
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        if (ticketImplementation == null) {
            throw new EdalApprovalException("unable to find a ticket with this code");
        }
        List reviewStatusList = session.createCriteria(ReviewStatusImplementation.class).add((Criterion)Restrictions.eq((String)"emailAddress", (Object)reviewerImplementation.getEmailAddress())).add((Criterion)Restrictions.eq((String)"publicReference", (Object)ticketImplementation.getReference())).list();
        for (ReviewStatusImplementation reviewStatusImplementation : reviewStatusList) {
            reviewStatusImplementation.setStatusType(status);
            session.saveOrUpdate((Object)reviewStatusImplementation);
        }
        session.getTransaction().commit();
        session.close();
    }

    @Override
    public void checkOpenReviewProcesses(Map<PublicReference, List<ReviewStatus>> results) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        for (Map.Entry<PublicReference, List<ReviewStatus>> result : results.entrySet()) {
            TicketImplementation ticket = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"reference", (Object)result.getKey())).uniqueResult();
            DataManager.getImplProv().getLogger().debug((Object)("CheckOpenReviewProcess for Ticket : \t" + ticket.getTicket()));
            try {
                this.updateReviewStatus(result.getKey(), ReviewProcess.review(result.getValue()));
            }
            catch (EdalApprovalException e) {
                throw new EdalApprovalException("unable to check open review processes: " + e.getMessage(), e.getCause());
            }
        }
        session.close();
    }

    private String createLandingPageString(PublicReference reference) {
        return "/" + reference.getIdentifierType().toString() + "/" + reference.getInternalID() + "/" + reference.getVersion().getEntity().getID() + "/" + reference.getVersion().getRevision();
    }

    private URL createLandingPageURL(PublicReferenceImplementation reference) throws EdalApprovalException {
        try {
            return new URL(EdalJettyServer.getServerURL(), this.createLandingPageString(reference));
        }
        catch (EdalException | MalformedURLException e) {
            throw new EdalApprovalException("unable to create URL for the landing page : " + e.getMessage(), e);
        }
    }

    private void deleteReviewStatus(PublicReferenceImplementation reference) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        List reviewStatus = session.createCriteria(ReviewStatusImplementation.class).add((Criterion)Restrictions.eq((String)"publicReference", (Object)reference)).list();
        for (ReviewStatusImplementation reviewStatusImplementation : reviewStatus) {
            session.delete((Object)reviewStatusImplementation);
        }
        session.getTransaction().commit();
        session.close();
    }

    private void deleteTicket(String ticket) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        session.delete((Object)ticketImplementation);
        session.getTransaction().commit();
        session.close();
        EdalJettyHandler.deleteTicketFromHashMap(ticket);
    }

    @Override
    public Map<PublicReference, List<ReviewStatus>> getAllOpenReviewProcesses() {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        List publicReferences = session.createCriteria(PublicReferenceImplementation.class).add(Restrictions.isNull((String)"acceptedDate")).add(Restrictions.isNull((String)"rejectedDate")).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).list();
        DataManager.getImplProv().getLogger().debug((Object)("open PublicReferences : " + publicReferences.size()));
        session.close();
        HashMap<PublicReference, List<ReviewStatus>> openReviewProcesses = new HashMap<PublicReference, List<ReviewStatus>>(publicReferences.size());
        for (PublicReferenceImplementation publicReference : publicReferences) {
            Set<ReviewStatusImplementation> privateSet = publicReference.getReviewStatusSet();
            DataManager.getImplProv().getLogger().debug((Object)("open ReviewStatus : " + privateSet.size()));
            if (privateSet.isEmpty()) continue;
            ArrayList<ReviewStatus> publicSet = new ArrayList<ReviewStatus>(privateSet.size());
            for (ReviewStatusImplementation reviewStatusImplementation : privateSet) {
                publicSet.add(reviewStatusImplementation.toReviewStatus());
            }
            openReviewProcesses.put(publicReference, publicSet);
        }
        DataManager.getImplProv().getLogger().debug((Object)("open ReviewProcesses : " + openReviewProcesses.size()));
        return openReviewProcesses;
    }

    @Override
    public String getNewURL(PublicReference reference) throws EdalApprovalException {
        String url = "";
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        int year = Calendar.getInstance().get(1);
        int numberOfStoredIds = session.createCriteria(UrlImplementation.class).add((Criterion)Restrictions.eq((String)"year", (Object)year)).list().size();
        try {
            url = EdalJettyServer.getServerURL() + "/" + year + "/" + numberOfStoredIds + "/" + ((UntypedData)reference.getVersion().getMetaData().getElementValue(EnumDublinCoreElements.TITLE)).toString();
        }
        catch (EdalException | MetaDataException e) {
            e.printStackTrace();
        }
        PublicReferenceImplementation publicReferenceImplementation = (PublicReferenceImplementation)reference;
        publicReferenceImplementation.setVersion(reference.getVersion());
        publicReferenceImplementation.setAcceptedDate(Calendar.getInstance());
        publicReferenceImplementation.setAssignedID(url);
        publicReferenceImplementation.setPublicationStatus(PublicationStatus.ACCEPTED);
        publicReferenceImplementation.setPublic(true);
        publicReferenceImplementation.setIdentifierType(PersistentIdentifier.URL);
        UrlImplementation urlImplementation = new UrlImplementation();
        urlImplementation.setReference(publicReferenceImplementation);
        urlImplementation.setUrl(url);
        urlImplementation.setYear(year);
        session.update((Object)publicReferenceImplementation);
        session.save((Object)urlImplementation);
        transaction.commit();
        session.close();
        return url;
    }

    @Override
    public PublicReference getPublicReferenceByInternalId(String internalId) throws EdalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        PublicReferenceImplementation publicReference = (PublicReferenceImplementation)session.createCriteria(PublicReferenceImplementation.class).add((Criterion)Restrictions.eq((String)"internalID", (Object)internalId)).uniqueResult();
        session.close();
        if (publicReference != null) {
            return publicReference;
        }
        throw new EdalException("no PublicReference with ID '" + internalId + "' found !");
    }

    @Override
    public void reject(String ticket, int reviewerID) throws EdalApprovalException {
        this.changeReviewStatus(ticket, reviewerID, ReviewStatus.ReviewStatusType.REJECTED);
    }

    @Override
    public void rejectTicketByUser(String ticket, int reviewerHashCode) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
        session.close();
        if (ticketImplementation != null) {
            if (ticketImplementation.getEmailNotificationAddress().hashCode() != reviewerHashCode) {
                throw new EdalApprovalException("wrong ticket number for this reviewer code");
            }
        } else {
            throw new EdalApprovalException("no ticket with this number found");
        }
        ticketImplementation.setUserAnswer(false);
        this.updateTicket(ticketImplementation);
    }

    private void sendAcceptedMail(String newId, String emailAddress, URL landingPage, PublicReference reference) throws EdalApprovalException {
        String message;
        try {
            message = velocityGenerator.generateAcceptedEmail(newId, landingPage, reference).toString();
        }
        catch (VelocityException e) {
            throw new EdalApprovalException(UNABLE_TO_GENERATE_E_MAIL, e);
        }
        this.sendEmail(message, "[e!DAL] data publication released online: " + reference.getVersion().getMetaData().toString(), emailAddress);
    }

    private void sendEmail(String message, String subject, String emailAddress) {
        Session session = null;
        InternetAddress addressFrom = null;
        Properties properties = new Properties();
        properties.put("mail.smtp.host", DataManager.getConfiguration().getMailSmtpHost());
        if (DataManager.getConfiguration().getMailSmtpLogin() == null || DataManager.getConfiguration().getMailSmtpLogin().isEmpty()) {
            session = Session.getDefaultInstance((Properties)properties);
            try {
                addressFrom = new InternetAddress(DataManager.getConfiguration().getEdalEmailAddress(), EMAIL_SENDER);
            }
            catch (UnsupportedEncodingException e) {
                DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
            }
        } else {
            properties.put("mail.smtp.auth", "true");
            Authenticator authenticator = new Authenticator(){
                private PasswordAuthentication authentication = new PasswordAuthentication(DataManager.getConfiguration().getMailSmtpLogin(), DataManager.getConfiguration().getMailSmtpPassword());

                protected PasswordAuthentication getPasswordAuthentication() {
                    return this.authentication;
                }
            };
            session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            try {
                addressFrom = new InternetAddress(DataManager.getConfiguration().getMailSmtpLogin(), EMAIL_SENDER);
            }
            catch (UnsupportedEncodingException e) {
                DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
            }
        }
        MimeMessage mail = new MimeMessage(session);
        try {
            mail.setFrom((Address)addressFrom);
            InternetAddress addressTo = new InternetAddress(emailAddress);
            mail.setRecipient(Message.RecipientType.TO, (Address)addressTo);
            mail.setSubject(subject);
            mail.setContent((Object)message, "text/html; charset=UTF-8");
            Transport.send((Message)mail);
        }
        catch (MessagingException e) {
            DataManager.getConfiguration().getErrorLogger().fatal((Object)(String.valueOf(emailAddress) + " : " + e.getMessage()));
        }
    }

    private void sendRejectedMails(String emailAddress, PublicReference reference) throws EdalApprovalException {
        String message;
        try {
            message = velocityGenerator.generateRejectedEmail(reference).toString();
        }
        catch (VelocityException e) {
            throw new EdalApprovalException(UNABLE_TO_GENERATE_E_MAIL, e);
        }
        this.sendEmail(message, "[e!DAL] - data publication rejected: " + reference.getVersion().getMetaData().toString(), emailAddress);
    }

    private void sendRequestApprovalMail(String ticket, PublicReference reference, InternetAddress emailAddress, ReviewStatus.ReviewerType reviewerType) throws EdalApprovalException {
        DataManager.getImplProv().getLogger().debug((Object)("Send Requestmail :" + emailAddress));
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        int hashCode = emailAddress.getAddress().hashCode();
        ReviewersImplementation reviewer = (ReviewersImplementation)session.createCriteria(ReviewersImplementation.class).add((Criterion)Restrictions.eq((String)"hashCode", (Object)hashCode)).add((Criterion)Restrictions.eq((String)"emailAddress", (Object)emailAddress.getAddress())).uniqueResult();
        if (reviewer == null) {
            reviewer = new ReviewersImplementation(emailAddress.getAddress(), hashCode);
            Transaction transaction = session.beginTransaction();
            session.save((Object)reviewer);
            transaction.commit();
        }
        session.close();
        try {
            StringWriter stringWriter = velocityGenerator.generateRequestEmail(reference.getVersion(), EdalJettyServer.generateMethodURL(ticket, emailAddress.hashCode(), EdalHttpFunctions.ACCEPT), EdalJettyServer.generateMethodURL(ticket, emailAddress.hashCode(), EdalHttpFunctions.REJECT), reference.getRequestedPrincipal(), emailAddress, reviewerType, EdalJettyServer.generateReviewerURL(this.createLandingPageURL((PublicReferenceImplementation)reference), hashCode), reference.getIdentifierType());
            this.sendEmail(stringWriter.toString(), "[e!DAL] review request: " + reference.getVersion().getMetaData().toString(), emailAddress.getAddress());
        }
        catch (EdalException | VelocityException e) {
            throw new EdalApprovalException(UNABLE_TO_GENERATE_E_MAIL, e);
        }
    }

    private void sendReviewSuccessfulMail(TicketImplementation ticket, PublicReference reference) throws EdalApprovalException {
        String message;
        int reviewerCode = ticket.getEmailNotificationAddress().hashCode();
        try {
            message = velocityGenerator.generateReviewSuccessfulMail(EdalJettyServer.generateMethodURL(ticket.getTicket(), reviewerCode, EdalHttpFunctions.USER_ACCEPT), EdalJettyServer.generateMethodURL(ticket.getTicket(), reviewerCode, EdalHttpFunctions.USER_REJECT), EdalJettyServer.generateReviewerURL(this.createLandingPageURL((PublicReferenceImplementation)reference), DataManager.getConfiguration().getReviewerScientific().toString().hashCode()), reference, reviewerCode, 14).toString();
        }
        catch (EdalConfigurationException | EdalException | VelocityException e) {
            throw new EdalApprovalException(UNABLE_TO_GENERATE_E_MAIL, e);
        }
        this.sendEmail(message, "[e!DAL] data publication approved successfully: " + reference.getVersion().getMetaData().toString(), ticket.getEmailNotificationAddress());
    }

    private void sendStatusMailToRequestedPerson(InternetAddress emailAddress, PublicReference reference) throws EdalApprovalException {
        try {
            StringWriter stringWriter = velocityGenerator.generateStatusEmail(reference);
            this.sendEmail(stringWriter.toString(), "[e!DAL] submission under review: " + reference.getVersion().getMetaData().toString(), emailAddress.getAddress());
        }
        catch (VelocityException e) {
            throw new EdalApprovalException(UNABLE_TO_GENERATE_E_MAIL, e);
        }
    }

    private void setPublicReferenceToFalse(String ticket) throws EdalApprovalException {
        PublicReferenceImplementation publicRef = synchronizedMap.get(ticket);
        if (publicRef == null) {
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
            PublicReferenceImplementation publicReference = ticketImplementation.getReference();
            transaction.commit();
            session.close();
            try {
                publicReference.getReferencable().rejectApprovalRequest(publicReference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to reject PublicReference", e);
            }
            org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction2 = session2.beginTransaction();
            publicReference.setRejectedDate(Calendar.getInstance());
            publicReference.setPublicationStatus(PublicationStatus.REJECTED);
            session2.update((Object)publicReference);
            transaction2.commit();
            session2.close();
        } else {
            try {
                publicRef.getReferencable().rejectApprovalRequest(publicRef);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to reject PublicReference", e);
            }
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            publicRef.setRejectedDate(Calendar.getInstance());
            publicRef.setPublicationStatus(PublicationStatus.REJECTED);
            session.update((Object)publicRef);
            transaction.commit();
            session.close();
        }
    }

    private String setPublicReferenceToTrue(String ticket) throws EdalApprovalException {
        PublicReferenceImplementation publicRef = synchronizedMap.get(ticket);
        if (publicRef == null) {
            org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            TicketImplementation ticketImplementation = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"ticket", (Object)ticket)).uniqueResult();
            PublicReferenceImplementation publicReference = ticketImplementation.getReference();
            transaction.commit();
            session.close();
            String newId = "";
            try {
                newId = publicReference.getReferencable().acceptApprovalRequest(publicReference);
            }
            catch (EdalException e) {
                throw new EdalApprovalException("unable to get new ID: " + e.getMessage(), e.getCause());
            }
            org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction2 = session2.beginTransaction();
            publicReference.setAssignedID(newId);
            publicReference.setPublic(true);
            publicReference.setAcceptedDate(Calendar.getInstance());
            publicReference.setPublicationStatus(PublicationStatus.ACCEPTED);
            session2.update((Object)publicReference);
            transaction2.commit();
            session2.close();
            return newId;
        }
        String newId = "";
        try {
            newId = publicRef.getReferencable().acceptApprovalRequest(publicRef);
        }
        catch (EdalException e) {
            throw new EdalApprovalException("unable to get new ID: " + e.getMessage(), e.getCause());
        }
        publicRef.setAssignedID(newId);
        publicRef.setPublic(true);
        publicRef.setAcceptedDate(Calendar.getInstance());
        publicRef.setPublicationStatus(PublicationStatus.ACCEPTED);
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)publicRef);
        transaction.commit();
        session.close();
        return newId;
    }

    @Override
    public String storeNewDOI(PublicReference reference, String doi, int year) throws EdalApprovalException {
        if (reference instanceof PublicReferenceImplementation) {
            PublicReferenceImplementation publicReferenceImplementation = (PublicReferenceImplementation)reference;
            publicReferenceImplementation.setVersion(reference.getVersion());
            publicReferenceImplementation.setAcceptedDate(Calendar.getInstance());
            publicReferenceImplementation.setAssignedID(doi);
            publicReferenceImplementation.setPublicationStatus(PublicationStatus.ACCEPTED);
            publicReferenceImplementation.setPublic(true);
            publicReferenceImplementation.setIdentifierType(reference.getIdentifierType());
            DoiImplementation doiImplementation = new DoiImplementation();
            doiImplementation.setReference(publicReferenceImplementation);
            doiImplementation.setUrl(doi);
            doiImplementation.setYear(year);
            try {
                org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                Transaction transaction = session.beginTransaction();
                session.saveOrUpdate((Object)publicReferenceImplementation);
                transaction.commit();
                session.close();
                org.hibernate.Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
                Transaction transaction2 = session2.beginTransaction();
                session2.save((Object)doiImplementation);
                transaction2.commit();
                session2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return doi;
        }
        throw new EdalApprovalException("reference object is no instanceof PublicReferenceImplementation");
    }

    private void storeNewTicket(String ticket, PublicReference reference, InternetAddress emailNotificationAddress) {
        PublicReferenceImplementation publicReference = (PublicReferenceImplementation)reference;
        publicReference.setRequestedDate(Calendar.getInstance());
        publicReference.setLandingPage(this.createLandingPageString(reference));
        TicketImplementation ticketImplementation = new TicketImplementation(ticket, publicReference, emailNotificationAddress.getAddress());
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)publicReference);
        session.save((Object)ticketImplementation);
        transaction.commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReviewStatus(PublicReference publicReference, ReviewResult result) throws EdalApprovalException {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        TicketImplementation ticket = (TicketImplementation)session.createCriteria(TicketImplementation.class).add((Criterion)Restrictions.eq((String)"reference", (Object)publicReference)).uniqueResult();
        session.close();
        switch (result.getReviewResult()) {
            case ACCEPTED: {
                Calendar timePoint = Calendar.getInstance();
                if (ticket.isUserAnswer() == null) {
                    if (ticket.getUserReminderEmailSend() != null && timePoint.getTimeInMillis() - ticket.getUserReminderEmailSend().getTimeInMillis() <= 1209600000L) break;
                    this.sendReviewSuccessfulMail(ticket, publicReference);
                    ticket.setUserReminderEmailSend(timePoint);
                    this.updateTicket(ticket);
                    break;
                }
                Map<String, PublicReferenceImplementation> map = synchronizedMap;
                synchronized (map) {
                    if (ticket.isUserAnswer().booleanValue()) {
                        if (synchronizedMap.containsKey(ticket.getTicket())) {
                            String newId = "";
                            try {
                                newId = this.setPublicReferenceToTrue(ticket.getTicket());
                            }
                            catch (EdalException e) {
                                throw new EdalApprovalException("unable to set PublicReference to TRUE: " + e.getMessage(), e.getCause());
                            }
                            this.deleteReviewStatus(ticket.getReference());
                            this.deleteTicket(ticket.getTicket());
                            try {
                                this.sendAcceptedMail(newId, ticket.getEmailNotificationAddress(), this.createLandingPageURL(ticket.getReference()), publicReference);
                            }
                            catch (EdalApprovalException e) {
                                throw new EdalApprovalException("unable to send Accepted-Email: " + e.getMessage(), e.getCause());
                            }
                            synchronizedMap.remove(ticket.getTicket());
                        }
                    } else {
                        try {
                            this.setPublicReferenceToFalse(ticket.getTicket());
                        }
                        catch (EdalApprovalException e) {
                            throw new EdalApprovalException("unable to set PublicReference to FALSE: " + e.getMessage(), e.getCause());
                        }
                        try {
                            this.sendRejectedMails(ticket.getEmailNotificationAddress(), publicReference);
                        }
                        catch (EdalApprovalException e) {
                            throw new EdalApprovalException("unable to send Rejected-Email: " + e.getMessage(), e.getCause());
                        }
                        this.deleteReviewStatus(ticket.getReference());
                        this.deleteTicket(ticket.getTicket());
                        synchronizedMap.remove(ticket.getTicket());
                        ServiceProvider service = null;
                        try {
                            service = DataManager.getImplProv().getServiceProvider().newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            DataManager.getImplProv().getLogger().error((Object)e);
                            throw new EdalApprovalException("Unable to load ApprovalServiceProvider: " + e.getMessage(), e.getCause());
                        }
                        service.cleanUp();
                    }
                    break;
                }
            }
            case REJECTED: {
                Map<String, PublicReferenceImplementation> map = synchronizedMap;
                synchronized (map) {
                    try {
                        this.setPublicReferenceToFalse(ticket.getTicket());
                    }
                    catch (EdalApprovalException e) {
                        throw new EdalApprovalException("unable to set PublicReference to FALSE: " + e.getMessage(), e.getCause());
                    }
                    try {
                        this.sendRejectedMails(ticket.getEmailNotificationAddress(), publicReference);
                    }
                    catch (EdalApprovalException e) {
                        throw new EdalApprovalException("unable to send Rejected-Email: " + e.getMessage(), e.getCause());
                    }
                    this.deleteReviewStatus(ticket.getReference());
                    this.deleteTicket(ticket.getTicket());
                    synchronizedMap.remove(ticket.getTicket());
                    ServiceProvider service = null;
                    try {
                        service = DataManager.getImplProv().getServiceProvider().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        DataManager.getImplProv().getLogger().error((Object)e);
                        throw new EdalApprovalException("Unable to load ApprovalServiceProvider: " + e.getMessage(), e.getCause());
                    }
                    service.cleanUp();
                    break;
                }
            }
            case UNDECIDED: {
                Calendar now = Calendar.getInstance();
                if (now.getTimeInMillis() - ticket.getReminderEmailSend().getTimeInMillis() <= 1209600000L) break;
                for (ReviewStatus reviewStatus : result.getReviewerStatusList()) {
                    if (!reviewStatus.getStatusType().equals((Object)ReviewStatus.ReviewStatusType.UNDECIDED)) continue;
                    try {
                        this.sendRequestApprovalMail(ticket.getTicket(), ticket.getReference(), reviewStatus.getEmailAddress(), reviewStatus.getReviewerType());
                    }
                    catch (EdalApprovalException e) {
                        throw new EdalApprovalException("unable to send notification email to reviewer " + reviewStatus.getEmailAddress(), e.getCause());
                    }
                }
                ticket.setReminderEmailSend(now);
                this.updateTicket(ticket);
                break;
            }
        }
    }

    private void updateTicket(TicketImplementation ticket) {
        org.hibernate.Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)ticket);
        transaction.commit();
        session.close();
    }
}

