/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeJob;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

public class CalculateDirectorySizeThread
extends Thread {
    private static final int INTERVAL_TO_REPEAT_JOB = 24;
    private static Scheduler scheduler;
    public static Map<String, Long> directorySizes;

    static {
        directorySizes = new HashMap<String, Long>();
    }

    public void done() {
        try {
            this.getScheduler().shutdown(true);
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().info((Object)"unable to stop CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    @Override
    public void run() {
        DataManager.getImplProv().getLogger().info((Object)"Starting CalculateDirectorySizeThread");
        Scheduler defaultQuartzScheduler = SchedulerRepository.getInstance().lookup("DefaultQuartzScheduler");
        if (defaultQuartzScheduler == null) {
            try {
                Scheduler std = new StdSchedulerFactory().getScheduler();
                CalculateDirectorySizeThread.setScheduler(std);
            }
            catch (SchedulerException e) {
                DataManager.getImplProv().getLogger().warn((Object)"unable to create new CalculateDirectorySizeThreadScheduler", (Throwable)e);
            }
        } else {
            CalculateDirectorySizeThread.setScheduler(defaultQuartzScheduler);
        }
        try {
            this.getScheduler().start();
            JobDetail job = JobBuilder.newJob(CalculateDirectorySizeJob.class).build();
            Trigger trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever()).build();
            this.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            DataManager.getImplProv().getLogger().warn((Object)"unable to start CalculateDirectorySizeThreadScheduler", (Throwable)e);
        }
    }

    private static void setScheduler(Scheduler scheduler) {
        CalculateDirectorySizeThread.scheduler = scheduler;
    }
}

