/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDCMIDataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.IdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Subjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UnknownMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MetaData
implements Cloneable,
Serializable {
    protected static final String UNKNOWN_STRING = "unknown";
    public static final EnumMap<EnumDublinCoreElements, List<Class<? extends UntypedData>>> ELEMENT_TYPE_MAP = new EnumMap(EnumDublinCoreElements.class);
    private static final long serialVersionUID = 1L;
    public static final UntypedData EMPTY;
    public static final UntypedData UNKNOWN;
    public static final UntypedData DIRECTORY;
    protected EnumMap<? super EnumDublinCoreElements, UntypedData> metaDataValues = this.constructEmptyMetaDataMap();

    static {
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.CHECKSUM, new ArrayList<Class>(Arrays.asList(CheckSum.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.CONTRIBUTOR, new ArrayList<Class>(Arrays.asList(Persons.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.COVERAGE, new ArrayList<Class>(Arrays.asList(UntypedData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.CREATOR, new ArrayList<Class>(Arrays.asList(Persons.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.DATE, new ArrayList<Class>(Arrays.asList(DateEvents.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.DESCRIPTION, new ArrayList<Class>(Arrays.asList(UntypedData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.FORMAT, new ArrayList<Class>(Arrays.asList(DataFormat.class, DirectoryMetaData.class, EmptyMetaData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.IDENTIFIER, new ArrayList<Class>(Arrays.asList(Identifier.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.LANGUAGE, new ArrayList<Class>(Arrays.asList(EdalLanguage.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.PUBLISHER, new ArrayList<Class>(Arrays.asList(LegalPerson.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.RELATION, new ArrayList<Class>(Arrays.asList(IdentifierRelation.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.RIGHTS, new ArrayList<Class>(Arrays.asList(UntypedData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.SIZE, new ArrayList<Class>(Arrays.asList(DataSize.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.SOURCE, new ArrayList<Class>(Arrays.asList(UntypedData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.SUBJECT, new ArrayList<Class>(Arrays.asList(Subjects.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.TITLE, new ArrayList<Class>(Arrays.asList(UntypedData.class)));
        ELEMENT_TYPE_MAP.put(EnumDublinCoreElements.TYPE, new ArrayList<Class>(Arrays.asList(DataType.class, DirectoryMetaData.class, EmptyMetaData.class)));
        EMPTY = new EmptyMetaData();
        UNKNOWN = new UnknownMetaData();
        DIRECTORY = new DirectoryMetaData();
    }

    protected MetaData() {
    }

    public MetaData clone() throws CloneNotSupportedException {
        Constructor<?> cons = null;
        MetaData clone = null;
        try {
            cons = this.getClass().getConstructor(null);
            clone = (MetaData)cons.newInstance(null);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("unable to clone: can not load constructor for metadata object");
        }
        EnumMap<? super EnumDublinCoreElements, UntypedData> copy = this.constructEmptyMetaDataMap();
        for (Map.Entry<? super EnumDublinCoreElements, UntypedData> entry : this.metaDataValues.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        clone.metaDataValues = copy;
        return clone;
    }

    private EnumMap<? super EnumDublinCoreElements, UntypedData> constructEmptyMetaDataMap() {
        EnumMap<EnumDublinCoreElements, UntypedData> newmap = new EnumMap<EnumDublinCoreElements, UntypedData>(EnumDublinCoreElements.class);
        newmap = new EnumMap(EnumDublinCoreElements.class);
        newmap.put(EnumDublinCoreElements.CHECKSUM, new CheckSum());
        newmap.put(EnumDublinCoreElements.CONTRIBUTOR, new Persons());
        newmap.put(EnumDublinCoreElements.COVERAGE, new UntypedData());
        newmap.put(EnumDublinCoreElements.CREATOR, new Persons());
        newmap.put(EnumDublinCoreElements.DATE, new DateEvents(""));
        newmap.put(EnumDublinCoreElements.DESCRIPTION, new UntypedData());
        newmap.put(EnumDublinCoreElements.FORMAT, new DataFormat());
        newmap.put(EnumDublinCoreElements.IDENTIFIER, new Identifier());
        newmap.put(EnumDublinCoreElements.LANGUAGE, new EdalLanguage(Locale.getDefault()));
        newmap.put(EnumDublinCoreElements.PUBLISHER, new LegalPerson("", "", "", ""));
        newmap.put(EnumDublinCoreElements.RELATION, new IdentifierRelation());
        newmap.put(EnumDublinCoreElements.RIGHTS, new UntypedData());
        newmap.put(EnumDublinCoreElements.SIZE, new DataSize());
        newmap.put(EnumDublinCoreElements.SOURCE, new UntypedData());
        newmap.put(EnumDublinCoreElements.SUBJECT, new Subjects());
        newmap.put(EnumDublinCoreElements.TITLE, new UntypedData("Default-TITLE"));
        newmap.put(EnumDublinCoreElements.TYPE, new DataType(EnumDCMIDataType.TEXT));
        return newmap;
    }

    public boolean equals(Object object) {
        if (object instanceof MetaData) {
            MetaData otherMetaData = (MetaData)object;
            for (Map.Entry<? super EnumDublinCoreElements, UntypedData> entry : this.metaDataValues.entrySet()) {
                try {
                    if (entry.getValue().compareTo((UntypedData)otherMetaData.getElementValue(EnumDublinCoreElements.valueOf(((Object)((Object)entry.getKey())).toString()))) == 0) continue;
                    return false;
                }
                catch (MetaDataException e) {
                    DataManager.getImplProv().getLogger().error((Object)e);
                }
            }
        }
        return true;
    }

    public <T extends UntypedData> T getElementValue(Enum<? extends EnumDublinCoreElements> element) throws MetaDataException {
        if (!this.metaDataValues.containsKey(element)) {
            throw new MetaDataException("no value for metadata element " + element);
        }
        UntypedData ret = null;
        try {
            ret = this.metaDataValues.get(element);
        }
        catch (ClassCastException ex) {
            throw new MetaDataException(ex);
        }
        return (T)ret;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.metaDataValues == null ? 0 : this.metaDataValues.hashCode());
        return result;
    }

    public void setElementValue(EnumDublinCoreElements key, UntypedData value) throws MetaDataException {
        List<Class<? extends UntypedData>> datatype = ELEMENT_TYPE_MAP.get((Object)key);
        if (!datatype.contains(value.getClass())) {
            throw new MetaDataException("It is not allowed to set a '" + value.getClass().getSimpleName() + "' datatype for the element '" + (Object)((Object)key) + "'");
        }
        try {
            this.metaDataValues.put(key, value);
        }
        catch (Exception e) {
            throw new MetaDataException("unable to set metadata element : " + e);
        }
    }

    public String toString() {
        EnumMap<? super EnumDublinCoreElements, UntypedData> data = this.metaDataValues;
        StringBuffer sb = new StringBuffer();
        Persons persons = (Persons)data.get((Object)EnumDublinCoreElements.CREATOR);
        Person creator = null;
        NaturalPerson creator_natural = null;
        LegalPerson creator_legal = null;
        if (persons.size() > 0) {
            creator = (Person)persons.toArray()[0];
            if (creator instanceof NaturalPerson) {
                creator_natural = (NaturalPerson)creator;
            } else {
                creator_legal = (LegalPerson)creator;
            }
        }
        UntypedData title = data.get((Object)EnumDublinCoreElements.TITLE);
        DateEvents de = (DateEvents)data.get((Object)EnumDublinCoreElements.DATE);
        EdalDate date = de.isEmpty() ? null : (EdalDate)de.toArray()[0];
        data.get((Object)EnumDublinCoreElements.FORMAT);
        sb.append(creator_natural != null ? String.valueOf(creator_natural.getGivenName().length() > 0 ? String.valueOf(creator_natural.getGivenName().substring(0, 1)) + ". " : "") + (creator_natural.getSureName().length() > 0 ? String.valueOf(creator_natural.getSureName()) + (persons.size() > 1 ? " et al. " : " ") : UNKNOWN_STRING) : (creator_legal != null ? (creator_legal.getLegalName().length() > 0 ? creator_legal.getLegalName() : UNKNOWN_STRING) : UNKNOWN_STRING));
        sb.append(" (");
        if (date != null) {
            sb.append(String.format("%tF", date.getStartDate()));
        } else {
            sb.append("null");
        }
        sb.append("): ");
        sb.append(title.toString());
        if (!title.toString().endsWith(".")) {
            sb.append(". ");
        } else {
            sb.append(" ");
        }
        DataSize size = (DataSize)data.get((Object)EnumDublinCoreElements.SIZE);
        if (!(data.get((Object)EnumDublinCoreElements.TYPE) instanceof DirectoryMetaData)) {
            sb.append("Size: " + size);
        }
        return sb.toString();
    }
}

