/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.XmlFunctions;
import javax.ws.rs.core.MediaType;
import org.w3c.dom.Document;

public class DataCiteMDSConnector {
    private static final String DOI_URL = "https://mds.datacite.org/doi";
    private static final String METADATA_URL = "https://mds.datacite.org/metadata";
    private static final String DOI_TEST_URL = "https://test.datacite.org/mds/doi";
    private static final String METADATA_TEST_URL = "https://test.datacite.org/mds/metadata";
    private static final int GOOD_RESPONSE = 201;
    private static String dataCiteUser = "";
    private static String dataCitePassword = "";
    private static String dataCiteTestUser = "TIB";
    private static String dataCiteTestPassword = "edal0815";
    private String prefix = "";
    private static boolean testModus = false;
    private WebResource webResource = null;
    private final Client dataCiteClient;

    public DataCiteMDSConnector(EdalConfiguration configuration) throws EdalException {
        if (configuration.isUseSystemProxies()) {
            try {
                System.setProperty("http.proxyHost", configuration.getHttpProxyHost());
                System.setProperty("http.proxyPort", String.valueOf(configuration.getHttpProxyPort()));
                System.setProperty("https.proxyHost", configuration.getHttpsProxyHost());
                System.setProperty("https.proxyPort", String.valueOf(configuration.getHttpsProxyPort()));
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (EdalConfigurationException e) {
                throw new EdalException(e);
            }
        }
        if (configuration.isInTestMode()) {
            testModus = true;
            this.dataCiteClient = Client.create();
            this.dataCiteClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(dataCiteTestUser, dataCiteTestPassword));
        } else {
            try {
                dataCiteUser = configuration.getDataCiteUser();
                dataCitePassword = configuration.getDataCitePassword();
            }
            catch (EdalConfigurationException e) {
                throw new EdalException("unable to init Configuration : " + e.getMessage(), e);
            }
            this.dataCiteClient = Client.create();
            this.dataCiteClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(dataCiteUser, dataCitePassword));
        }
        try {
            this.prefix = configuration.getDataCitePrefix();
        }
        catch (EdalConfigurationException e) {
            throw new EdalException("unable to load DataCite Prefix", e);
        }
    }

    public ClientResponse getDOI(String doi) {
        this.webResource = testModus ? this.dataCiteClient.resource(DOI_TEST_URL) : this.dataCiteClient.resource(DOI_URL);
        ClientResponse response = (ClientResponse)this.webResource.path("/" + doi).accept(new String[]{"text/html"}).get(ClientResponse.class);
        return response;
    }

    public ClientResponse getMetadata(String doi) {
        this.webResource = testModus ? this.dataCiteClient.resource(METADATA_TEST_URL) : this.dataCiteClient.resource(METADATA_URL);
        ClientResponse response = (ClientResponse)this.webResource.path("/" + doi).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ClientResponse.class);
        return response;
    }

    public ClientResponse postDOI(String doi, String url) throws DataCiteException {
        ClientResponse response;
        String requestBody;
        this.webResource = testModus ? this.dataCiteClient.resource(DOI_TEST_URL) : this.dataCiteClient.resource(DOI_URL);
        String newRequestbody = requestBody = "doi=" + doi + "\r\n" + "url=" + url;
        if (requestBody.contains("bit-252")) {
            newRequestbody = requestBody.replace("bit-252", "doi");
        }
        if ((response = (ClientResponse)((WebResource.Builder)this.webResource.type(MediaType.TEXT_PLAIN_TYPE + ";charset=utf-8").entity((Object)newRequestbody)).post(ClientResponse.class)).getStatus() != 201) {
            throw new DataCiteException(response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    public ClientResponse postMetadata(Document xml) throws DataCiteException {
        this.webResource = testModus ? this.dataCiteClient.resource(METADATA_TEST_URL) : this.dataCiteClient.resource(METADATA_URL);
        String requestBody = XmlFunctions.toString(xml);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.webResource.type(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8").entity((Object)requestBody)).post(ClientResponse.class);
        if (response.getStatus() != 201) {
            throw new DataCiteException(response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    public int getNextFreeDOI(int year, int startDoi, String datacentre) {
        this.webResource = testModus ? this.dataCiteClient.resource(DOI_TEST_URL) : this.dataCiteClient.resource(DOI_URL);
        boolean isDoiFree = false;
        while (!isDoiFree) {
            ClientResponse response = (ClientResponse)this.webResource.path("/" + this.prefix + "/" + datacentre + "/" + year + "/" + String.valueOf(startDoi)).accept(new String[]{"text/html"}).get(ClientResponse.class);
            if (response.getStatus() != 200) break;
            ++startDoi;
        }
        return startDoi;
    }
}

