/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="sizes")
public class XmlSizes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> sizeList = new ArrayList<String>();

    public void addSize(long bytes) throws IndexOutOfBoundsException {
        this.sizeList.add(this.humanReadableByteCount(bytes, true));
    }

    public void addSize(String size) throws IndexOutOfBoundsException {
        this.sizeList.add(size);
    }

    public void addSize(int index, String size) throws IndexOutOfBoundsException {
        this.sizeList.add(index, size);
    }

    public Iterator<? extends String> enumerateSize() {
        return this.sizeList.iterator();
    }

    public String getSize(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sizeList.size()) {
            throw new IndexOutOfBoundsException("getSize: Index value '" + index + "' not in range [0.." + (this.sizeList.size() - 1) + "]");
        }
        return this.sizeList.get(index);
    }

    public String[] getSize() {
        String[] array = new String[]{};
        return this.sizeList.toArray(array);
    }

    public int getSizeCount() {
        return this.sizeList.size();
    }

    public void removeAllSize() {
        this.sizeList.clear();
    }

    public boolean removeSize(String size) {
        return this.sizeList.remove(size);
    }

    public String removeSizeAt(int index) {
        return this.sizeList.remove(index);
    }

    public void setSize(int index, String size) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sizeList.size()) {
            throw new IndexOutOfBoundsException("setSize: Index value '" + index + "' not in range [0.." + (this.sizeList.size() - 1) + "]");
        }
        this.sizeList.set(index, size);
    }

    public void setSize(String[] sizeArray) {
        this.sizeList.clear();
        int i = 0;
        while (i < sizeArray.length) {
            this.sizeList.add(sizeArray[i]);
            ++i;
        }
    }

    private String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

